/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.control.ExpandBooleanPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class ExpandBooleanIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new ExpandBooleanPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        GrStatement containingStatement;
        if (element == null) {
            ExpandBooleanIntention.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ExpandBooleanIntention.$$$reportNull$$$0(1);
        }
        if (ExpandBooleanPredicate.isBooleanAssignment(containingStatement = (GrStatement)element)) {
            GrAssignmentExpression assignmentExpression = (GrAssignmentExpression)containingStatement;
            GrExpression rhs = assignmentExpression.getRValue();
            assert (rhs != null);
            String rhsText = rhs.getText();
            GrExpression lhs = assignmentExpression.getLValue();
            String lhsText = lhs.getText();
            @NonNls String statement = "if(" + rhsText + "){\n" + lhsText + " = true\n}else{\n" + lhsText + " = false\n}";
            PsiImplUtil.replaceStatement(statement, containingStatement);
        } else if (ExpandBooleanPredicate.isBooleanReturn(containingStatement)) {
            GrReturnStatement returnStatement = (GrReturnStatement)containingStatement;
            GrExpression returnValue = returnStatement.getReturnValue();
            String valueText = returnValue.getText();
            @NonNls String statement = "if(" + valueText + "){\nreturn true\n}else{\nreturn false\n}";
            PsiImplUtil.replaceStatement(statement, containingStatement);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/intentions/control/ExpandBooleanIntention";
        objectArray[2] = "processIntention";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

