/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.OriginInfoAwareElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.DelegatingScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrGdkMethodImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;
import org.jetbrains.plugins.groovy.lang.psi.util.GrImportUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.api.CallParameter;
import org.jetbrains.plugins.groovy.lang.resolve.api.CallSignature;
import org.jetbrains.plugins.groovy.lang.resolve.noncode.MixinMemberContributor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MultiProcessor;
import org.jetbrains.plugins.groovy.lang.typing.GroovyClosureType;

public final class GdkMethodUtil {
    @NonNls
    public static final Set<String> COLLECTION_METHOD_NAMES = Set.of("each", "eachWithIndex", "any", "every", "reverseEach", "collect", "collectAll", "find", "findAll", "retainAll", "removeAll", "split", "groupBy", "groupEntriesBy", "findLastIndexOf", "findIndexValues", "findIndexOf");
    @NlsSafe
    private static final String WITH = "with";
    @NlsSafe
    private static final String IDENTITY = "identity";
    @NlsSafe
    private static final String TAP = "tap";
    @NlsSafe
    public static final String EACH_WITH_INDEX = "eachWithIndex";
    @NlsSafe
    public static final String INJECT = "inject";
    @NlsSafe
    public static final String EACH_PERMUTATION = "eachPermutation";
    @NlsSafe
    public static final String WITH_DEFAULT = "withDefault";
    @NlsSafe
    public static final String SORT = "sort";
    @NlsSafe
    public static final String WITH_STREAM = "withStream";
    @NlsSafe
    public static final String WITH_STREAMS = "withStreams";
    @NlsSafe
    public static final String WITH_OBJECT_STREAMS = "withObjectStreams";
    private static final Map<String, String> AST_TO_EXPR_MAPPER = Map.of("org.codehaus.groovy.ast.expr.ClosureExpression", "groovy.lang.Closure", "org.codehaus.groovy.ast.expr.ListExpression", "java.util.List", "org.codehaus.groovy.ast.expr.MapExpression", "java.util.Map", "org.codehaus.groovy.ast.expr.TupleExpression", "groovy.lang.Tuple", "org.codehaus.groovy.ast.expr.MethodCallExpression", "java.lang.Object");
    private static final String MACRO_ORIGIN_INFO = "Macro method";

    private GdkMethodUtil() {
    }

    public static boolean processCategoryMethods(PsiElement place, PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiClass categoryClass) {
        if (state == null) {
            GdkMethodUtil.$$$reportNull$$$0(0);
        }
        if (categoryClass == null) {
            GdkMethodUtil.$$$reportNull$$$0(1);
        }
        for (final PsiScopeProcessor psiScopeProcessor : MultiProcessor.allProcessors(processor)) {
            DelegatingScopeProcessor delegate = new DelegatingScopeProcessor(psiScopeProcessor){

                public boolean execute(@NotNull PsiElement element, @NotNull ResolveState delegateState) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (delegateState == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (element instanceof PsiMethod && GdkMethodUtil.isCategoryMethod((PsiMethod)element, null, null, null)) {
                        PsiMethod method = (PsiMethod)element;
                        return psiScopeProcessor.execute((PsiElement)GrGdkMethodImpl.createGdkMethod(method, false, GdkMethodUtil.generateOriginInfo(method)), delegateState);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "delegateState";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/plugins/groovy/lang/psi/util/GdkMethodUtil$1";
                    objectArray[2] = "execute";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            if (categoryClass.processDeclarations((PsiScopeProcessor)delegate, state, null, place)) continue;
            return false;
        }
        return true;
    }

    public static boolean isInWithContext(PsiElement resolveContext) {
        PsiMethod method;
        PsiElement pparent;
        PsiElement parent2;
        return resolveContext instanceof GrExpression && (parent2 = resolveContext.getParent()) instanceof GrReferenceExpression && ((GrReferenceExpression)parent2).getQualifier() == resolveContext && (pparent = parent2.getParent()) instanceof GrMethodCall && (method = ((GrMethodCall)pparent).resolveMethod()) instanceof GrGdkMethod && GdkMethodUtil.isWithName(method.getName());
    }

    public static boolean isWithName(String name) {
        return WITH.equals(name) || IDENTITY.equals(name) || TAP.equals(name);
    }

    @Nullable
    @NonNls
    public static String generateOriginInfo(PsiMethod method) {
        PsiClass cc = method.getContainingClass();
        if (cc == null) {
            return null;
        }
        return "via " + cc.getName();
    }

    public static boolean processMixinToMetaclass(GrStatementOwner run, PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        GrStatement[] statements2;
        if (!ResolveUtilKt.shouldProcessMethods(processor)) {
            return true;
        }
        for (GrStatement statement : statements2 = run.getStatements()) {
            if (statement == lastParent) break;
            Trinity<PsiClassType, GrReferenceExpression, PsiClass> result2 = GdkMethodUtil.getMixinTypes(statement);
            if (result2 != null) {
                PsiClassType subjectType = (PsiClassType)result2.first;
                GrReferenceExpression qualifier = (GrReferenceExpression)result2.second;
                PsiClass mixin = (PsiClass)result2.third;
                for (PsiScopeProcessor psiScopeProcessor : MultiProcessor.allProcessors(processor)) {
                    if (mixin.processDeclarations((PsiScopeProcessor)new MixinMemberContributor.MixinProcessor(psiScopeProcessor, (PsiType)subjectType, qualifier), state, null, place)) continue;
                    return false;
                }
                continue;
            }
            Trinity<PsiClassType, GrReferenceExpression, List<GrMethod>> closureResult = GdkMethodUtil.getClosureMixins(statement);
            if (closureResult == null) continue;
            PsiClassType subjectType = (PsiClassType)closureResult.first;
            GrReferenceExpression qualifier = (GrReferenceExpression)closureResult.second;
            List methods = (List)closureResult.third;
            MixinMemberContributor.MixinProcessor mixinProcessor = new MixinMemberContributor.MixinProcessor(processor, (PsiType)subjectType, qualifier);
            for (GrMethod method : methods) {
                ResolveUtil.processElement((PsiScopeProcessor)mixinProcessor, (PsiNamedElement)method, state);
            }
        }
        return true;
    }

    @NotNull
    private static GrMethod createMethod(@NotNull CallSignature<?> signature, @NotNull String name, @NotNull GrAssignmentExpression statement, @NotNull PsiClass closure) {
        if (signature == null) {
            GdkMethodUtil.$$$reportNull$$$0(2);
        }
        if (name == null) {
            GdkMethodUtil.$$$reportNull$$$0(3);
        }
        if (statement == null) {
            GdkMethodUtil.$$$reportNull$$$0(4);
        }
        if (closure == null) {
            GdkMethodUtil.$$$reportNull$$$0(5);
        }
        GrLightMethodBuilder builder = new GrLightMethodBuilder(statement.getManager(), name);
        int i = 0;
        for (CallParameter parameter : signature.getParameters()) {
            String parameterName = (String)ObjectUtils.notNull((Object)parameter.getParameterName(), (Object)("p" + i));
            PsiType type2 = (PsiType)ObjectUtils.notNull((Object)parameter.getType(), () -> TypesUtil.getJavaLangObject(statement));
            builder.addParameter(parameterName, type2, parameter.isOptional());
            ++i;
        }
        builder.setNavigationElement(statement.getLValue());
        builder.setReturnType(signature.getReturnType());
        builder.setContainingClass(closure);
        GrLightMethodBuilder grLightMethodBuilder = builder;
        if (grLightMethodBuilder == null) {
            GdkMethodUtil.$$$reportNull$$$0(6);
        }
        return grLightMethodBuilder;
    }

    private static Trinity<PsiClassType, GrReferenceExpression, List<GrMethod>> getClosureMixins(GrStatement statement) {
        if (!(statement instanceof GrAssignmentExpression)) {
            return null;
        }
        return (Trinity)CachedValuesManager.getCachedValue((PsiElement)statement, () -> CachedValueProvider.Result.create(GdkMethodUtil.doGetClosureMixins((GrAssignmentExpression)statement), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private static Trinity<PsiClassType, GrReferenceExpression, List<GrMethod>> doGetClosureMixins(@NotNull GrAssignmentExpression assignment) {
        GrExpression lValue;
        if (assignment == null) {
            GdkMethodUtil.$$$reportNull$$$0(7);
        }
        if (!((lValue = assignment.getLValue()) instanceof GrReferenceExpression)) {
            return null;
        }
        String mixedMethodName = ((GrReferenceExpression)lValue).getReferenceName();
        if (mixedMethodName == null) {
            return null;
        }
        GrExpression metaClassExpression = (GrExpression)((GrReferenceExpression)lValue).getQualifier();
        if (!(metaClassExpression instanceof GrReferenceExpression)) {
            return null;
        }
        GrExpression rValue = assignment.getRValue();
        if (rValue == null) {
            return null;
        }
        PsiElement resolved = ((GrReferenceExpression)metaClassExpression).resolve();
        if (!(resolved instanceof PsiMethod) || !GdkMethodUtil.isMetaClassMethod((PsiMethod)resolved)) {
            return null;
        }
        GrExpression classQualifier = (GrExpression)((GrReferenceExpression)metaClassExpression).getQualifier();
        Pair<PsiClassType, GrReferenceExpression> original = GdkMethodUtil.getPsiClassFromReference(classQualifier);
        if (original == null) {
            return null;
        }
        PsiType type2 = rValue.getType();
        if (!(type2 instanceof GroovyClosureType)) {
            return null;
        }
        PsiClass closure = JavaPsiFacade.getInstance((Project)assignment.getProject()).findClass("groovy.lang.Closure", assignment.getResolveScope());
        if (closure == null) {
            return null;
        }
        ArrayList<GrMethod> methods = new ArrayList<GrMethod>();
        for (CallSignature<?> signature : ((GroovyClosureType)type2).getSignatures()) {
            methods.add(GdkMethodUtil.createMethod(signature, mixedMethodName, assignment, closure));
        }
        return Trinity.create((Object)((PsiClassType)original.first), (Object)((GrReferenceExpression)original.second), methods);
    }

    @Nullable
    private static Trinity<PsiClassType, GrReferenceExpression, PsiClass> getMixinTypes(GrStatement statement) {
        if (!(statement instanceof GrMethodCall)) {
            return null;
        }
        return (Trinity)CachedValuesManager.getCachedValue((PsiElement)statement, () -> {
            GrMethodCall call = (GrMethodCall)statement;
            Pair<PsiClassType, GrReferenceExpression> original = GdkMethodUtil.getTypeToMixIn(call);
            if (original == null) {
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            PsiClass mix = GdkMethodUtil.getTypeToMix(call);
            if (mix == null) {
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            return CachedValueProvider.Result.create((Object)new Trinity((Object)((PsiClassType)original.first), (Object)((GrReferenceExpression)original.second), (Object)mix), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @Nullable
    private static PsiClass getTypeToMix(GrMethodCall call) {
        PsiElement resolved;
        if (!GdkMethodUtil.isSingleExpressionArg(call)) {
            return null;
        }
        GrExpression mixinRef = call.getExpressionArguments()[0];
        if (GdkMethodUtil.isClassRef(mixinRef)) {
            mixinRef = (GrExpression)((GrReferenceExpression)mixinRef).getQualifier();
        }
        if (mixinRef instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)mixinRef).resolve()) instanceof PsiClass) {
            return (PsiClass)resolved;
        }
        return null;
    }

    private static boolean isSingleExpressionArg(@NotNull GrMethodCall call) {
        if (call == null) {
            GdkMethodUtil.$$$reportNull$$$0(8);
        }
        return call.getExpressionArguments().length == 1 && !PsiImplUtil.hasNamedArguments(call.getArgumentList()) && !call.hasClosureArguments();
    }

    @Nullable
    private static Pair<PsiClassType, GrReferenceExpression> getTypeToMixIn(GrMethodCall methodCall) {
        PsiElement resolved;
        GrExpression invoked = methodCall.getInvokedExpression();
        if (!(invoked instanceof GrReferenceExpression)) {
            return null;
        }
        GrReferenceExpression referenceExpression = (GrReferenceExpression)invoked;
        if (GrImportUtil.acceptName(referenceExpression, "mixin") && (resolved = referenceExpression.resolve()) instanceof PsiMethod && GdkMethodUtil.isMixinMethod((PsiMethod)resolved)) {
            GrExpression qualifier = referenceExpression.getQualifierExpression();
            Pair<PsiClassType, GrReferenceExpression> type2 = GdkMethodUtil.getPsiClassFromReference(qualifier);
            if (type2 != null) {
                return type2;
            }
            if (qualifier != null && GdkMethodUtil.isMetaClass(qualifier.getType())) {
                if (qualifier instanceof GrMethodCall) {
                    qualifier = ((GrMethodCall)qualifier).getInvokedExpression();
                }
                if (qualifier instanceof GrReferenceExpression) {
                    GrExpression qqualifier = ((GrReferenceExpression)qualifier).getQualifierExpression();
                    if (qqualifier != null) {
                        Pair<PsiClassType, GrReferenceExpression> type1 = GdkMethodUtil.getPsiClassFromMetaClassReference(qqualifier);
                        if (type1 != null) {
                            return type1;
                        }
                    } else {
                        PsiType qtype = PsiImplUtil.getQualifierType((GrReferenceExpression)qualifier);
                        if (qtype instanceof PsiClassType && ((PsiClassType)qtype).resolve() != null) {
                            return Pair.create((Object)((PsiClassType)qtype), (Object)((GrReferenceExpression)qualifier));
                        }
                    }
                }
            }
        }
        return null;
    }

    private static boolean isMixinMethod(@NotNull PsiMethod method) {
        if (method == null) {
            GdkMethodUtil.$$$reportNull$$$0(9);
        }
        if (method instanceof GrGdkMethod) {
            method = ((GrGdkMethod)method).getStaticMethod();
        }
        PsiClass containingClass = method.getContainingClass();
        String name = method.getName();
        return "mixin".equals(name) && containingClass != null && "org.codehaus.groovy.runtime.DefaultGroovyMethods".equals(containingClass.getQualifiedName());
    }

    private static boolean isMetaClassMethod(@NotNull PsiMethod method) {
        if (method == null) {
            GdkMethodUtil.$$$reportNull$$$0(10);
        }
        if (method instanceof GrGdkMethod) {
            method = ((GrGdkMethod)method).getStaticMethod();
        }
        PsiClass containingClass = method.getContainingClass();
        String name = method.getName();
        return "getMetaClass".equals(name) && containingClass != null && method.getParameterList().isEmpty() ^ "org.codehaus.groovy.runtime.DefaultGroovyMethods".equals(containingClass.getQualifiedName());
    }

    private static boolean isMetaClass(PsiType qualifierType) {
        return qualifierType != null && qualifierType.equalsToText("groovy.lang.MetaClass");
    }

    private static boolean isClassRef(GrExpression mixinRef) {
        return mixinRef instanceof GrReferenceExpression && "class".equals(((GrReferenceExpression)mixinRef).getReferenceName());
    }

    @Nullable
    private static Pair<PsiClassType, GrReferenceExpression> getPsiClassFromReference(@Nullable GrExpression ref) {
        if (ref == null) {
            return null;
        }
        PsiType type2 = ResolveUtil.unwrapClassType(ref.getType());
        if (!(type2 instanceof PsiClassType)) {
            return null;
        }
        if (GdkMethodUtil.isClassRef(ref)) {
            ref = (GrExpression)((GrReferenceExpression)ref).getQualifier();
        }
        if (!(ref instanceof GrReferenceExpression)) {
            return null;
        }
        return Pair.create((Object)((PsiClassType)type2), (Object)((GrReferenceExpression)ref));
    }

    private static Pair<PsiClassType, GrReferenceExpression> getPsiClassFromMetaClassReference(@NotNull GrExpression expression) {
        PsiType type2;
        if (expression == null) {
            GdkMethodUtil.$$$reportNull$$$0(11);
        }
        if (!((type2 = expression.getType()) instanceof PsiClassType)) {
            return null;
        }
        GrReferenceExpression ref = expression instanceof GrReferenceExpression ? (GrReferenceExpression)expression : null;
        return Pair.create((Object)((PsiClassType)type2), (Object)ref);
    }

    public static boolean isCategoryMethod(@NotNull PsiMethod method, @Nullable PsiType qualifierType, @Nullable PsiElement place, @Nullable PsiSubstitutor substitutor2) {
        if (method == null) {
            GdkMethodUtil.$$$reportNull$$$0(12);
        }
        if (!method.hasModifierProperty("static")) {
            return false;
        }
        if (!method.hasModifierProperty("public")) {
            return false;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length == 0) {
            return false;
        }
        if (qualifierType == null) {
            return true;
        }
        PsiType selfType = parameters2[0].getType();
        if (selfType instanceof PsiPrimitiveType) {
            return false;
        }
        if (substitutor2 != null) {
            selfType = substitutor2.substitute(selfType);
        }
        if (PsiTypesUtil.classNameEquals((PsiType)selfType, (String)"java.lang.Class") && place instanceof GrReferenceExpression && ((GrReferenceExpression)place).resolve() instanceof PsiClass) {
            return TypesUtil.isAssignableByMethodCallConversion(selfType, TypesUtil.createJavaLangClassType(qualifierType, (PsiElement)method), (PsiElement)method);
        }
        return TypesUtil.isAssignableByMethodCallConversion(selfType, qualifierType, (PsiElement)method);
    }

    @Nullable
    public static PsiClassType getCategoryType(final @NotNull PsiClass categoryAnnotationOwner) {
        if (categoryAnnotationOwner == null) {
            GdkMethodUtil.$$$reportNull$$$0(13);
        }
        return (PsiClassType)CachedValuesManager.getCachedValue((PsiElement)categoryAnnotationOwner, (CachedValueProvider)new CachedValueProvider<PsiClassType>(){

            public CachedValueProvider.Result<PsiClassType> compute() {
                return CachedValueProvider.Result.create((Object)this.inferCategoryType(categoryAnnotationOwner), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }

            @Nullable
            private PsiClassType inferCategoryType(PsiClass aClass) {
                return (PsiClassType)RecursionManager.doPreventingRecursion((Object)aClass, (boolean)true, (Computable)((NullableComputable)() -> {
                    PsiModifierList modifierList = aClass.getModifierList();
                    if (modifierList == null) {
                        return null;
                    }
                    PsiAnnotation annotation = modifierList.findAnnotation("groovy.lang.Category");
                    if (annotation == null) {
                        return null;
                    }
                    PsiAnnotationMemberValue value = annotation.findAttributeValue("value");
                    if (!(value instanceof GrReferenceExpression)) {
                        return null;
                    }
                    if ("class".equals(((GrReferenceExpression)value).getReferenceName())) {
                        value = (PsiAnnotationMemberValue)((GrReferenceExpression)value).getQualifier();
                    }
                    if (!(value instanceof GrReferenceExpression)) {
                        return null;
                    }
                    PsiElement resolved = ((GrReferenceExpression)value).resolve();
                    if (!(resolved instanceof PsiClass)) {
                        return null;
                    }
                    String className = ((PsiClass)resolved).getQualifiedName();
                    if (className == null) {
                        className = ((PsiClass)resolved).getName();
                    }
                    if (className == null) {
                        return null;
                    }
                    return JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createTypeByFQClassName(className, resolved.getResolveScope());
                }));
            }
        });
    }

    public static boolean isWithOrIdentity(@Nullable PsiElement element) {
        if (element instanceof PsiMethod && GdkMethodUtil.isWithName(((PsiMethod)element).getName())) {
            PsiClass containingClass;
            if (element instanceof GrGdkMethod) {
                element = ((GrGdkMethod)element).getStaticMethod();
            }
            if ((containingClass = ((PsiMethod)element).getContainingClass()) != null && "org.codehaus.groovy.runtime.DefaultGroovyMethods".equals(containingClass.getQualifiedName())) {
                return true;
            }
        }
        return false;
    }

    public static PsiMethod createMacroMethod(@NotNull PsiMethod prototype) {
        if (prototype == null) {
            GdkMethodUtil.$$$reportNull$$$0(14);
        }
        GrLightMethodBuilder syntheticMacro = new GrLightMethodBuilder(prototype.getManager(), prototype.getName());
        syntheticMacro.setModifiers(new String[]{"static"});
        PsiParameterList list = prototype.getParameterList();
        for (int i = 1; i < list.getParametersCount(); ++i) {
            String name;
            String generatedParameterType;
            PsiParameter actualParameter = list.getParameter(i);
            if (actualParameter == null) {
                generatedParameterType = "java.lang.Object";
                name = "expression";
            } else {
                PsiType type2 = actualParameter.getType();
                generatedParameterType = !type2.equals(PsiType.NULL) ? AST_TO_EXPR_MAPPER.getOrDefault(type2.getCanonicalText(), "java.lang.Object") : "java.lang.Object";
                name = actualParameter.getName();
            }
            syntheticMacro.addParameter(new GrLightParameter(name, (PsiType)PsiType.getTypeByName((String)generatedParameterType, (Project)prototype.getProject(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)prototype.getProject())), (PsiElement)prototype));
        }
        syntheticMacro.setNavigationElement((PsiElement)prototype);
        syntheticMacro.setOriginInfo(MACRO_ORIGIN_INFO);
        return syntheticMacro;
    }

    public static boolean isMacro(@Nullable PsiMethod method) {
        return method instanceof OriginInfoAwareElement && MACRO_ORIGIN_INFO.equals(((OriginInfoAwareElement)method).getOriginInfo());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "categoryClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/util/GdkMethodUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "categoryAnnotationOwner";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prototype";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/util/GdkMethodUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processCategoryMethods";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createMethod";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doGetClosureMixins";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSingleExpressionArg";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isMixinMethod";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isMetaClassMethod";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPsiClassFromMetaClassReference";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isCategoryMethod";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCategoryType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createMacroMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

