/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.lang.ASTNode;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.lang.jvm.types.JvmArrayType;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.GroovyElementFilter;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrOperatorExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiTreeUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u001a\u0010\u0010\r\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\f\u001a\n\u0010\u000f\u001a\u00020\u0006*\u00020\u0010\u001a\n\u0010\u0011\u001a\u00020\u0006*\u00020\u0007\u001a\n\u0010\u0012\u001a\u00020\u0006*\u00020\u0013\u001a\n\u0010\u0014\u001a\u00020\u0006*\u00020\f\u001a\f\u0010\u0015\u001a\u00020\u0006*\u0004\u0018\u00010\u0010\u001a\f\u0010\u0016\u001a\u00020\u0006*\u0004\u0018\u00010\u0010\u001a\f\u0010\u0017\u001a\u00020\u0006*\u0004\u0018\u00010\u0010\u001a\n\u0010\u0018\u001a\u00020\u0006*\u00020\f\u001a\n\u0010\u0019\u001a\u00020\u0006*\u00020\u001a\u001a\u0017\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c*\u00020\u001e\u00a2\u0006\u0002\u0010\u001f\u001a\u000e\u0010 \u001a\u0004\u0018\u00010\u0010*\u0004\u0018\u00010\u0010\u001a\"\u0010!\u001a\u0004\u0018\u00010\f*\u00020\f2\u0014\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\f0#\u001a\f\u0010$\u001a\u0004\u0018\u00010\f*\u00020\f\u001a\f\u0010%\u001a\u0004\u0018\u00010\f*\u00020\f\"!\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\b\u00a8\u0006&"}, d2={"EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lorg/jetbrains/plugins/groovy/lang/GroovyElementFilter;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "isEffectivelyVarArgs", "", "Lcom/intellij/psi/PsiMethod;", "(Lcom/intellij/psi/PsiMethod;)Z", "elementInfo", "", "element", "Lcom/intellij/psi/PsiElement;", "modifierListMayBeEmpty", "owner", "isApplicationExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "isClosureCall", "isFake", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyPsiElement;", "isNewLine", "isNullLiteral", "isSuperExpression", "isThisExpression", "isWhiteSpaceOrNewLine", "mayContainTypeArguments", "Lorg/jetbrains/plugins/groovy/lang/psi/api/types/GrCodeReferenceElement;", "multiResolve", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrOperatorExpression;", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrOperatorExpression;)[Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "skipParenthesesDownOrNull", "skipWhiteSpacesAndNewLines", "next", "Lkotlin/Function1;", "skipWhiteSpacesAndNewLinesBackward", "skipWhiteSpacesAndNewLinesForward", "intellij.groovy.psi"})
public final class PsiUtilKt {
    private static final ExtensionPointName<GroovyElementFilter> EP_NAME;

    public static final boolean modifierListMayBeEmpty(@Nullable PsiElement owner) {
        PsiElement psiElement = owner;
        if (psiElement instanceof GrParameter) {
            PsiElement psiElement2;
            PsiElement it = psiElement2 = ((GrParameter)owner).getParent();
            boolean bl = false;
            if (it instanceof GrParameterList) {
                return true;
            }
            if (it instanceof GrForInClause) {
                PsiElement psiElement3 = ((GrForInClause)it).getDelimiter();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"it.delimiter");
                ASTNode aSTNode = psiElement3.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"it.delimiter.node");
                if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)GroovyTokenTypes.kIN)) {
                    return true;
                }
            }
            return ((GrParameter)owner).getTypeElementGroovy() != null;
        }
        return psiElement instanceof GrMethod ? ((GrMethod)owner).isConstructor() || ((GrMethod)owner).getReturnTypeElementGroovy() != null && !((GrMethod)owner).hasTypeParameters() : (psiElement instanceof GrVariable ? ((GrVariable)owner).getTypeElementGroovy() != null : (psiElement instanceof GrVariableDeclaration ? ((GrVariableDeclaration)owner).getTypeElementGroovy() != null : true));
    }

    public static final boolean isSuperExpression(@Nullable GrExpression $this$isSuperExpression) {
        PsiElement psiElement;
        return $this$isSuperExpression instanceof GrReferenceExpression && ((psiElement = ((GrReferenceExpression)$this$isSuperExpression).getReferenceNameElement()) != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null) == GroovyTokenTypes.kSUPER;
    }

    public static final boolean isThisExpression(@Nullable GrExpression $this$isThisExpression) {
        PsiElement psiElement;
        return $this$isThisExpression instanceof GrReferenceExpression && ((psiElement = ((GrReferenceExpression)$this$isThisExpression).getReferenceNameElement()) != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null) == GroovyTokenTypes.kTHIS;
    }

    @NotNull
    public static final GroovyResolveResult[] multiResolve(@NotNull GrOperatorExpression $this$multiResolve) {
        Intrinsics.checkNotNullParameter((Object)$this$multiResolve, (String)"$this$multiResolve");
        GroovyResolveResult[] groovyResolveResultArray = $this$multiResolve.getReference();
        if (groovyResolveResultArray == null || (groovyResolveResultArray = groovyResolveResultArray.multiResolve(false)) == null) {
            groovyResolveResultArray = GroovyResolveResult.EMPTY_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)GroovyResolveResult.EMPTY_ARRAY, (String)"GroovyResolveResult.EMPTY_ARRAY");
        }
        return groovyResolveResultArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isEffectivelyVarArgs(@NotNull PsiMethod $this$isEffectivelyVarArgs) {
        Intrinsics.checkNotNullParameter((Object)$this$isEffectivelyVarArgs, (String)"$this$isEffectivelyVarArgs");
        if ($this$isEffectivelyVarArgs.isVarArgs()) return true;
        Object[] objectArray = $this$isEffectivelyVarArgs.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"parameters");
        JvmParameter jvmParameter = (JvmParameter)ArraysKt.lastOrNull((Object[])objectArray);
        if (!((jvmParameter != null ? jvmParameter.getType() : null) instanceof JvmArrayType)) return false;
        return true;
    }

    @NonNls
    @NotNull
    public static final String elementInfo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return "Element: " + element + "; class: " + element.getClass() + "; text: " + element.getText();
    }

    public static final boolean mayContainTypeArguments(@NotNull GrCodeReferenceElement $this$mayContainTypeArguments) {
        Intrinsics.checkNotNullParameter((Object)$this$mayContainTypeArguments, (String)"$this$mayContainTypeArguments");
        PsiElement $this$skipParentsOfType$iv = $this$mayContainTypeArguments;
        boolean $i$f$skipParentsOfType = false;
        Pair<PsiElement, PsiElement> pair = PsiTreeUtilKt.skipParentsOfType($this$skipParentsOfType$iv, true, GrCodeReferenceElement.class);
        if (pair == null) {
            return true;
        }
        Pair<PsiElement, PsiElement> pair2 = pair;
        PsiElement parent2 = (PsiElement)pair2.component1();
        return !(parent2 instanceof GrImportStatement);
    }

    public static final boolean isNullLiteral(@Nullable GrExpression $this$isNullLiteral) {
        return $this$isNullLiteral instanceof GrLiteral && Intrinsics.areEqual((Object)GrLiteralImpl.getLiteralType((GrLiteral)$this$isNullLiteral), (Object)GroovyElementTypes.KW_NULL);
    }

    @Nullable
    public static final GrExpression skipParenthesesDownOrNull(@Nullable GrExpression $this$skipParenthesesDownOrNull) {
        GrExpression current = $this$skipParenthesesDownOrNull;
        while (current instanceof GrParenthesizedExpression) {
            current = ((GrParenthesizedExpression)current).getOperand();
        }
        return current;
    }

    public static final boolean isFake(@NotNull GroovyPsiElement $this$isFake) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isFake, (String)"$this$isFake");
            List list = EP_NAME.getExtensionList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"EP_NAME.extensionList");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GroovyElementFilter it = (GroovyElementFilter)element$iv;
                    boolean bl2 = false;
                    if (!it.isFake($this$isFake)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isClosureCall(@NotNull PsiMethod $this$isClosureCall) {
        Intrinsics.checkNotNullParameter((Object)$this$isClosureCall, (String)"$this$isClosureCall");
        if (!Intrinsics.areEqual((Object)$this$isClosureCall.getName(), (Object)"call")) return false;
        PsiClass psiClass = $this$isClosureCall.getContainingClass();
        if (!Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"groovy.lang.Closure")) return false;
        return true;
    }

    public static final boolean isApplicationExpression(@NotNull GrExpression $this$isApplicationExpression) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isApplicationExpression, (String)"$this$isApplicationExpression");
        GrExpression grExpression = $this$isApplicationExpression;
        if (grExpression instanceof GrApplicationStatement) {
            bl = true;
        } else if (grExpression instanceof GrReferenceExpression) {
            bl = ((GrReferenceExpression)$this$isApplicationExpression).isQualified() && ((GrReferenceExpression)$this$isApplicationExpression).getDotTokenType() == null;
        } else if (grExpression instanceof GrMethodCallExpression) {
            GrExpression grExpression2 = ((GrMethodCallExpression)$this$isApplicationExpression).getInvokedExpression();
            Intrinsics.checkNotNullExpressionValue((Object)grExpression2, (String)"invokedExpression");
            bl = PsiUtilKt.isApplicationExpression(grExpression2);
        } else if (grExpression instanceof GrIndexProperty) {
            GrExpression grExpression3 = ((GrIndexProperty)$this$isApplicationExpression).getInvokedExpression();
            Intrinsics.checkNotNullExpressionValue((Object)grExpression3, (String)"invokedExpression");
            bl = PsiUtilKt.isApplicationExpression(grExpression3);
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isNewLine(@NotNull PsiElement $this$isNewLine) {
        Intrinsics.checkNotNullParameter((Object)$this$isNewLine, (String)"$this$isNewLine");
        ASTNode aSTNode = $this$isNewLine.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node");
        return Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)GroovyElementTypes.NL);
    }

    public static final boolean isWhiteSpaceOrNewLine(@NotNull PsiElement $this$isWhiteSpaceOrNewLine) {
        Intrinsics.checkNotNullParameter((Object)$this$isWhiteSpaceOrNewLine, (String)"$this$isWhiteSpaceOrNewLine");
        ASTNode aSTNode = $this$isWhiteSpaceOrNewLine.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node");
        return TokenSets.WHITE_SPACES_SET.contains(aSTNode.getElementType());
    }

    @Nullable
    public static final PsiElement skipWhiteSpacesAndNewLinesBackward(@NotNull PsiElement $this$skipWhiteSpacesAndNewLinesBackward) {
        Intrinsics.checkNotNullParameter((Object)$this$skipWhiteSpacesAndNewLinesBackward, (String)"$this$skipWhiteSpacesAndNewLinesBackward");
        return PsiUtilKt.skipWhiteSpacesAndNewLines($this$skipWhiteSpacesAndNewLinesBackward, (Function1<? super PsiElement, ? extends PsiElement>)((Function1)skipWhiteSpacesAndNewLinesBackward.1.INSTANCE));
    }

    @Nullable
    public static final PsiElement skipWhiteSpacesAndNewLinesForward(@NotNull PsiElement $this$skipWhiteSpacesAndNewLinesForward) {
        Intrinsics.checkNotNullParameter((Object)$this$skipWhiteSpacesAndNewLinesForward, (String)"$this$skipWhiteSpacesAndNewLinesForward");
        return PsiUtilKt.skipWhiteSpacesAndNewLines($this$skipWhiteSpacesAndNewLinesForward, (Function1<? super PsiElement, ? extends PsiElement>)((Function1)skipWhiteSpacesAndNewLinesForward.1.INSTANCE));
    }

    @Nullable
    public static final PsiElement skipWhiteSpacesAndNewLines(@NotNull PsiElement $this$skipWhiteSpacesAndNewLines, @NotNull Function1<? super PsiElement, ? extends PsiElement> next) {
        Intrinsics.checkNotNullParameter((Object)$this$skipWhiteSpacesAndNewLines, (String)"$this$skipWhiteSpacesAndNewLines");
        Intrinsics.checkNotNullParameter(next, (String)"next");
        Function1 function1 = next;
        Function function = new Function(function1){
            private final /* synthetic */ Function1 function;
            {
                this.function = function1;
            }

            public final /* synthetic */ Object apply(Object p0) {
                return this.function.invoke(p0);
            }
        };
        Object object = skipWhiteSpacesAndNewLines.1.INSTANCE;
        if (object != null) {
            function1 = object;
            object = new Predicate(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ boolean test(Object p0) {
                    Object object = this.function.invoke(p0);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
                    return (Boolean)object;
                }
            };
        }
        return PsiTreeUtil.skipMatching((PsiElement)$this$skipWhiteSpacesAndNewLines, (Function)function, (Predicate)((Predicate)object));
    }

    static {
        ExtensionPointName extensionPointName = ExtensionPointName.create((String)"org.intellij.groovy.elementFilter");
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"ExtensionPointName.creat\u2026ij.groovy.elementFilter\")");
        EP_NAME = extensionPointName;
    }
}

