/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.refactoring.util.RefactoringConflictsUtilImpl;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public final class GrRefactoringConflictsUtil {
    private GrRefactoringConflictsUtil() {
    }

    public static void analyzeAccessibilityConflicts(@NotNull Set<? extends GrMember> membersToMove, @NotNull PsiClass targetClass, @NotNull MultiMap<PsiElement, String> conflicts, @Nullable String newVisibility) {
        if (membersToMove == null) {
            GrRefactoringConflictsUtil.$$$reportNull$$$0(0);
        }
        if (targetClass == null) {
            GrRefactoringConflictsUtil.$$$reportNull$$$0(1);
        }
        if (conflicts == null) {
            GrRefactoringConflictsUtil.$$$reportNull$$$0(2);
        }
        GrRefactoringConflictsUtil.analyzeAccessibilityConflicts(membersToMove, targetClass, conflicts, newVisibility, (PsiElement)targetClass, null);
    }

    public static void analyzeAccessibilityConflicts(@NotNull Set<? extends GrMember> membersToMove, @Nullable PsiClass targetClass, @NotNull MultiMap<PsiElement, String> conflicts, @Nullable String newVisibility, @NotNull PsiElement context, @Nullable Set<? extends PsiMethod> abstractMethods) {
        if (membersToMove == null) {
            GrRefactoringConflictsUtil.$$$reportNull$$$0(3);
        }
        if (conflicts == null) {
            GrRefactoringConflictsUtil.$$$reportNull$$$0(4);
        }
        if (context == null) {
            GrRefactoringConflictsUtil.$$$reportNull$$$0(5);
        }
        if ("EscalateVisible".equals(newVisibility)) {
            newVisibility = "public";
        }
        for (GrMember grMember : membersToMove) {
            GrRefactoringConflictsUtil.checkUsedElements(grMember, grMember, membersToMove, abstractMethods, targetClass, context, conflicts);
            RefactoringConflictsUtilImpl.checkAccessibilityConflictsAfterMove((PsiMember)grMember, (String)newVisibility, (PsiClass)targetClass, membersToMove, conflicts, (Condition)Conditions.alwaysTrue());
        }
    }

    public static void checkUsedElements(PsiMember member, PsiElement scope, @NotNull Set<? extends GrMember> membersToMove, @Nullable Set<? extends PsiMethod> abstractMethods, @Nullable PsiClass targetClass, @NotNull PsiElement context, MultiMap<PsiElement, String> conflicts) {
        PsiElement refElement;
        GrReferenceElement<GrExpression> refExpr;
        if (membersToMove == null) {
            GrRefactoringConflictsUtil.$$$reportNull$$$0(6);
        }
        if (context == null) {
            GrRefactoringConflictsUtil.$$$reportNull$$$0(7);
        }
        HashSet<? extends GrMember> moving = new HashSet<GrMember>(membersToMove);
        if (abstractMethods != null) {
            moving.addAll(abstractMethods);
        }
        if (scope instanceof GrReferenceExpression) {
            refExpr = (GrReferenceExpression)scope;
            refElement = refExpr.resolve();
            if (refElement instanceof PsiMember && !RefactoringHierarchyUtil.willBeInTargetClass((PsiElement)refElement, moving, (PsiClass)targetClass, (boolean)false)) {
                GrExpression qualifier = refExpr.getQualifierExpression();
                PsiClass accessClass = (PsiClass)(qualifier != null ? PsiUtil.getAccessObjectClass(qualifier).getElement() : null);
                RefactoringConflictsUtilImpl.analyzeAccessibilityAfterMove((PsiMember)((PsiMember)refElement), (PsiElement)context, (PsiClass)accessClass, (PsiMember)member, conflicts);
            }
        } else if (scope instanceof GrNewExpression) {
            GrNewExpression newExpression = (GrNewExpression)scope;
            GrAnonymousClassDefinition anonymousClass = newExpression.getAnonymousClassDefinition();
            if (anonymousClass != null) {
                if (!RefactoringHierarchyUtil.willBeInTargetClass((PsiElement)anonymousClass, moving, (PsiClass)targetClass, (boolean)false)) {
                    RefactoringConflictsUtilImpl.analyzeAccessibilityAfterMove((PsiMember)anonymousClass, (PsiElement)context, (PsiClass)anonymousClass, (PsiMember)member, conflicts);
                }
            } else {
                PsiMethod refElement2 = newExpression.resolveMethod();
                if (refElement2 != null && !RefactoringHierarchyUtil.willBeInTargetClass((PsiElement)refElement2, moving, (PsiClass)targetClass, (boolean)false)) {
                    RefactoringConflictsUtilImpl.analyzeAccessibilityAfterMove((PsiMember)refElement2, (PsiElement)context, null, (PsiMember)member, conflicts);
                }
            }
        } else if (scope instanceof GrCodeReferenceElement && (refElement = (refExpr = (GrCodeReferenceElement)scope).resolve()) instanceof PsiMember && !RefactoringHierarchyUtil.willBeInTargetClass((PsiElement)refElement, moving, (PsiClass)targetClass, (boolean)false)) {
            RefactoringConflictsUtilImpl.analyzeAccessibilityAfterMove((PsiMember)((PsiMember)refElement), (PsiElement)context, null, (PsiMember)member, conflicts);
        }
        for (PsiElement child : scope.getChildren()) {
            if (child instanceof PsiWhiteSpace || child instanceof PsiComment) continue;
            GrRefactoringConflictsUtil.checkUsedElements(member, child, membersToMove, abstractMethods, targetClass, context, conflicts);
        }
    }

    public static void analyzeModuleConflicts(Project project, Collection<? extends PsiElement> scopes, UsageInfo[] usages, PsiElement target, MultiMap<PsiElement, String> conflicts) {
        if (scopes == null) {
            return;
        }
        VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)target);
        if (vFile == null) {
            return;
        }
        List groovyScopes = ContainerUtil.collect(scopes.iterator(), (FilteringIterator.InstanceOf)new FilteringIterator.InstanceOf(GroovyPsiElement.class));
        GrRefactoringConflictsUtil.analyzeModuleConflicts(project, groovyScopes, usages, vFile, conflicts);
        scopes.removeAll(groovyScopes);
        RefactoringConflictsUtil.getInstance().analyzeModuleConflicts(project, scopes, usages, vFile, conflicts);
    }

    public static void analyzeModuleConflicts(Project project, final Collection<? extends GroovyPsiElement> scopes, UsageInfo[] usages, VirtualFile vFile, final MultiMap<PsiElement, String> conflicts) {
        if (scopes == null) {
            return;
        }
        for (PsiElement psiElement : scopes) {
            if (!(psiElement instanceof PsiPackage)) continue;
            return;
        }
        final Module targetModule = ModuleUtilCore.findModuleForFile((VirtualFile)vFile, (Project)project);
        if (targetModule == null) {
            return;
        }
        final GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)targetModule);
        final HashSet reported = new HashSet();
        for (GroovyPsiElement groovyPsiElement : scopes) {
            groovyPsiElement.accept(new GroovyRecursiveElementVisitor(){

                @Override
                public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement refElement) {
                    if (refElement == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitCodeReferenceElement(refElement);
                    this.visit(refElement);
                }

                @Override
                public void visitReferenceExpression(@NotNull GrReferenceExpression reference) {
                    if (reference == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    super.visitReferenceExpression(reference);
                    this.visit(reference);
                }

                private void visit(GrReferenceElement<? extends GroovyPsiElement> reference) {
                    PsiElement resolved = reference.resolve();
                    if (!(resolved == null || reported.contains(resolved) || CommonRefactoringUtil.isAncestor((PsiElement)resolved, (Collection)scopes) || PsiSearchScopeUtil.isInScope((GlobalSearchScope)globalSearchScope, (PsiElement)resolved) || resolved instanceof LightElement)) {
                        String scopeDescription = RefactoringUIUtil.getDescription((PsiElement)ConflictsUtil.getContainer(reference), (boolean)true);
                        String message = RefactoringBundle.message((String)"0.referenced.in.1.will.not.be.accessible.in.module.2", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)resolved, (boolean)true), scopeDescription, CommonRefactoringUtil.htmlEmphasize((String)targetModule.getName())});
                        conflicts.putValue((Object)resolved, (Object)StringUtil.capitalize((String)message));
                        reported.add(resolved);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "refElement";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "reference";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/GrRefactoringConflictsUtil$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitCodeReferenceElement";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitReferenceExpression";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        boolean isInTestSources = ModuleRootManager.getInstance((Module)targetModule).getFileIndex().isInTestSourceContent(vFile);
        block2: for (UsageInfo usage : usages) {
            Module module;
            PsiElement element = usage.getElement();
            if (element == null || PsiTreeUtil.getParentOfType((PsiElement)element, GrImportStatement.class, (boolean)false) != null) continue;
            for (PsiElement psiElement : scopes) {
                if (!PsiTreeUtil.isAncestor((PsiElement)psiElement, (PsiElement)element, (boolean)false)) continue;
                continue block2;
            }
            GlobalSearchScope resolveScope1 = element.getResolveScope();
            if (resolveScope1.isSearchInModuleContent(targetModule, isInTestSources)) continue;
            PsiFile psiFile = element.getContainingFile();
            Object container = psiFile instanceof PsiJavaFile ? ConflictsUtil.getContainer((PsiElement)element) : psiFile;
            String scopeDescription = RefactoringUIUtil.getDescription((PsiElement)container, (boolean)true);
            VirtualFile usageVFile = psiFile.getVirtualFile();
            if (usageVFile == null || (module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(usageVFile)) == null) continue;
            PsiElement referencedElement = usage instanceof MoveRenameUsageInfo ? ((MoveRenameUsageInfo)usage).getReferencedElement() : usage.getElement();
            assert (referencedElement != null) : usage;
            String message = module == targetModule && isInTestSources ? RefactoringBundle.message((String)"0.referenced.in.1.will.not.be.accessible.from.production.of.module.2", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)referencedElement, (boolean)true), scopeDescription, CommonRefactoringUtil.htmlEmphasize((String)module.getName())}) : RefactoringBundle.message((String)"0.referenced.in.1.will.not.be.accessible.from.module.2", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)referencedElement, (boolean)true), scopeDescription, CommonRefactoringUtil.htmlEmphasize((String)module.getName())});
            conflicts.putValue((Object)referencedElement, (Object)StringUtil.capitalize((String)message));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "membersToMove";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/GrRefactoringConflictsUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "analyzeAccessibilityConflicts";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkUsedElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

