/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.html.links;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.parser.LinkMap;
import org.intellij.plugins.markdown.ui.preview.html.links.InlineLinkGeneratingProvider;
import org.intellij.plugins.markdown.ui.preview.html.links.LinkGeneratingProvider;
import org.intellij.plugins.markdown.ui.preview.html.links.ReferenceLinksGeneratingProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0014J,\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u00060\u0017R\u00020\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/html/links/IntelliJImageGeneratingProvider;", "Lorg/intellij/plugins/markdown/ui/preview/html/links/LinkGeneratingProvider;", "linkMap", "Lorg/intellij/markdown/parser/LinkMap;", "baseURI", "Ljava/net/URI;", "(Lorg/intellij/markdown/parser/LinkMap;Ljava/net/URI;)V", "inlineLinkProvider", "Lorg/intellij/plugins/markdown/ui/preview/html/links/InlineLinkGeneratingProvider;", "referenceLinkProvider", "Lorg/intellij/plugins/markdown/ui/preview/html/links/ReferenceLinksGeneratingProvider;", "getRenderInfo", "Lorg/intellij/plugins/markdown/ui/preview/html/links/LinkGeneratingProvider$RenderInfo;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "makeAbsoluteUrl", "", "destination", "renderLink", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "info", "Companion", "intellij.markdown.core"})
public final class IntelliJImageGeneratingProvider
extends LinkGeneratingProvider {
    private final ReferenceLinksGeneratingProvider referenceLinkProvider;
    private final InlineLinkGeneratingProvider inlineLinkProvider;
    private static final Regex REGEX;
    @NotNull
    private static final String generatedAttributeName;
    @NotNull
    private static final String ignorePathProcessingAttributeName;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    protected CharSequence makeAbsoluteUrl(@NotNull CharSequence destination) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        String string = SystemInfo.isWindows ? StringUtil.replace((String)((Object)destination).toString(), (String)"%5C", (String)"/") : ((Object)destination).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (SystemInfo.isWindows\u2026se destination.toString()");
        String destinationEx = string;
        if (StringsKt.startsWith$default((CharSequence)destinationEx, (char)'#', (boolean)false, (int)2, null)) {
            return destinationEx;
        }
        return super.makeAbsoluteUrl(destinationEx);
    }

    @Override
    @Nullable
    public LinkGeneratingProvider.RenderInfo getRenderInfo(@NotNull String text, @NotNull ASTNode node) {
        LinkGeneratingProvider.RenderInfo renderInfo;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        ASTNode aSTNode = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)MarkdownElementTypes.INLINE_LINK);
        if (aSTNode != null) {
            ASTNode aSTNode2;
            ASTNode it = aSTNode2 = aSTNode;
            boolean bl = false;
            return this.inlineLinkProvider.getRenderInfo(text, it);
        }
        ASTNode aSTNode3 = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)MarkdownElementTypes.FULL_REFERENCE_LINK);
        if (aSTNode3 == null) {
            aSTNode3 = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)MarkdownElementTypes.SHORT_REFERENCE_LINK);
        }
        if (aSTNode3 != null) {
            ASTNode aSTNode4;
            ASTNode it = aSTNode4 = aSTNode3;
            boolean bl = false;
            renderInfo = this.referenceLinkProvider.getRenderInfo(text, it);
        } else {
            renderInfo = null;
        }
        return renderInfo;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void renderLink(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node, @NotNull LinkGeneratingProvider.RenderInfo info) {
        String string;
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        CharSequence url = this.makeAbsoluteUrl(info.getDestination());
        HtmlGenerator.HtmlGeneratingVisitor htmlGeneratingVisitor = visitor;
        ASTNode aSTNode = node;
        CharSequence charSequence = "img";
        CharSequence[] charSequenceArray = new CharSequence[4];
        charSequenceArray[0] = "src=\"" + url + "\"";
        charSequenceArray[1] = "alt=\"" + IntelliJImageGeneratingProvider.Companion.getPlainTextFrom(info.getLabel(), text) + "\"";
        CharSequence[] charSequenceArray2 = charSequenceArray;
        CharSequence[] charSequenceArray3 = charSequenceArray;
        int n = 2;
        CharSequence charSequence2 = info.getTitle();
        if (charSequence2 != null) {
            void it;
            CharSequence charSequence3;
            CharSequence charSequence4 = charSequence3 = charSequence2;
            int n2 = n;
            CharSequence[] charSequenceArray4 = charSequenceArray2;
            CharSequence[] charSequenceArray5 = charSequenceArray3;
            CharSequence charSequence5 = charSequence;
            ASTNode aSTNode2 = aSTNode;
            HtmlGenerator.HtmlGeneratingVisitor htmlGeneratingVisitor2 = htmlGeneratingVisitor;
            boolean bl = false;
            String string2 = "title=\"" + (CharSequence)it + "\"";
            htmlGeneratingVisitor = htmlGeneratingVisitor2;
            aSTNode = aSTNode2;
            charSequence = charSequence5;
            charSequenceArray3 = charSequenceArray5;
            charSequenceArray2 = charSequenceArray4;
            n = n2;
            string = string2;
        } else {
            string = null;
        }
        charSequenceArray2[n] = string;
        charSequenceArray3[3] = generatedAttributeName + "=\"true\"";
        htmlGeneratingVisitor.consumeTagOpen(aSTNode, charSequence, charSequenceArray3, true);
    }

    public IntelliJImageGeneratingProvider(@NotNull LinkMap linkMap, @Nullable URI baseURI) {
        Intrinsics.checkNotNullParameter((Object)linkMap, (String)"linkMap");
        super(baseURI);
        this.referenceLinkProvider = new ReferenceLinksGeneratingProvider(linkMap, baseURI);
        this.inlineLinkProvider = new InlineLinkGeneratingProvider(baseURI);
    }

    static {
        Companion = new Companion(null);
        REGEX = new Regex("[^a-zA-Z0-9 ]");
        generatedAttributeName = "__idea-generated";
        ignorePathProcessingAttributeName = "md-do-not-process-path";
    }

    @NotNull
    public static final String getGeneratedAttributeName() {
        Companion companion = Companion;
        return generatedAttributeName;
    }

    @NotNull
    public static final String getIgnorePathProcessingAttributeName() {
        Companion companion = Companion;
        return ignorePathProcessingAttributeName;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u00020\u00068\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u00020\u00068\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/html/links/IntelliJImageGeneratingProvider$Companion;", "", "()V", "REGEX", "Lkotlin/text/Regex;", "generatedAttributeName", "", "getGeneratedAttributeName$annotations", "getGeneratedAttributeName", "()Ljava/lang/String;", "ignorePathProcessingAttributeName", "getIgnorePathProcessingAttributeName$annotations", "getIgnorePathProcessingAttributeName", "getPlainTextFrom", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "text", "intellij.markdown.core"})
    public static final class Companion {
        private final CharSequence getPlainTextFrom(ASTNode node, String text) {
            return REGEX.replace(ASTUtilKt.getTextInNode((ASTNode)node, (CharSequence)text), "");
        }

        @JvmStatic
        public static /* synthetic */ void getGeneratedAttributeName$annotations() {
        }

        @NotNull
        public final String getGeneratedAttributeName() {
            return generatedAttributeName;
        }

        @JvmStatic
        public static /* synthetic */ void getIgnorePathProcessingAttributeName$annotations() {
        }

        @NotNull
        public final String getIgnorePathProcessingAttributeName() {
            return ignorePathProcessingAttributeName;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

