/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.engine.support.hierarchical;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.locks.Lock;
import org.gradle.internal.impldep.org.junit.platform.engine.support.hierarchical.ResourceLock;

class CompositeLock
implements ResourceLock {
    private final List<Lock> locks;

    CompositeLock(List<Lock> locks) {
        this.locks = locks;
    }

    List<Lock> getLocks() {
        return this.locks;
    }

    @Override
    public ResourceLock acquire() throws InterruptedException {
        ForkJoinPool.managedBlock(new CompositeLockManagedBlocker());
        return this;
    }

    private void acquireAllLocks() throws InterruptedException {
        ArrayList<Lock> acquiredLocks = new ArrayList<Lock>(this.locks.size());
        try {
            for (Lock lock : this.locks) {
                lock.lockInterruptibly();
                acquiredLocks.add(lock);
            }
        }
        catch (InterruptedException e) {
            this.release(acquiredLocks);
            throw e;
        }
    }

    @Override
    public void release() {
        this.release(this.locks);
    }

    private void release(List<Lock> acquiredLocks) {
        for (int i = acquiredLocks.size() - 1; i >= 0; --i) {
            acquiredLocks.get(i).unlock();
        }
    }

    private class CompositeLockManagedBlocker
    implements ForkJoinPool.ManagedBlocker {
        private boolean acquired;

        private CompositeLockManagedBlocker() {
        }

        @Override
        public boolean block() throws InterruptedException {
            CompositeLock.this.acquireAllLocks();
            this.acquired = true;
            return true;
        }

        @Override
        public boolean isReleasable() {
            return this.acquired;
        }
    }
}

