/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution;

import com.intellij.execution.Location;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.GradleTaskLocation;
import org.jetbrains.plugins.gradle.service.resolve.GradleResolverUtil;
import org.jetbrains.plugins.gradle.settings.GradleExtensionsSettings;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public final class GradleGroovyRunnerUtil {
    @NotNull
    public static List<String> getTasksTarget(@NotNull PsiElement element, @Nullable Module module) {
        GrMethodCallExpression methodCallExpression;
        if (element == null) {
            GradleGroovyRunnerUtil.$$$reportNull$$$0(0);
        }
        PsiElement parent = element;
        while (parent.getParent() != null && !(parent.getParent() instanceof PsiFile)) {
            parent = parent.getParent();
        }
        if (GradleGroovyRunnerUtil.isCreateTaskMethod(parent)) {
            GrExpression[] arguments = ((GrMethodCallExpression)parent).getExpressionArguments();
            if (arguments.length > 0 && arguments[0] instanceof GrLiteral && ((GrLiteral)arguments[0]).getValue() instanceof String) {
                List<String> list = Collections.singletonList((String)((GrLiteral)arguments[0]).getValue());
                if (list == null) {
                    GradleGroovyRunnerUtil.$$$reportNull$$$0(1);
                }
                return list;
            }
        } else if (parent instanceof GrApplicationStatement) {
            PsiElement shiftExpression = parent.getChildren()[1].getChildren()[0];
            if (GradleResolverUtil.isLShiftElement(shiftExpression)) {
                PsiElement shiftiesChild = shiftExpression.getChildren()[0];
                if (shiftiesChild instanceof GrReferenceExpression) {
                    List<String> list = Collections.singletonList(shiftiesChild.getText());
                    if (list == null) {
                        GradleGroovyRunnerUtil.$$$reportNull$$$0(2);
                    }
                    return list;
                }
                if (shiftiesChild instanceof GrMethodCallExpression) {
                    List<String> list = Collections.singletonList(shiftiesChild.getChildren()[0].getText());
                    if (list == null) {
                        GradleGroovyRunnerUtil.$$$reportNull$$$0(3);
                    }
                    return list;
                }
            } else if (shiftExpression instanceof GrMethodCallExpression) {
                List<String> list = Collections.singletonList(shiftExpression.getChildren()[0].getText());
                if (list == null) {
                    GradleGroovyRunnerUtil.$$$reportNull$$$0(4);
                }
                return list;
            }
        }
        if ((methodCallExpression = (GrMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, GrMethodCallExpression.class)) != null) {
            GradleExtensionsSettings.GradleTask gradleTask;
            GradleExtensionsSettings.GradleExtensionsData extensionsData;
            String taskNameCandidate = methodCallExpression.getChildren()[0].getText();
            Project project = element.getProject();
            if (module == null) {
                module = GradleGroovyRunnerUtil.getModule(element, project);
            }
            if ((extensionsData = GradleExtensionsSettings.getInstance((Project)project).getExtensionsFor(module)) != null && (gradleTask = (GradleExtensionsSettings.GradleTask)extensionsData.tasksMap.get(taskNameCandidate)) != null) {
                List<String> list = Collections.singletonList(taskNameCandidate);
                if (list == null) {
                    GradleGroovyRunnerUtil.$$$reportNull$$$0(5);
                }
                return list;
            }
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            GradleGroovyRunnerUtil.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    private static Module getModule(@NotNull PsiElement element, @NotNull Project project) {
        VirtualFile virtualFile;
        PsiFile containingFile;
        if (element == null) {
            GradleGroovyRunnerUtil.$$$reportNull$$$0(7);
        }
        if (project == null) {
            GradleGroovyRunnerUtil.$$$reportNull$$$0(8);
        }
        if ((containingFile = element.getContainingFile()) != null && (virtualFile = containingFile.getVirtualFile()) != null) {
            return ProjectFileIndex.getInstance((Project)project).getModuleForFile(virtualFile);
        }
        return null;
    }

    private static boolean isCreateTaskMethod(PsiElement parent) {
        return parent instanceof GrMethodCallExpression && PsiUtil.isMethodCall((GrMethodCall)((GrMethodCallExpression)parent), (String)"createTask");
    }

    @NotNull
    public static List<String> getTasksTarget(@Nullable Location location) {
        if (location == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                GradleGroovyRunnerUtil.$$$reportNull$$$0(9);
            }
            return list;
        }
        if (location instanceof GradleTaskLocation) {
            List list = ((GradleTaskLocation)location).getTasks();
            if (list == null) {
                GradleGroovyRunnerUtil.$$$reportNull$$$0(10);
            }
            return list;
        }
        Module module = location.getModule();
        return GradleGroovyRunnerUtil.getTasksTarget(location.getPsiElement(), module);
    }

    @NotNull
    public static List<String> getTasksTarget(@NotNull PsiElement element) {
        if (element == null) {
            GradleGroovyRunnerUtil.$$$reportNull$$$0(11);
        }
        return GradleGroovyRunnerUtil.getTasksTarget(element, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/execution/GradleGroovyRunnerUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/execution/GradleGroovyRunnerUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasksTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTasksTarget";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

