/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.debugger;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.remote.RemoteConfiguration;
import com.intellij.execution.remote.RemoteConfigurationType;
import com.intellij.openapi.externalSystem.debugger.DebuggerBackendExtension;
import com.intellij.openapi.project.Project;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\bH\u0016J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/gradle/service/debugger/GradleJvmDebuggerBackend;", "Lcom/intellij/openapi/externalSystem/debugger/DebuggerBackendExtension;", "()V", "debugConfigurationSettings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "project", "Lcom/intellij/openapi/project/Project;", "processName", "", "processParameters", "id", "initializationCode", "", "dispatchPort", "parameters", "intellij.gradle.java"})
public final class GradleJvmDebuggerBackend
implements DebuggerBackendExtension {
    @NotNull
    public String id() {
        return "Gradle JVM";
    }

    @NotNull
    public RunnerAndConfigurationSettings debugConfigurationSettings(@NotNull Project project, @NotNull String processName, @NotNull String processParameters) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        Intrinsics.checkNotNullParameter((Object)processParameters, (String)"processParameters");
        RunnerAndConfigurationSettings runSettings = RunManager.Companion.getInstance(project).createConfiguration(processName, RemoteConfigurationType.class);
        HashMap description = this.splitParameters(processParameters);
        RunConfiguration runConfiguration = runSettings.getConfiguration();
        if (runConfiguration == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.execution.remote.RemoteConfiguration");
        }
        RemoteConfiguration configuration = (RemoteConfiguration)runConfiguration;
        configuration.HOST = "localhost";
        configuration.PORT = (String)description.get("DEBUG_SERVER_PORT");
        configuration.USE_SOCKET_TRANSPORT = true;
        configuration.SERVER_MODE = true;
        configuration.putUserData(DebuggerBackendExtension.RUNTIME_MODULE_DIR_KEY, description.get("MODULE_DIR"));
        return runSettings;
    }

    @NotNull
    public List<String> initializationCode(@NotNull String dispatchPort, @NotNull String parameters) {
        Intrinsics.checkNotNullParameter((Object)dispatchPort, (String)"dispatchPort");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        return StringsKt.split$default((CharSequence)StringsKt.trimIndent((String)("\n    import org.gradle.api.tasks.testing.Test\n    import com.intellij.openapi.externalSystem.rt.execution.ForkedDebuggerHelper\n    \n    def getCurrentProject() {\n        def currentPath = gradle.startParameter.currentDir.path\n        return rootProject.allprojects.find { it.projectDir.path == currentPath }\n    }\n    \n    static def removePrefix(def string, def prefix) {\n        if (string.startsWith(prefix)) {\n            return string.minus(prefix)\n        }\n        return null\n    }\n    \n    static def getRelativeTaskPath(def project, def task) {\n        def taskPath = task.path\n        def projectPath = project?.path\n        if (projectPath == null) return null\n        def path = removePrefix(taskPath, projectPath)\n        if (path == null) return null\n        return removePrefix(path, \":\") ?: path\n    }\n    \n    static def getPossibleTaskNames(def project, def task) {\n        def relativeTaskPath = getRelativeTaskPath(project, task)\n        if (relativeTaskPath == null) {\n            [task.path]\n        } else {\n            [task.name, task.path, relativeTaskPath]\n        }\n    }\n    \n    static def isMatchedTask(def project, def task, def matchers) {\n        def possibleNames = getPossibleTaskNames(project, task)\n        if (matchers.any { it in possibleNames }) {\n            return \"MATCHED\"\n        }\n        if (possibleNames.any { matchers.any { matcher -> it.startsWith(matcher) } }) {\n            return \"PARTIALLY MATCHED\"\n        }\n        return \"NOT MATCHED\"\n    }\n    \n    def filterStartTasks(def tasks) {\n        def currentProject = getCurrentProject()\n        logger.debug(\"Current Project: ${currentProject}\")\n        \n        def rootGradle = gradle\n        def compositePathPrefix = []\n        \n        while (rootGradle.getParent() != null) {\n          compositePathPrefix.add(0, gradle.rootProject.name)\n          rootGradle = rootGradle.getParent()\n        }\n        \n        def startTaskNames = rootGradle.startParameter.taskNames\n        logger.debug(\"Start Tasks Names: ${startTaskNames}\")\n        \n        if (!compositePathPrefix.isEmpty()) {\n           def compositePathPrefixString = \":\" + compositePathPrefix.join(\":\")\n           logger.debug(\"composite path prefix string: ${compositePathPrefixString}\")\n           startTaskNames = startTaskNames.collect {\n              if (it.startsWith(compositePathPrefixString)) {\n                 return it.substring(compositePathPrefixString.length())\n              } else {\n                 return it\n              }\n           }\n        }\n        \n        logger.debug(\"Start startTaskNames after cleanup: ${startTaskNames}\")\n        if (startTaskNames.isEmpty()) {\n            startTaskNames = (currentProject ?: project).defaultTasks\n        }        \n        \n        def tasksMatchStatus = tasks.collect { [it, isMatchedTask(currentProject, it, startTaskNames)] }\n        def matchedTasks = tasksMatchStatus.findAll { it[1] == \"MATCHED\" }.collect { it[0] }\n        if (matchedTasks.isEmpty()) {\n            matchedTasks = tasksMatchStatus.findAll { it[1] == \"PARTIALLY MATCHED\" }.collect { it[0] }\n        }\n        logger.debug(\"Matched tasks: ${matchedTasks}\")\n        return matchedTasks\n    }\n    \n    gradle.taskGraph.whenReady { taskGraph ->\n        //noinspection GroovyAssignabilityCheck\n        def debugAllIsEnabled = Boolean.valueOf(System.properties[\"idea.gradle.debug.all\"])\n        logger.debug(\"idea.gradle.debug.all is ${debugAllIsEnabled}\")\n\n        taskGraph.allTasks.each { Task task ->\n            if (task instanceof Test) {\n                task.maxParallelForks = 1\n                task.forkEvery = 0\n            }\n        }\n        def jvmTasks = taskGraph.allTasks.findAll { task -> task instanceof JavaForkOptions }\n        def matchedTasks = debugAllIsEnabled ? jvmTasks : filterStartTasks(jvmTasks)\n        matchedTasks.each { task ->\n            def moduleDir = task.project.projectDir.path\n            task.doFirst {\n                def debugPort = ForkedDebuggerHelper.setupDebugger('" + this.id() + "', task.path, '" + parameters + "', moduleDir)\n                def jvmArgs = task.jvmArgs.findAll { !it?.startsWith('-agentlib:jdwp') && !it?.startsWith('-Xrunjdwp') }\n                jvmArgs << ForkedDebuggerHelper.JVM_DEBUG_SETUP_PREFIX + ForkedDebuggerHelper.addrFromProperty + ':' + debugPort\n                task.jvmArgs = jvmArgs\n            }\n            task.doLast {\n                ForkedDebuggerHelper.signalizeFinish('" + this.id() + "', task.path)\n            }\n        }\n    }\n    ")), (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
    }
}

