/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.qodana.sarif;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jetbrains.qodana.sarif.model.PropertyBag;
import com.jetbrains.qodana.sarif.model.Result;
import com.jetbrains.qodana.sarif.model.Run;
import com.jetbrains.qodana.sarif.model.SarifReport;
import com.jetbrains.qodana.sarif.model.Tool;
import com.jetbrains.qodana.sarif.model.ToolComponent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class SarifUtil {
    private SarifUtil() {
    }

    public static SarifReport readReport(Reader reader) {
        Gson gson = SarifUtil.createGson();
        return (SarifReport)gson.fromJson(reader, SarifReport.class);
    }

    public static SarifReport readReport(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            SarifReport sarifReport = SarifUtil.readReport(reader);
            return sarifReport;
        }
    }

    public static SarifReport emptyReport(String toolName) {
        Run run = new Run(new Tool(new ToolComponent(toolName))).withResults(new ArrayList<Result>());
        return new SarifReport().withRuns(List.of(run));
    }

    public static void writeReport(Writer writer, SarifReport report) {
        Gson gson = SarifUtil.createGson();
        gson.toJson((Object)report, (Appendable)writer);
    }

    public static void writeReport(Path path, SarifReport report) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            SarifUtil.writeReport(writer, report);
        }
    }

    public static Gson createGson() {
        return new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(PropertyBag.class, (Object)new PropertyBag.PropertyBagTypeAdapter().nullSafe()).create();
    }
}

