/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.protocol;

import com.intellij.ide.IdeBundle;
import com.intellij.navigation.LocationInFile;
import com.intellij.navigation.NavigatorWithinProject;
import com.intellij.navigation.NavigatorWithinProjectKt;
import com.intellij.openapi.application.JBProtocolCommand;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ComparatorUtil;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.protocol.DownloadedReportDescriptorBuilder;
import org.jetbrains.qodana.protocol.SingleMarkerReportDescriptorBuilder;
import org.jetbrains.qodana.report.QodanaReportsService;
import org.jetbrains.qodana.report.ReportDescriptor;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bH\u0002J$\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J$\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00122\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bH\u0002J$\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00122\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bH\u0002J8\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/qodana/protocol/JBProtocolShowQodanaReportCommand;", "Lcom/intellij/openapi/application/JBProtocolCommand;", "()V", "findAndNavigate", "", "project", "Lcom/intellij/openapi/project/Project;", "parameters", "", "", "highlightSingleMarkerReport", "locationToOffset", "", "locationInFile", "Lcom/intellij/navigation/LocationInFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "navigateAndOpenReport", "Ljava/util/concurrent/Future;", "navigateAndShowMarker", "perform", "target", "", "fragment", "OpenReportTask", "intellij.qodana"})
public final class JBProtocolShowQodanaReportCommand
extends JBProtocolCommand {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Future<String> perform(@Nullable String target, @NotNull Map<String, String> parameters, @Nullable String fragment) {
        Future future;
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        String string = target;
        if (string != null) {
            switch (string) {
                case "openReport": {
                    future = this.navigateAndOpenReport(parameters);
                    return future;
                }
                case "showMarker": {
                    future = this.navigateAndShowMarker(parameters);
                    return future;
                }
            }
        }
        CompletableFuture<String> completableFuture = CompletableFuture.completedFuture(IdeBundle.message((String)"jb.protocol.unknown.target", (Object[])new Object[]{target}));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.comple\u2026unknown.target\", target))");
        future = completableFuture;
        return future;
    }

    private final Future<String> navigateAndOpenReport(Map<String, String> parameters) {
        CompletionStage completionStage = NavigatorWithinProjectKt.openProject(parameters).handle(new BiFunction(this, parameters){
            final /* synthetic */ JBProtocolShowQodanaReportCommand this$0;
            final /* synthetic */ Map $parameters;

            @Nullable
            public final String apply(@Nullable Project project, Throwable t) {
                Object object;
                if (t != null) {
                    object = t.getClass().getName() + ": " + t.getMessage();
                } else if (project == null) {
                    object = IdeBundle.message((String)"jb.protocol.navigate.no.project", (Object[])new Object[0]);
                } else {
                    JBProtocolShowQodanaReportCommand.access$findAndNavigate(this.this$0, project, this.$parameters);
                    String string = JBProtocolShowQodanaReportCommand.access$parameter(this.this$0, this.$parameters, "report");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parameter(parameters, \"report\")");
                    new OpenReportTask(project, string).queue();
                    object = null;
                }
                return object;
            }
            {
                this.this$0 = jBProtocolShowQodanaReportCommand;
                this.$parameters = map;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"openProject(parameters).\u2026l\n        }\n      }\n    }");
        return (Future)((Object)completionStage);
    }

    private final Future<String> navigateAndShowMarker(Map<String, String> parameters) {
        CompletionStage completionStage = NavigatorWithinProjectKt.openProject(parameters).handle(new BiFunction(this, parameters){
            final /* synthetic */ JBProtocolShowQodanaReportCommand this$0;
            final /* synthetic */ Map $parameters;

            @Nullable
            public final String apply(@Nullable Project project, Throwable t) {
                Object object;
                if (t != null) {
                    object = t.getClass().getName() + ": " + t.getMessage();
                } else if (project == null) {
                    object = IdeBundle.message((String)"jb.protocol.navigate.no.project", (Object[])new Object[0]);
                } else {
                    JBProtocolShowQodanaReportCommand.access$findAndNavigate(this.this$0, project, this.$parameters);
                    JBProtocolShowQodanaReportCommand.access$highlightSingleMarkerReport(this.this$0, project, this.$parameters);
                    object = null;
                }
                return object;
            }
            {
                this.this$0 = jBProtocolShowQodanaReportCommand;
                this.$parameters = map;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"openProject(parameters).\u2026l\n        }\n      }\n    }");
        return (Future)((Object)completionStage);
    }

    private final void findAndNavigate(Project project, Map<String, String> parameters) {
        new NavigatorWithinProject(project, parameters, (Function2)new Function2<LocationInFile, Editor, Integer>(this){

            public final int invoke(@NotNull LocationInFile p1, @NotNull Editor p2) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                return JBProtocolShowQodanaReportCommand.access$locationToOffset((JBProtocolShowQodanaReportCommand)((Object)this.receiver), p1, p2);
            }
        }).navigate(CollectionsKt.listOf((Object)NavigatorWithinProject.NavigationKeyPrefix.PATH));
    }

    private final void highlightSingleMarkerReport(Project project, Map<String, String> parameters) {
        String string = this.parameter(parameters, "message");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parameter(parameters, \"message\")");
        String message = string;
        String string2 = this.parameter(parameters, "path");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parameter(parameters, \"path\")");
        String pathText = string2;
        String string3 = this.parameter(parameters, "length");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"parameter(parameters, \"length\")");
        String markerLength = string3;
        String string4 = parameters.get("origin");
        if (string4 == null) {
            string4 = "Unknown";
        }
        String origin = string4;
        String revisionId = parameters.get("marker_revision");
        ReportDescriptor reportDescriptor = new SingleMarkerReportDescriptorBuilder(message, pathText, markerLength, origin, revisionId, project).createReportDescriptor();
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(QodanaReportsService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        ((QodanaReportsService)object).addReportAndHighlight(reportDescriptor);
    }

    private final int locationToOffset(LocationInFile locationInFile, Editor editor) {
        Comparable comparable = ComparatorUtil.max((Comparable)Integer.valueOf(locationInFile.getLine() - 1), (Comparable)Integer.valueOf(0));
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"max(locationInFile.line - 1, 0)");
        int offsetOfLine = editor.logicalPositionToOffset(new LogicalPosition(((Number)((Object)comparable)).intValue(), 0));
        Comparable comparable2 = ComparatorUtil.max((Comparable)Integer.valueOf(locationInFile.getColumn() - 1), (Comparable)Integer.valueOf(0));
        Intrinsics.checkNotNullExpressionValue((Object)comparable2, (String)"max(locationInFile.column - 1, 0)");
        int offsetInLine = ((Number)((Object)comparable2)).intValue();
        return offsetOfLine + offsetInLine;
    }

    public JBProtocolShowQodanaReportCommand() {
        super("qodana");
    }

    public static final /* synthetic */ void access$findAndNavigate(JBProtocolShowQodanaReportCommand $this, Project project, Map parameters) {
        $this.findAndNavigate(project, parameters);
    }

    public static final /* synthetic */ String access$parameter(JBProtocolShowQodanaReportCommand $this, Map p0, String p1) {
        return $this.parameter(p0, p1);
    }

    public static final /* synthetic */ void access$highlightSingleMarkerReport(JBProtocolShowQodanaReportCommand $this, Project project, Map parameters) {
        $this.highlightSingleMarkerReport(project, parameters);
    }

    public static final /* synthetic */ int access$locationToOffset(JBProtocolShowQodanaReportCommand $this, LocationInFile locationInFile, Editor editor) {
        return $this.locationToOffset(locationInFile, editor);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/qodana/protocol/JBProtocolShowQodanaReportCommand$OpenReportTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "project", "Lcom/intellij/openapi/project/Project;", "reportUrl", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.qodana"})
    public static final class OpenReportTask
    extends Task.Backgroundable {
        private final String reportUrl;

        public void run(@NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            ReportDescriptor reportDescriptor = new DownloadedReportDescriptorBuilder(this.reportUrl, this.getProject()).createReportDescriptor();
            if (reportDescriptor == null) {
                return;
            }
            ReportDescriptor reportDescriptor2 = reportDescriptor;
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(QodanaReportsService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            ((QodanaReportsService)object).addReportAndHighlight(reportDescriptor2);
        }

        public OpenReportTask(@NotNull Project project, @NotNull String reportUrl) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)reportUrl, (String)"reportUrl");
            super(project, QodanaBundle.message("progress.title.qodana.highlight", new Object[0]), true);
            this.reportUrl = reportUrl;
        }
    }
}

