/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.core.websocket;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.java_websocket.WebSocket;
import org.java_websocket.exceptions.WebsocketNotConnectedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.server.core.ClientSettings;
import org.jetbrains.projector.server.core.ClientWrapper;
import org.jetbrains.projector.server.core.ClosedClientSettings;
import org.jetbrains.projector.server.core.websocket.WsClientWrapper;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\fH\u0016J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/projector/server/core/websocket/WsClientWrapper;", "Lorg/jetbrains/projector/server/core/ClientWrapper;", "connection", "Lorg/java_websocket/WebSocket;", "initialSettings", "Lorg/jetbrains/projector/server/core/ClientSettings;", "(Lorg/java_websocket/WebSocket;Lorg/jetbrains/projector/server/core/ClientSettings;)V", "confirmationRemoteIp", "Ljava/net/InetAddress;", "getConfirmationRemoteIp", "()Ljava/net/InetAddress;", "confirmationRemoteName", "", "getConfirmationRemoteName", "()Ljava/lang/String;", "requiresConfirmation", "", "getRequiresConfirmation", "()Z", "settings", "getSettings", "()Lorg/jetbrains/projector/server/core/ClientSettings;", "setSettings", "(Lorg/jetbrains/projector/server/core/ClientSettings;)V", "disconnect", "", "reason", "send", "data", "", "Companion", "projector-server-core"})
public final class WsClientWrapper
implements ClientWrapper {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final WebSocket connection;
    @NotNull
    private ClientSettings settings;
    @Deprecated
    @NotNull
    private static final Logger logger;

    public WsClientWrapper(@NotNull WebSocket connection, @NotNull ClientSettings initialSettings) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)initialSettings, (String)"initialSettings");
        this.connection = connection;
        this.settings = initialSettings;
    }

    @Override
    @NotNull
    public ClientSettings getSettings() {
        return this.settings;
    }

    @Override
    public void setSettings(@NotNull ClientSettings clientSettings) {
        Intrinsics.checkNotNullParameter((Object)clientSettings, (String)"<set-?>");
        this.settings = clientSettings;
    }

    @Override
    public void disconnect(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        int normalClosureCode = 1000;
        WebSocket conn = this.connection;
        conn.close(normalClosureCode, reason);
        Object t = conn.getAttachment();
        Intrinsics.checkNotNull(t);
        ClientSettings clientSettings = (ClientSettings)t;
        Logger.DefaultImpls.info$default(logger, null, (Function0)new Function0<String>(clientSettings, reason){
            final /* synthetic */ ClientSettings $clientSettings;
            final /* synthetic */ String $reason;
            {
                this.$clientSettings = $clientSettings;
                this.$reason = $reason;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Disconnecting user " + this.$clientSettings.getAddress() + ". Reason: " + this.$reason;
            }
        }, 1, null);
        conn.setAttachment(new ClosedClientSettings(clientSettings.getConnectionMillis(), clientSettings.getAddress(), reason));
    }

    @Override
    public void send(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            this.connection.send(data);
        }
        catch (WebsocketNotConnectedException e) {
            logger.debug(e, (Function0<String>)((Function0)send.1.INSTANCE));
        }
    }

    @Override
    public boolean getRequiresConfirmation() {
        InetAddress remoteAddress;
        InetSocketAddress inetSocketAddress = this.connection.getRemoteSocketAddress();
        InetAddress inetAddress = remoteAddress = inetSocketAddress == null ? null : inetSocketAddress.getAddress();
        return !(inetAddress == null ? false : inetAddress.isLoopbackAddress());
    }

    @Override
    @Nullable
    public InetAddress getConfirmationRemoteIp() {
        InetSocketAddress inetSocketAddress = this.connection.getRemoteSocketAddress();
        return inetSocketAddress == null ? null : inetSocketAddress.getAddress();
    }

    @Override
    @NotNull
    public String getConfirmationRemoteName() {
        return "unknown host";
    }

    static {
        boolean $i$f$Logger = false;
        String string = Reflection.getOrCreateKotlinClass(WsClientWrapper.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        logger = LoggerKt.Logger(string);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/projector/server/core/websocket/WsClientWrapper$Companion;", "", "()V", "logger", "Lorg/jetbrains/projector/util/logging/Logger;", "projector-server-core"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

