/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.recursive.comparison.ComparisonDifference;
import org.assertj.core.api.recursive.comparison.RecursiveComparisonConfiguration;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.internal.DeepDifference;
import org.assertj.core.internal.UnambiguousRepresentation;
import org.assertj.core.presentation.Representation;
import org.assertj.core.util.Strings;

public class ShouldBeEqualByComparingFieldByFieldRecursively
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldBeEqualByComparingFieldByFieldRecursive(Object actual, Object other, List<DeepDifference.Difference> differences, Representation representation) {
        List descriptionOfDifferences = differences.stream().map(difference -> ShouldBeEqualByComparingFieldByFieldRecursively.describeDifference(difference, representation)).collect(Collectors.toList());
        return new ShouldBeEqualByComparingFieldByFieldRecursively("%nExpecting actual:%n  %s%nto be equal to:%n  %s%nwhen recursively comparing field by field, but found the following difference(s):%n" + Strings.join(descriptionOfDifferences).with(String.format("%n", new Object[0])), actual, other);
    }

    public static ErrorMessageFactory shouldBeEqualByComparingFieldByFieldRecursively(Object actual, Object other, List<ComparisonDifference> differences, RecursiveComparisonConfiguration recursiveComparisonConfiguration, Representation representation) {
        String differencesDescription = Strings.join(differences.stream().map(difference -> difference.multiLineDescription(representation)).collect(Collectors.toList())).with(String.format("%n%n", new Object[0]));
        String recursiveComparisonConfigurationDescription = recursiveComparisonConfiguration.multiLineDescription(representation);
        String differencesCount = differences.size() == 1 ? "difference:%n" : "%s differences:%n";
        return new ShouldBeEqualByComparingFieldByFieldRecursively("%nExpecting actual:%n  %s%nto be equal to:%n  %s%nwhen recursively comparing field by field, but found the following " + differencesCount + "%n" + Strings.escapePercent(differencesDescription) + "%n%nThe recursive comparison was performed with this configuration:%n" + recursiveComparisonConfigurationDescription, actual, other, differences.size());
    }

    private ShouldBeEqualByComparingFieldByFieldRecursively(String message2, Object ... arguments) {
        super(message2, arguments);
    }

    private static String describeDifference(DeepDifference.Difference difference, Representation representation) {
        UnambiguousRepresentation unambiguousRepresentation = new UnambiguousRepresentation(representation, difference.getActual(), difference.getOther());
        String additionalInfo = difference.getDescription().map(desc -> String.format("%n- reason  : %s", Strings.escapePercent(desc))).orElse("");
        return String.format("%nPath to difference: <%s>%n- actual  : %s%n- expected: %s" + additionalInfo, Strings.join(difference.getPath()).with("."), Strings.escapePercent(unambiguousRepresentation.getActual()), Strings.escapePercent(unambiguousRepresentation.getExpected()));
    }
}

