/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.keystroke;

import java.util.Locale;
import java.util.logging.Logger;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.keystroke.KeyStrokeMappingProvider;
import org.assertj.swing.keystroke.KeyStrokeMappingProviderFactory;
import org.assertj.swing.keystroke.KeyStrokeMappingProviderNames;
import org.assertj.swing.keystroke.KeyStrokeMappingProvider_en;
import org.assertj.swing.util.OSFamily;

class KeyStrokeMappingProviderPicker {
    private static Logger LOGGER = Logger.getLogger(KeyStrokeMappingProviderPicker.class.getName());
    private final KeyStrokeMappingProviderFactory factory;

    KeyStrokeMappingProviderPicker() {
        this(new KeyStrokeMappingProviderFactory());
    }

    @VisibleForTesting
    KeyStrokeMappingProviderPicker(@Nonnull KeyStrokeMappingProviderFactory factory) {
        this.factory = factory;
    }

    KeyStrokeMappingProvider providerFor(@Nonnull OSFamily osFamily, @Nonnull Locale locale) {
        LOGGER.finer("providing keystroke mappings for OS=" + (Object)((Object)osFamily) + ", locale=" + locale);
        for (String name : KeyStrokeMappingProviderNames.generateNamesFrom(osFamily, locale)) {
            LOGGER.finer("trying >" + name + "<");
            String typeName = Preconditions.checkNotNull(name);
            KeyStrokeMappingProvider provider = this.factory.createProvider(typeName);
            if (provider == null) continue;
            LOGGER.finer("created successfully.");
            return provider;
        }
        return new KeyStrokeMappingProvider_en();
    }
}

