/*
 * Decompiled with CFR 0.152.
 */
package training.featuresSuggester.suggesters;

import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.suggested.UtilsKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import training.featuresSuggester.FeatureSuggesterBundle;
import training.featuresSuggester.NoSuggestion;
import training.featuresSuggester.SuggesterSupport;
import training.featuresSuggester.Suggestion;
import training.featuresSuggester.TextFragment;
import training.featuresSuggester.actions.Action;
import training.featuresSuggester.actions.BeforeEditorTextRemovedAction;
import training.featuresSuggester.suggesters.AbstractFeatureSuggester;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 /2\u00020\u0001:\u0002/0B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0014\u0010!\u001a\u00020\"*\u00020#2\u0006\u0010\u001f\u001a\u00020$H\u0002J\u0014\u0010%\u001a\u00020\"*\u00020#2\u0006\u0010\u001f\u001a\u00020$H\u0002J\u0014\u0010&\u001a\u00020\u001e*\u00020'2\u0006\u0010\u001f\u001a\u00020$H\u0002J\u0014\u0010(\u001a\u00020)*\u00020'2\u0006\u0010\u001f\u001a\u00020$H\u0002J\u0014\u0010*\u001a\u00020\u001e*\u00020'2\u0006\u0010\u001f\u001a\u00020$H\u0002J\u0014\u0010+\u001a\u00020)*\u00020'2\u0006\u0010\u001f\u001a\u00020$H\u0002J\u0014\u0010,\u001a\u00020\"*\u00020'2\u0006\u0010-\u001a\u00020.H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u0004X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0014\u0010\u0015\u001a\u00020\u0004X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0019\u001a\u00020\u000e*\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00061"}, d2={"Ltraining/featuresSuggester/suggesters/UnwrapSuggester;", "Ltraining/featuresSuggester/suggesters/AbstractFeatureSuggester;", "()V", "id", "", "getId", "()Ljava/lang/String;", "languages", "", "getLanguages", "()Ljava/util/List;", "message", "getMessage", "minSuggestingIntervalDays", "", "getMinSuggestingIntervalDays", "()I", "suggestingActionDisplayName", "getSuggestingActionDisplayName", "suggestingActionId", "getSuggestingActionId", "suggestingDocUrl", "getSuggestingDocUrl", "surroundingStatementStartRegex", "Lkotlin/text/Regex;", "contentStartOffset", "Ltraining/featuresSuggester/TextFragment;", "getContentStartOffset", "(Ltraining/featuresSuggester/TextFragment;)I", "getSuggestion", "Ltraining/featuresSuggester/Suggestion;", "action", "Ltraining/featuresSuggester/actions/Action;", "checkCloseBraceDeleted", "", "Ltraining/featuresSuggester/suggesters/UnwrapSuggester$State;", "Ltraining/featuresSuggester/actions/BeforeEditorTextRemovedAction;", "checkStatementStartDeleted", "handleCloseBraceDeleted", "Ltraining/featuresSuggester/SuggesterSupport;", "handleCloseBraceDeletedFirst", "", "handleStatementStartDeleted", "handleStatementStartDeletedFirst", "isSurroundingStatement", "psiElement", "Lcom/intellij/psi/PsiElement;", "Companion", "State", "intellij.featuresTrainer"})
public final class UnwrapSuggester
extends AbstractFeatureSuggester {
    @NotNull
    private final String id;
    @NotNull
    private final String suggestingActionDisplayName = FeatureSuggesterBundle.INSTANCE.message("unwrap.name", new Object[0]);
    @NotNull
    private final String message = FeatureSuggesterBundle.INSTANCE.message("unwrap.message", new Object[0]);
    @NotNull
    private final String suggestingActionId;
    @NotNull
    private final String suggestingDocUrl;
    private final int minSuggestingIntervalDays;
    @NotNull
    private final List<String> languages = CollectionsKt.listOf((Object[])new String[]{"JAVA", "kotlin", "ECMAScript 6"});
    private final Regex surroundingStatementStartRegex = new Regex("[ \\n]*(if|for|while)[ \\n]*\\(.*\\)[ \\n]*\\{[ \\n]*");
    public static final long MAX_TIME_MILLIS_BETWEEN_ACTIONS = 7000L;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getSuggestingActionDisplayName() {
        return this.suggestingActionDisplayName;
    }

    @Override
    @NotNull
    protected String getMessage() {
        return this.message;
    }

    @Override
    @NotNull
    protected String getSuggestingActionId() {
        return this.suggestingActionId;
    }

    @Override
    @NotNull
    protected String getSuggestingDocUrl() {
        return this.suggestingDocUrl;
    }

    @Override
    public int getMinSuggestingIntervalDays() {
        return this.minSuggestingIntervalDays;
    }

    @Override
    @NotNull
    public List<String> getLanguages() {
        return this.languages;
    }

    @Override
    @NotNull
    public Suggestion getSuggestion(@NotNull Action action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Language language = action2.getLanguage();
        if (language == null) {
            return NoSuggestion.INSTANCE;
        }
        Language language2 = language;
        SuggesterSupport suggesterSupport = SuggesterSupport.Companion.getForLanguage(language2);
        if (suggesterSupport == null) {
            return NoSuggestion.INSTANCE;
        }
        SuggesterSupport langSupport2 = suggesterSupport;
        if (action2 instanceof BeforeEditorTextRemovedAction) {
            String text2 = ((BeforeEditorTextRemovedAction)action2).getTextFragment().getText();
            if (Intrinsics.areEqual((Object)text2, (Object)"}")) {
                return this.handleCloseBraceDeleted(langSupport2, (BeforeEditorTextRemovedAction)action2);
            }
            Regex regex = this.surroundingStatementStartRegex;
            CharSequence charSequence = text2;
            if (regex.matches(charSequence)) {
                return this.handleStatementStartDeleted(langSupport2, (BeforeEditorTextRemovedAction)action2);
            }
            State.INSTANCE.reset();
        }
        return NoSuggestion.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Suggestion handleCloseBraceDeleted(SuggesterSupport $this$handleCloseBraceDeleted, BeforeEditorTextRemovedAction action2) {
        block7: {
            if (State.INSTANCE.isInitial()) {
                this.handleCloseBraceDeletedFirst($this$handleCloseBraceDeleted, action2);
            } else {
                if (State.INSTANCE.getCloseBraceOffset() != -1) {
                    try {
                        if (this.checkCloseBraceDeleted(State.INSTANCE, action2)) {
                            Suggestion suggestion = this.createSuggestion();
                            return suggestion;
                        }
                        break block7;
                    }
                    finally {
                        State.INSTANCE.reset();
                    }
                }
                State.INSTANCE.reset();
            }
        }
        return NoSuggestion.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Suggestion handleStatementStartDeleted(SuggesterSupport $this$handleStatementStartDeleted, BeforeEditorTextRemovedAction action2) {
        block7: {
            if (State.INSTANCE.isInitial()) {
                this.handleStatementStartDeletedFirst($this$handleStatementStartDeleted, action2);
            } else {
                if (State.INSTANCE.getSurroundingStatementStartOffset() != -1) {
                    try {
                        if (this.checkStatementStartDeleted(State.INSTANCE, action2)) {
                            Suggestion suggestion = this.createSuggestion();
                            return suggestion;
                        }
                        break block7;
                    }
                    finally {
                        State.INSTANCE.reset();
                    }
                }
                State.INSTANCE.reset();
            }
        }
        return NoSuggestion.INSTANCE;
    }

    private final void handleCloseBraceDeletedFirst(SuggesterSupport $this$handleCloseBraceDeletedFirst, BeforeEditorTextRemovedAction action2) {
        PsiElement codeBlock;
        PsiFile psiFile2 = action2.getPsiFile();
        if (psiFile2 == null || (psiFile2 = psiFile2.findElementAt(action2.getCaretOffset())) == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"action.psiFile?.findElem\u2026on.caretOffset) ?: return");
        PsiFile curElement = psiFile2;
        PsiElement psiElement = codeBlock = curElement.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"codeBlock");
        if (!$this$handleCloseBraceDeletedFirst.isCodeBlock(psiElement)) {
            return;
        }
        List<PsiElement> statements = $this$handleCloseBraceDeletedFirst.getStatements(codeBlock);
        Collection collection = statements;
        if (!collection.isEmpty()) {
            PsiElement psiElement2 = $this$handleCloseBraceDeletedFirst.getParentStatementOfBlock(codeBlock);
            if (psiElement2 == null) {
                return;
            }
            PsiElement statement = psiElement2;
            if (this.isSurroundingStatement($this$handleCloseBraceDeletedFirst, statement)) {
                State.INSTANCE.setSurroundingStatementStartOffset(UtilsKt.getStartOffset((PsiElement)statement));
                State.INSTANCE.setLastChangeTimeMillis(action2.getTimeMillis());
            }
        }
    }

    private final boolean checkStatementStartDeleted(State $this$checkStatementStartDeleted, BeforeEditorTextRemovedAction action2) {
        return !$this$checkStatementStartDeleted.isOutOfDate(action2.getTimeMillis()) && $this$checkStatementStartDeleted.getSurroundingStatementStartOffset() == this.getContentStartOffset(action2.getTextFragment());
    }

    private final void handleStatementStartDeletedFirst(SuggesterSupport $this$handleStatementStartDeletedFirst, BeforeEditorTextRemovedAction action2) {
        PsiElement curStatement;
        TextFragment textFragment = action2.getTextFragment();
        PsiFile psiFile2 = action2.getPsiFile();
        if (psiFile2 == null || (psiFile2 = psiFile2.findElementAt(this.getContentStartOffset(textFragment))) == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"action.psiFile?.findElem\u2026entStartOffset) ?: return");
        PsiFile curElement = psiFile2;
        PsiElement psiElement = curStatement = curElement.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"curStatement");
        if (this.isSurroundingStatement($this$handleStatementStartDeletedFirst, psiElement)) {
            PsiElement psiElement2 = $this$handleStatementStartDeletedFirst.getCodeBlock(curStatement);
            if (psiElement2 == null) {
                return;
            }
            PsiElement codeBlock = psiElement2;
            List<PsiElement> statements = $this$handleStatementStartDeletedFirst.getStatements(codeBlock);
            Collection collection = statements;
            if (!collection.isEmpty()) {
                State.INSTANCE.setCloseBraceOffset(UtilsKt.getEndOffset((PsiElement)curStatement) - textFragment.getText().length() - 1);
                State.INSTANCE.setLastChangeTimeMillis(action2.getTimeMillis());
            }
        }
    }

    private final boolean checkCloseBraceDeleted(State $this$checkCloseBraceDeleted, BeforeEditorTextRemovedAction action2) {
        return !$this$checkCloseBraceDeleted.isOutOfDate(action2.getTimeMillis()) && action2.getCaretOffset() == $this$checkCloseBraceDeleted.getCloseBraceOffset();
    }

    private final int getContentStartOffset(TextFragment $this$contentStartOffset) {
        int n;
        block1: {
            CharSequence $this$indexOfFirst$iv = $this$contentStartOffset.getText();
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!(it != ' ' && it != '\n')) continue;
                n = index$iv;
                break block1;
            }
            n = -1;
        }
        int countOfStartDelimiters = n;
        return $this$contentStartOffset.getStartOffset() + countOfStartDelimiters;
    }

    private final boolean isSurroundingStatement(SuggesterSupport $this$isSurroundingStatement, PsiElement psiElement) {
        return $this$isSurroundingStatement.isIfStatement(psiElement) || $this$isSurroundingStatement.isForStatement(psiElement) || $this$isSurroundingStatement.isWhileStatement(psiElement);
    }

    public UnwrapSuggester() {
        this.id = "Unwrap";
        this.suggestingActionId = "Unwrap";
        this.suggestingDocUrl = "https://www.jetbrains.com/help/idea/working-with-source-code.html#unwrap_remove_statement";
        this.minSuggestingIntervalDays = 14;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\rJ\u0006\u0010\u0017\u001a\u00020\u0018R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\b\u00a8\u0006\u0019"}, d2={"Ltraining/featuresSuggester/suggesters/UnwrapSuggester$State;", "", "()V", "closeBraceOffset", "", "getCloseBraceOffset", "()I", "setCloseBraceOffset", "(I)V", "isInitial", "", "()Z", "lastChangeTimeMillis", "", "getLastChangeTimeMillis", "()J", "setLastChangeTimeMillis", "(J)V", "surroundingStatementStartOffset", "getSurroundingStatementStartOffset", "setSurroundingStatementStartOffset", "isOutOfDate", "newChangeTimeMillis", "reset", "", "intellij.featuresTrainer"})
    private static final class State {
        private static int surroundingStatementStartOffset;
        private static int closeBraceOffset;
        private static long lastChangeTimeMillis;
        @NotNull
        public static final State INSTANCE;

        public final int getSurroundingStatementStartOffset() {
            return surroundingStatementStartOffset;
        }

        public final void setSurroundingStatementStartOffset(int n) {
            surroundingStatementStartOffset = n;
        }

        public final int getCloseBraceOffset() {
            return closeBraceOffset;
        }

        public final void setCloseBraceOffset(int n) {
            closeBraceOffset = n;
        }

        public final long getLastChangeTimeMillis() {
            return lastChangeTimeMillis;
        }

        public final void setLastChangeTimeMillis(long l) {
            lastChangeTimeMillis = l;
        }

        public final boolean isInitial() {
            return surroundingStatementStartOffset == -1 && closeBraceOffset == -1;
        }

        public final boolean isOutOfDate(long newChangeTimeMillis) {
            return newChangeTimeMillis - lastChangeTimeMillis > 7000L;
        }

        public final void reset() {
            surroundingStatementStartOffset = -1;
            closeBraceOffset = -1;
            lastChangeTimeMillis = 0L;
        }

        private State() {
        }

        static {
            State state;
            INSTANCE = state = new State();
            surroundingStatementStartOffset = -1;
            closeBraceOffset = -1;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ltraining/featuresSuggester/suggesters/UnwrapSuggester$Companion;", "", "()V", "MAX_TIME_MILLIS_BETWEEN_ACTIONS", "", "intellij.featuresTrainer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

