/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.Accountable;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.ObjectArrayList;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectDeque;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.RamUsageEstimator;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ObjectArrayDeque<KType>
extends AbstractObjectCollection<KType>
implements ObjectDeque<KType>,
Preallocable,
Cloneable,
Accountable {
    public Object[] buffer = ObjectArrayList.EMPTY_ARRAY;
    public int head;
    public int tail;
    protected final ArraySizingStrategy resizer;

    public ObjectArrayDeque() {
        this(4);
    }

    public ObjectArrayDeque(int expectedElements) {
        this(expectedElements, new BoundedProportionalArraySizingStrategy());
    }

    public ObjectArrayDeque(int expectedElements, ArraySizingStrategy resizer) {
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureCapacity(expectedElements);
    }

    public ObjectArrayDeque(ObjectContainer<? extends KType> container) {
        this(container.size());
        this.addLast(container);
    }

    @Override
    public void addFirst(KType e1) {
        int h = ObjectArrayDeque.oneLeft(this.head, this.buffer.length);
        if (h == this.tail) {
            this.ensureBufferSpace(1);
            h = ObjectArrayDeque.oneLeft(this.head, this.buffer.length);
        }
        this.head = h;
        this.buffer[this.head] = e1;
    }

    @Override
    @SafeVarargs
    public final void addFirst(KType ... elements) {
        this.ensureBufferSpace(elements.length);
        for (KType k : elements) {
            this.addFirst(k);
        }
    }

    public int addFirst(ObjectContainer<? extends KType> container) {
        int size = container.size();
        this.ensureBufferSpace(size);
        for (ObjectCursor<KType> objectCursor : container) {
            this.addFirst((KType)objectCursor.value);
        }
        return size;
    }

    public int addFirst(Iterable<? extends ObjectCursor<? extends KType>> iterable) {
        int size = 0;
        for (ObjectCursor<KType> objectCursor : iterable) {
            this.addFirst((KType)objectCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public void addLast(KType e1) {
        int t = ObjectArrayDeque.oneRight(this.tail, this.buffer.length);
        if (this.head == t) {
            this.ensureBufferSpace(1);
            t = ObjectArrayDeque.oneRight(this.tail, this.buffer.length);
        }
        this.buffer[this.tail] = e1;
        this.tail = t;
    }

    @Override
    @SafeVarargs
    public final void addLast(KType ... elements) {
        this.ensureBufferSpace(1);
        for (KType k : elements) {
            this.addLast(k);
        }
    }

    public int addLast(ObjectContainer<? extends KType> container) {
        int size = container.size();
        this.ensureBufferSpace(size);
        for (ObjectCursor<KType> objectCursor : container) {
            this.addLast((KType)objectCursor.value);
        }
        return size;
    }

    public int addLast(Iterable<? extends ObjectCursor<? extends KType>> iterable) {
        int size = 0;
        for (ObjectCursor<KType> objectCursor : iterable) {
            this.addLast((KType)objectCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public KType removeFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        Object result = this.buffer[this.head];
        this.buffer[this.head] = null;
        this.head = ObjectArrayDeque.oneRight(this.head, this.buffer.length);
        return (KType)result;
    }

    @Override
    public KType removeLast() {
        assert (this.size() > 0) : "The deque is empty.";
        this.tail = ObjectArrayDeque.oneLeft(this.tail, this.buffer.length);
        Object result = this.buffer[this.tail];
        this.buffer[this.tail] = null;
        return (KType)result;
    }

    @Override
    public KType getFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        return (KType)this.buffer[this.head];
    }

    @Override
    public KType getLast() {
        assert (this.size() > 0) : "The deque is empty.";
        return (KType)this.buffer[ObjectArrayDeque.oneLeft(this.tail, this.buffer.length)];
    }

    @Override
    public int removeFirst(KType e1) {
        int index = this.bufferIndexOf(e1);
        if (index >= 0) {
            this.removeAtBufferIndex(index);
        }
        return index;
    }

    public int bufferIndexOf(KType e1) {
        int last = this.tail;
        int bufLen = this.buffer.length;
        int i2 = this.head;
        while (i2 != last) {
            if (this.equals(this.buffer[i2], e1)) {
                return i2;
            }
            i2 = ObjectArrayDeque.oneRight(i2, bufLen);
        }
        return -1;
    }

    @Override
    public int removeLast(KType e1) {
        int index = this.lastBufferIndexOf(e1);
        if (index >= 0) {
            this.removeAtBufferIndex(index);
        }
        return index;
    }

    public int lastBufferIndexOf(KType e1) {
        int bufLen = this.buffer.length;
        int last = ObjectArrayDeque.oneLeft(this.head, bufLen);
        int i2 = ObjectArrayDeque.oneLeft(this.tail, bufLen);
        while (i2 != last) {
            if (this.equals(this.buffer[i2], e1)) {
                return i2;
            }
            i2 = ObjectArrayDeque.oneLeft(i2, bufLen);
        }
        return -1;
    }

    @Override
    public int removeAll(KType e1) {
        int to;
        int removed = 0;
        int last = this.tail;
        int bufLen = this.buffer.length;
        int from = to = this.head;
        while (from != last) {
            if (this.equals(this.buffer[from], e1)) {
                this.buffer[from] = null;
                ++removed;
            } else {
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = null;
                }
                to = ObjectArrayDeque.oneRight(to, bufLen);
            }
            from = ObjectArrayDeque.oneRight(from, bufLen);
        }
        this.tail = to;
        return removed;
    }

    public void removeAtBufferIndex(int index) {
        int rightChunk;
        assert (this.head > this.tail ? index >= this.head || index < this.tail : index >= this.head && index < this.tail) : "Index out of range (head=" + this.head + ", tail=" + this.tail + ", index=" + index + ").";
        Object[] buffer = this.buffer;
        int bufLen = buffer.length;
        int lastIndex = bufLen - 1;
        int head2 = this.head;
        int tail = this.tail;
        int leftChunk = Math.abs(index - head2) % bufLen;
        if (leftChunk < (rightChunk = Math.abs(tail - index) % bufLen)) {
            if (index >= head2) {
                System.arraycopy(buffer, head2, buffer, head2 + 1, leftChunk);
            } else {
                System.arraycopy(buffer, 0, buffer, 1, index);
                buffer[0] = buffer[lastIndex];
                System.arraycopy(buffer, head2, buffer, head2 + 1, lastIndex - head2);
            }
            buffer[head2] = null;
            this.head = ObjectArrayDeque.oneRight(head2, bufLen);
        } else {
            if (index < tail) {
                System.arraycopy(buffer, index + 1, buffer, index, rightChunk);
            } else {
                System.arraycopy(buffer, index + 1, buffer, index, lastIndex - index);
                buffer[lastIndex] = buffer[0];
                System.arraycopy(buffer, 1, buffer, 0, tail);
            }
            buffer[tail] = null;
            this.tail = ObjectArrayDeque.oneLeft(tail, bufLen);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        if (this.head <= this.tail) {
            return this.tail - this.head;
        }
        return this.tail - this.head + this.buffer.length;
    }

    @Override
    public void clear() {
        if (this.head < this.tail) {
            Arrays.fill(this.buffer, this.head, this.tail, null);
        } else {
            Arrays.fill(this.buffer, 0, this.tail, null);
            Arrays.fill(this.buffer, this.head, this.buffer.length, null);
        }
        this.tail = 0;
        this.head = 0;
    }

    @Override
    public void release() {
        this.tail = 0;
        this.head = 0;
        this.buffer = ObjectArrayList.EMPTY_ARRAY;
        this.ensureBufferSpace(0);
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        this.ensureBufferSpace(expectedElements - this.size());
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen = this.buffer.length;
        int elementsCount = this.size();
        if (elementsCount + expectedAdditions >= bufferLen) {
            boolean emptySlot = true;
            int newSize = this.resizer.grow(bufferLen, elementsCount + 1, expectedAdditions);
            assert (newSize >= elementsCount + expectedAdditions + 1) : "Resizer failed to return sensible new size: " + newSize + " <= " + (elementsCount + expectedAdditions);
            try {
                Object[] newBuffer = new Object[newSize];
                if (bufferLen > 0) {
                    this.toArray(newBuffer);
                    this.tail = elementsCount;
                    this.head = 0;
                }
                this.buffer = newBuffer;
            }
            catch (OutOfMemoryError e) {
                throw new BufferAllocationException("Not enough memory to allocate new buffers: %,d -> %,d", (Throwable)e, bufferLen, newSize);
            }
        }
    }

    @Override
    public Object[] toArray() {
        int size = this.size();
        return this.toArray(new Object[size]);
    }

    public KType[] toArray(KType[] target) {
        assert (target.length >= this.size()) : "Target array must be >= " + this.size();
        if (this.head < this.tail) {
            System.arraycopy(this.buffer, this.head, target, 0, this.size());
        } else if (this.head > this.tail) {
            int rightCount = this.buffer.length - this.head;
            System.arraycopy(this.buffer, this.head, target, 0, rightCount);
            System.arraycopy(this.buffer, 0, target, rightCount, this.tail);
        }
        return target;
    }

    public ObjectArrayDeque<KType> clone() {
        try {
            ObjectArrayDeque cloned = (ObjectArrayDeque)super.clone();
            cloned.buffer = (Object[])this.buffer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected static int oneLeft(int index, int modulus) {
        if (index >= 1) {
            return index - 1;
        }
        return modulus - 1;
    }

    protected static int oneRight(int index, int modulus) {
        if (index + 1 == modulus) {
            return 0;
        }
        return index + 1;
    }

    @Override
    public long ramBytesAllocated() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8) + RamUsageEstimator.shallowSizeOf(this.resizer) + RamUsageEstimator.shallowSizeOf(this.buffer);
    }

    @Override
    public long ramBytesUsed() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8) + RamUsageEstimator.shallowSizeOf(this.resizer) + RamUsageEstimator.shallowUsedSizeOfArray(this.buffer, this.size());
    }

    @Override
    public Iterator<ObjectCursor<KType>> iterator() {
        return new ValueIterator();
    }

    @Override
    public Iterator<ObjectCursor<KType>> descendingIterator() {
        return new DescendingValueIterator();
    }

    @Override
    public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
        this.forEach(procedure, this.head, this.tail);
        return procedure;
    }

    private void forEach(ObjectProcedure<? super KType> procedure, int fromIndex, int toIndex) {
        Object[] buffer = this.buffer;
        int i2 = fromIndex;
        while (i2 != toIndex) {
            procedure.apply(buffer[i2]);
            i2 = ObjectArrayDeque.oneRight(i2, buffer.length);
        }
    }

    @Override
    public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
        int fromIndex = this.head;
        int toIndex = this.tail;
        Object[] buffer = this.buffer;
        int i2 = fromIndex;
        while (i2 != toIndex && predicate.apply((Object)buffer[i2])) {
            i2 = ObjectArrayDeque.oneRight(i2, buffer.length);
        }
        return predicate;
    }

    @Override
    public <T extends ObjectProcedure<? super KType>> T descendingForEach(T procedure) {
        this.descendingForEach(procedure, this.head, this.tail);
        return procedure;
    }

    private void descendingForEach(ObjectProcedure<? super KType> procedure, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        Object[] buffer = this.buffer;
        int i2 = toIndex;
        do {
            i2 = ObjectArrayDeque.oneLeft(i2, buffer.length);
            procedure.apply(buffer[i2]);
        } while (i2 != fromIndex);
    }

    @Override
    public <T extends ObjectPredicate<? super KType>> T descendingForEach(T predicate) {
        this.descendingForEach(predicate, this.head, this.tail);
        return predicate;
    }

    private void descendingForEach(ObjectPredicate<? super KType> predicate, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        Object[] buffer = this.buffer;
        int i2 = toIndex;
        while (predicate.apply(buffer[i2 = ObjectArrayDeque.oneLeft(i2, buffer.length)]) && i2 != fromIndex) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        int to;
        Object[] buffer = this.buffer;
        int last = this.tail;
        int bufLen = buffer.length;
        int removed = 0;
        int from = to = this.head;
        try {
            from = to = this.head;
            while (from != last) {
                if (predicate.apply(buffer[from])) {
                    buffer[from] = null;
                    ++removed;
                } else {
                    if (to != from) {
                        buffer[to] = buffer[from];
                        buffer[from] = null;
                    }
                    to = ObjectArrayDeque.oneRight(to, bufLen);
                }
                from = ObjectArrayDeque.oneRight(from, bufLen);
            }
        }
        finally {
            while (from != last) {
                if (to != from) {
                    buffer[to] = buffer[from];
                    buffer[from] = null;
                }
                to = ObjectArrayDeque.oneRight(to, bufLen);
                from = ObjectArrayDeque.oneRight(from, bufLen);
            }
            this.tail = to;
        }
        return removed;
    }

    @Override
    public boolean contains(KType e) {
        int fromIndex = this.head;
        int toIndex = this.tail;
        Object[] buffer = this.buffer;
        int i2 = fromIndex;
        while (i2 != toIndex) {
            if (this.equals(buffer[i2], e)) {
                return true;
            }
            i2 = ObjectArrayDeque.oneRight(i2, buffer.length);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        int fromIndex = this.head;
        int toIndex = this.tail;
        Object[] buffer = this.buffer;
        int i2 = fromIndex;
        while (i2 != toIndex) {
            h = 31 * h + BitMixer.mix(this.buffer[i2]);
            i2 = ObjectArrayDeque.oneRight(i2, buffer.length);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.equalElements((ObjectArrayDeque)this.getClass().cast(obj));
    }

    protected boolean equalElements(ObjectArrayDeque<?> other) {
        int max = this.size();
        if (other.size() != max) {
            return false;
        }
        Iterator<ObjectCursor<KType>> i1 = this.iterator();
        Iterator<ObjectCursor<?>> i2 = other.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            if (this.equals(i2.next().value, i1.next().value)) continue;
            return false;
        }
        return !i1.hasNext() && !i2.hasNext();
    }

    @SafeVarargs
    public static <KType> ObjectArrayDeque<KType> from(KType ... elements) {
        ObjectArrayDeque<KType> coll = new ObjectArrayDeque<KType>(elements.length);
        coll.addLast(elements);
        return coll;
    }

    private final class DescendingValueIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor = new ObjectCursor();
        private int remaining;

        public DescendingValueIterator() {
            this.cursor.index = ObjectArrayDeque.this.tail;
            this.remaining = ObjectArrayDeque.this.size();
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            if (this.remaining == 0) {
                return (ObjectCursor)this.done();
            }
            --this.remaining;
            this.cursor.index = ObjectArrayDeque.oneLeft(this.cursor.index, ObjectArrayDeque.this.buffer.length);
            this.cursor.value = ObjectArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }
    }

    private final class ValueIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor = new ObjectCursor();
        private int remaining;

        public ValueIterator() {
            this.cursor.index = ObjectArrayDeque.oneLeft(ObjectArrayDeque.this.head, ObjectArrayDeque.this.buffer.length);
            this.remaining = ObjectArrayDeque.this.size();
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            if (this.remaining == 0) {
                return (ObjectCursor)this.done();
            }
            --this.remaining;
            this.cursor.index = ObjectArrayDeque.oneRight(this.cursor.index, ObjectArrayDeque.this.buffer.length);
            this.cursor.value = ObjectArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }
    }
}

