/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.symspell.implementation;

public class EditDistance {
    private String baseString;
    private DistanceAlgorithm algorithm;
    private int[] v0;
    private int[] v2;

    public EditDistance(String baseString, DistanceAlgorithm algorithm) {
        this.baseString = baseString;
        this.algorithm = algorithm;
        if (this.baseString.isEmpty()) {
            this.baseString = null;
            return;
        }
        if (algorithm == DistanceAlgorithm.Damerau) {
            this.v0 = new int[baseString.length()];
            this.v2 = new int[baseString.length()];
        }
    }

    public int compare(String string2, int maxDistance) {
        switch (this.algorithm) {
            case Damerau: {
                return this.DamerauLevenshteinDistance(string2, maxDistance);
            }
        }
        throw new IllegalArgumentException("unknown DistanceAlgorithm");
    }

    public int DamerauLevenshteinDistance(String string2, int maxDistance) {
        int j;
        int start;
        String string1;
        if (this.baseString == null) {
            return string2 == null ? 0 : string2.length();
        }
        if (string2 == null || string2.isEmpty()) {
            return this.baseString.length();
        }
        if (maxDistance == 0) {
            return this.baseString.equals(string2) ? 0 : -1;
        }
        if (this.baseString.length() > string2.length()) {
            string1 = string2;
            string2 = this.baseString;
        } else {
            string1 = this.baseString;
        }
        int sLen = string1.length();
        int tLen = string2.length();
        while (sLen > 0 && string1.charAt(sLen - 1) == string2.charAt(tLen - 1)) {
            --sLen;
            --tLen;
        }
        if (string1.charAt(0) == string2.charAt(0) || sLen == 0) {
            for (start = 0; start < sLen && string1.charAt(start) == string2.charAt(start); ++start) {
            }
            tLen -= start;
            if ((sLen -= start) == 0) {
                return tLen;
            }
            string2 = string2.substring(start, start + tLen);
        }
        int lenDiff = tLen - sLen;
        if (maxDistance < 0 || maxDistance > tLen) {
            maxDistance = tLen;
        } else if (lenDiff > maxDistance) {
            return -1;
        }
        if (tLen > this.v0.length) {
            this.v0 = new int[tLen];
            this.v2 = new int[tLen];
        } else {
            for (int i2 = 0; i2 < tLen; ++i2) {
                this.v2[i2] = 0;
            }
        }
        for (j = 0; j < maxDistance; ++j) {
            this.v0[j] = j + 1;
        }
        while (j < tLen) {
            this.v0[j] = maxDistance + 1;
            ++j;
        }
        int jStartOffset = maxDistance - (tLen - sLen);
        boolean haveMax = maxDistance < tLen;
        int jStart = 0;
        int jEnd = maxDistance;
        char sChar = string1.charAt(0);
        int current = 0;
        for (int i3 = 0; i3 < sLen; ++i3) {
            char prevsChar = sChar;
            sChar = string1.charAt(start + i3);
            char tChar = string2.charAt(0);
            int left = i3;
            current = left + 1;
            int nextTransCost = 0;
            jEnd += jEnd < tLen ? 1 : 0;
            for (j = jStart += i3 > jStartOffset ? 1 : 0; j < jEnd; ++j) {
                int above = current;
                int thisTransCost = nextTransCost;
                nextTransCost = this.v2[j];
                this.v2[j] = current = left;
                left = this.v0[j];
                char prevtChar = tChar;
                tChar = string2.charAt(j);
                if (sChar != tChar) {
                    if (left < current) {
                        current = left;
                    }
                    if (above < current) {
                        current = above;
                    }
                    if (i3 != 0 && j != 0 && sChar == prevtChar && prevsChar == tChar && ++thisTransCost < ++current) {
                        current = thisTransCost;
                    }
                }
                this.v0[j] = current;
            }
            if (!haveMax || this.v0[i3 + lenDiff] <= maxDistance) continue;
            return -1;
        }
        return current <= maxDistance ? current : -1;
    }

    public static enum DistanceAlgorithm {
        Damerau;

    }
}

