/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.config;

import com.intellij.openapi.components.PathMacroMap;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.workspaceModel.ide.impl.UtilsKt;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryNameGenerator;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ExtensionsKt;
import com.intellij.workspaceModel.storage.bridgeEntities.api.ContentRootEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.api.JavaModuleSettingsEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.api.JavaSourceRootEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.api.LibraryEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.api.LibraryRoot;
import com.intellij.workspaceModel.storage.bridgeEntities.api.LibraryTableId;
import com.intellij.workspaceModel.storage.bridgeEntities.api.ModuleDependencyItem;
import com.intellij.workspaceModel.storage.bridgeEntities.api.ModuleEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.api.SourceRootEntity;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.config.ModulePathShortener;
import org.jetbrains.idea.eclipse.conversion.EPathUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012 \u0010\u0004\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0016J-\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u000b\u0010\u001d\u001a\u00070\u0010\u00a2\u0006\u0002\b\u001eH\u0002R(\u0010\u0004\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/idea/eclipse/config/EmlFileSaver;", "", "module", "Lcom/intellij/workspaceModel/storage/bridgeEntities/api/ModuleEntity;", "entities", "", "Ljava/lang/Class;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "", "pathShortener", "Lorg/jetbrains/idea/eclipse/config/ModulePathShortener;", "moduleReplacePathMacroMap", "Lcom/intellij/openapi/components/PathMacroMap;", "projectReplacePathMacroMap", "(Lcom/intellij/workspaceModel/storage/bridgeEntities/api/ModuleEntity;Ljava/util/Map;Lorg/jetbrains/idea/eclipse/config/ModulePathShortener;Lcom/intellij/openapi/components/PathMacroMap;Lcom/intellij/openapi/components/PathMacroMap;)V", "generateLibName", "", "library", "Lcom/intellij/workspaceModel/storage/bridgeEntities/api/LibraryEntity;", "saveContentRoots", "", "root", "Lorg/jdom/Element;", "saveCustomJavaSettings", "saveEml", "saveModuleRelatedRoots", "libTag", "type", "Lcom/intellij/openapi/roots/OrderRootType;", "tagName", "Lorg/jetbrains/annotations/NonNls;", "intellij.eclipse"})
public final class EmlFileSaver {
    private final ModuleEntity module;
    private final Map<Class<? extends WorkspaceEntity>, List<WorkspaceEntity>> entities;
    private final ModulePathShortener pathShortener;
    private final PathMacroMap moduleReplacePathMacroMap;
    private final PathMacroMap projectReplacePathMacroMap;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Element saveEml() {
        Object element$iv;
        void $this$associateByTo$iv$iv;
        Element root = new Element("component");
        this.saveCustomJavaSettings(root);
        this.saveContentRoots(root);
        List list = this.entities.get(LibraryEntity.class);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable $this$associateBy$iv = list;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterator iterator = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            LibraryEntity libraryEntity = (LibraryEntity)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            map.put(string, element$iv$iv);
        }
        Map moduleLibraries2 = destination$iv$iv;
        LinkedHashMap libLevels = new LinkedHashMap();
        Object $this$forEach$iv = this.module.getDependencies();
        boolean $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            ModuleDependencyItem dep = (ModuleDependencyItem)element$iv;
            boolean bl = false;
            ModuleDependencyItem moduleDependencyItem = dep;
            if (moduleDependencyItem instanceof ModuleDependencyItem.Exportable.ModuleDependency) {
                if (((ModuleDependencyItem.Exportable.ModuleDependency)dep).getScope() == ModuleDependencyItem.DependencyScope.COMPILE) continue;
                root.addContent(new Element("module").setAttribute("name", ((ModuleDependencyItem.Exportable.ModuleDependency)dep).getModule().getName()).setAttribute("scope", ((ModuleDependencyItem.Exportable.ModuleDependency)dep).getScope().name()));
                continue;
            }
            if (moduleDependencyItem instanceof ModuleDependencyItem.InheritedSdkDependency) {
                root.setAttribute("inheritJdk", String.valueOf(true));
                continue;
            }
            if (moduleDependencyItem instanceof ModuleDependencyItem.SdkDependency) {
                root.setAttribute("jdk", ((ModuleDependencyItem.SdkDependency)dep).getSdkName());
                root.setAttribute("jdk_type", ((ModuleDependencyItem.SdkDependency)dep).getSdkType());
                continue;
            }
            if (!(moduleDependencyItem instanceof ModuleDependencyItem.Exportable.LibraryDependency)) continue;
            Element libTag = new Element("lib");
            LibraryEntity library = (LibraryEntity)moduleLibraries2.get(((ModuleDependencyItem.Exportable.LibraryDependency)dep).getLibrary().getName());
            String string = LibraryNameGenerator.INSTANCE.getLegacyLibraryName(((ModuleDependencyItem.Exportable.LibraryDependency)dep).getLibrary());
            if (string == null) {
                string = this.generateLibName(library);
            }
            String libName = string;
            libTag.setAttribute("name", libName);
            libTag.setAttribute("scope", ((ModuleDependencyItem.Exportable.LibraryDependency)dep).getScope().name());
            LibraryTableId tableId = ((ModuleDependencyItem.Exportable.LibraryDependency)dep).getLibrary().getTableId();
            if (tableId instanceof LibraryTableId.ModuleLibraryTableId) {
                if (library != null) {
                    void $this$filterTo$iv$iv;
                    void $this$filterTo$iv$iv2;
                    Iterable $this$filter$iv = library.getRoots();
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Object destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                        LibraryRoot it = (LibraryRoot)element$iv$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getType().getName(), (Object)OrderRootType.SOURCES.name())) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    List srcRoots = (List)destination$iv$iv2;
                    Object object = (LibraryRoot)CollectionsKt.firstOrNull((List)srcRoots);
                    String eclipseUrl = object != null && (object = object.getUrl()) != null && (object = object.getUrl()) != null ? StringsKt.substringBefore$default((String)object, (String)"!/", null, (int)2, null) : null;
                    Iterable $this$forEach$iv2 = srcRoots;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        LibraryRoot it = (LibraryRoot)element$iv2;
                        boolean bl3 = false;
                        String url = it.getUrl().getUrl();
                        Element srcTag = new Element("srcroot").setAttribute("url", url);
                        if (!EPathUtil.areUrlsPointTheSame(url, eclipseUrl)) {
                            srcTag.setAttribute("bind", String.valueOf(false));
                        }
                        libTag.addContent(srcTag);
                    }
                    Iterable $this$filter$iv2 = library.getRoots();
                    boolean $i$f$filter2 = false;
                    destination$iv$iv2 = $this$filter$iv2;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$filterTo2 = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        LibraryRoot it = (LibraryRoot)element$iv$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it.getType().getName(), (Object)"JAVADOC")) continue;
                        destination$iv$iv3.add(element$iv$iv);
                    }
                    $this$forEach$iv2 = CollectionsKt.drop((Iterable)((List)destination$iv$iv3), (int)1);
                    $i$f$forEach2 = false;
                    for (Object element$iv3 : $this$forEach$iv2) {
                        LibraryRoot it = (LibraryRoot)element$iv3;
                        boolean bl5 = false;
                        libTag.addContent(new Element("javadocroot_attr").setAttribute("url", it.getUrl().getUrl()));
                    }
                    OrderRootType orderRootType = OrderRootType.SOURCES;
                    Intrinsics.checkNotNullExpressionValue((Object)orderRootType, (String)"OrderRootType.SOURCES");
                    this.saveModuleRelatedRoots(libTag, library, orderRootType, "relative-module-src");
                    OrderRootType orderRootType2 = OrderRootType.CLASSES;
                    Intrinsics.checkNotNullExpressionValue((Object)orderRootType2, (String)"OrderRootType.CLASSES");
                    this.saveModuleRelatedRoots(libTag, library, orderRootType2, "relative-module-cls");
                    OrderRootType orderRootType3 = JavadocOrderRootType.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)orderRootType3, (String)"JavadocOrderRootType.getInstance()");
                    this.saveModuleRelatedRoots(libTag, library, orderRootType3, "relative-module-javadoc");
                }
            } else if (tableId instanceof LibraryTableId.ProjectLibraryTableId) {
                ((Map)libLevels).put(((ModuleDependencyItem.Exportable.LibraryDependency)dep).getLibrary().getName(), "project");
            } else if (tableId instanceof LibraryTableId.GlobalLibraryTableId && Intrinsics.areEqual((Object)tableId.getLevel(), (Object)"application") ^ true) {
                ((Map)libLevels).put(((ModuleDependencyItem.Exportable.LibraryDependency)dep).getLibrary().getName(), tableId.getLevel());
            }
            List list2 = libTag.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"libTag.children");
            Collection collection = list2;
            if (!(!collection.isEmpty()) && ((ModuleDependencyItem.Exportable.LibraryDependency)dep).getScope() == ModuleDependencyItem.DependencyScope.COMPILE) continue;
            root.addContent(libTag);
        }
        $this$forEach$iv = libLevels;
        if (!$this$forEach$iv.isEmpty()) {
            Element levelsTag = new Element("levels");
            element$iv = libLevels;
            iterator = element$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void name;
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                element$iv = (String)entry2.getKey();
                entry2 = entry;
                String level = (String)entry2.getValue();
                levelsTag.addContent(new Element("level").setAttribute("name", (String)name).setAttribute("value", level));
            }
            root.addContent(levelsTag);
        }
        this.moduleReplacePathMacroMap.substitute(root, SystemInfo.isFileSystemCaseSensitive);
        return JDOMUtil.isEmpty((Element)root) ? null : root;
    }

    /*
     * WARNING - void declaration
     */
    private final void saveModuleRelatedRoots(Element libTag, LibraryEntity library, OrderRootType type, String tagName) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = library.getRoots();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LibraryRoot it = (LibraryRoot)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType().getName(), (Object)type.name())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile file;
            LibraryRoot it = (LibraryRoot)element$iv;
            boolean bl = false;
            VirtualFile virtualFile = file = UtilsKt.getVirtualFile((VirtualFileUrl)it.getUrl());
            VirtualFile localFile = (virtualFile != null ? virtualFile.getFileSystem() : null) instanceof JarFileSystem ? JarFileSystem.getInstance().getVirtualFileForJar(file) : file;
            if (localFile == null || !this.pathShortener.isUnderContentRoots(localFile)) continue;
            libTag.addContent(new Element(tagName).setAttribute("project-related", this.projectReplacePathMacroMap.substitute(it.getUrl().getUrl(), SystemInfo.isFileSystemCaseSensitive)));
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final String generateLibName(LibraryEntity library) {
        block5: {
            v0 /* !! */  = library;
            if (v0 /* !! */  == null || (v0 /* !! */  = v0 /* !! */ .getRoots()) == null) ** GOTO lbl-1000
            $this$firstOrNull$iv = (Iterable)v0 /* !! */ ;
            $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                it = (LibraryRoot)element$iv;
                $i$a$-firstOrNull-EmlFileSaver$generateLibName$firstRoot$1 = false;
                if (!Intrinsics.areEqual((Object)it.getType().getName(), (Object)OrderRootType.CLASSES.name())) continue;
                v1 = element$iv;
                break block5;
            }
            v1 = null;
        }
        if ((v0 /* !! */  = (LibraryRoot)v1) != null) {
            v2 = v0 /* !! */ .getUrl();
        } else lbl-1000:
        // 2 sources

        {
            v2 = null;
        }
        v3 = firstRoot = v2;
        file = v3 != null ? UtilsKt.getVirtualFile(v3) : null;
        fileForJar = JarFileSystem.getInstance().getVirtualFileForJar(file);
        if (fileForJar != null) {
            v4 = fileForJar.getName();
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"fileForJar.name");
            return v4;
        }
        v5 /* !! */  = file;
        if (v5 /* !! */  == null || (v5 /* !! */  = v5 /* !! */ .getName()) == null) {
            v5 /* !! */  = "Empty Library";
        }
        return v5 /* !! */ ;
    }

    private final void saveContentRoots(Element root) {
        Iterable $this$forEach$iv = this.module.getContentRoots();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ContentRootEntity contentRoot = (ContentRootEntity)element$iv;
            boolean bl = false;
            Element contentRootTag = new Element("contentEntry").setAttribute("url", contentRoot.getUrl().getUrl());
            Iterable $this$forEach$iv2 = contentRoot.getSourceRoots();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                SourceRootEntity sourceRoot2 = (SourceRootEntity)element$iv2;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)sourceRoot2.getRootType(), (Object)"java-test")) {
                    contentRootTag.addContent(new Element("testFolder").setAttribute("url", sourceRoot2.getUrl().getUrl()));
                }
                JavaSourceRootEntity javaSourceRootEntity = ExtensionsKt.asJavaSourceRoot((SourceRootEntity)sourceRoot2);
                String packagePrefix = javaSourceRootEntity != null ? javaSourceRootEntity.getPackagePrefix() : null;
                CharSequence charSequence = packagePrefix;
                if (charSequence == null || charSequence.length() == 0) continue;
                contentRootTag.addContent(new Element("packagePrefix").setAttribute("url", sourceRoot2.getUrl().getUrl()).setAttribute("value", packagePrefix));
            }
            VirtualFile rootFile = UtilsKt.getVirtualFile((VirtualFileUrl)contentRoot.getUrl());
            Iterable $this$forEach$iv3 = contentRoot.getExcludedUrls();
            boolean $i$f$forEach3 = false;
            for (Object element$iv3 : $this$forEach$iv3) {
                VirtualFileUrl excluded = (VirtualFileUrl)element$iv3;
                boolean bl3 = false;
                VirtualFile excludedFile = UtilsKt.getVirtualFile((VirtualFileUrl)excluded);
                if (rootFile != null && excludedFile != null && !VfsUtilCore.isAncestor((VirtualFile)rootFile, (VirtualFile)excludedFile, (boolean)false)) continue;
                contentRootTag.addContent(new Element("excludeFolder").setAttribute("url", excluded.getUrl()));
            }
            if (JDOMUtil.isEmpty((Element)contentRootTag)) continue;
            root.addContent(contentRootTag);
        }
    }

    private final void saveCustomJavaSettings(Element root) {
        block4: {
            Object object;
            JavaModuleSettingsEntity javaModuleSettingsEntity;
            JavaModuleSettingsEntity javaModuleSettingsEntity2 = this.module.getJavaSettings();
            if (javaModuleSettingsEntity2 == null) break block4;
            JavaModuleSettingsEntity javaSettings = javaModuleSettingsEntity = javaModuleSettingsEntity2;
            boolean bl = false;
            VirtualFileUrl virtualFileUrl = javaSettings.getCompilerOutputForTests();
            if (virtualFileUrl != null) {
                VirtualFileUrl testOutput = object = virtualFileUrl;
                boolean bl2 = false;
                root.addContent(new Element("output-test").setAttribute("url", testOutput.getUrl()));
            }
            if (javaSettings.getInheritedCompilerOutput()) {
                root.setAttribute("inherit-compiler-output", String.valueOf(true));
            }
            if (javaSettings.getExcludeOutput()) {
                root.addContent(new Element("exclude-output"));
            }
            String string = javaSettings.getLanguageLevelId();
            if (string != null) {
                Object it = object = string;
                boolean bl3 = false;
                root.setAttribute("LANGUAGE_LEVEL", (String)it);
            }
        }
    }

    public EmlFileSaver(@NotNull ModuleEntity module, @NotNull Map<Class<? extends WorkspaceEntity>, ? extends List<? extends WorkspaceEntity>> entities, @NotNull ModulePathShortener pathShortener, @NotNull PathMacroMap moduleReplacePathMacroMap, @NotNull PathMacroMap projectReplacePathMacroMap) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        Intrinsics.checkNotNullParameter((Object)pathShortener, (String)"pathShortener");
        Intrinsics.checkNotNullParameter((Object)moduleReplacePathMacroMap, (String)"moduleReplacePathMacroMap");
        Intrinsics.checkNotNullParameter((Object)projectReplacePathMacroMap, (String)"projectReplacePathMacroMap");
        this.module = module;
        this.entities = entities;
        this.pathShortener = pathShortener;
        this.moduleReplacePathMacroMap = moduleReplacePathMacroMap;
        this.projectReplacePathMacroMap = projectReplacePathMacroMap;
    }
}

