/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableRunConfigurationOptions;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfile;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.testframework.sm.runner.SMRunnerConsolePropertiesProvider;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import java.util.StringJoiner;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.GradleIdeManager;
import org.jetbrains.plugins.gradle.execution.target.GradleRuntimeType;
import org.jetbrains.plugins.gradle.service.execution.GradleDebugSettingsEditor;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleCommandLine;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleRunConfiguration
extends ExternalSystemRunConfiguration
implements SMRunnerConsolePropertiesProvider,
TargetEnvironmentAwareRunProfile {
    public static final String DEBUG_FLAG_NAME = "GradleScriptDebugEnabled";
    public static final String DEBUG_ALL_NAME = "DebugAllEnabled";
    public static final Key<Boolean> DEBUG_FLAG_KEY = Key.create((String)"DEBUG_GRADLE_SCRIPT");
    public static final Key<Boolean> DEBUG_ALL_KEY = Key.create((String)"DEBUG_ALL_TASKS");
    @ApiStatus.Internal
    public static final Key<String> DEBUGGER_PARAMETERS_KEY = Key.create((String)"DEBUGGER_PARAMETERS");
    private boolean isDebugAllEnabled = false;

    public GradleRunConfiguration(Project project, ConfigurationFactory factory, String name2) {
        super(GradleConstants.SYSTEM_ID, project, factory, name2);
        this.setDebugServerProcess(true);
        this.setReattachDebugProcess(true);
    }

    public boolean isScriptDebugEnabled() {
        return this.isDebugServerProcess();
    }

    public void setScriptDebugEnabled(boolean scriptDebugEnabled) {
        this.setDebugServerProcess(scriptDebugEnabled);
    }

    @NotNull
    public String getRawCommandLine() {
        StringJoiner commandLine = new StringJoiner(" ");
        for (String taskName : this.getSettings().getTaskNames()) {
            commandLine.add(taskName);
        }
        String scriptParameters = this.getSettings().getScriptParameters();
        if (StringUtil.isNotEmpty((String)scriptParameters)) {
            commandLine.add(scriptParameters);
        }
        String string2 = commandLine.toString();
        if (string2 == null) {
            GradleRunConfiguration.$$$reportNull$$$0(0);
        }
        return string2;
    }

    public void setRawCommandLine(@NotNull String commandLine) {
        if (commandLine == null) {
            GradleRunConfiguration.$$$reportNull$$$0(1);
        }
        this.setCommandLine(GradleCommandLine.parse(commandLine));
    }

    public void setCommandLine(@NotNull GradleCommandLine commandLine) {
        if (commandLine == null) {
            GradleRunConfiguration.$$$reportNull$$$0(2);
        }
        this.getSettings().setTaskNames(commandLine.getTasksAndArguments().toList());
        this.getSettings().setScriptParameters(commandLine.getScriptParameters().toString());
    }

    @NotNull
    public GradleCommandLine getCommandLine() {
        GradleCommandLine gradleCommandLine = GradleCommandLine.parse(this.getRawCommandLine());
        if (gradleCommandLine == null) {
            GradleRunConfiguration.$$$reportNull$$$0(3);
        }
        return gradleCommandLine;
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        if (executor == null) {
            GradleRunConfiguration.$$$reportNull$$$0(4);
        }
        if (env == null) {
            GradleRunConfiguration.$$$reportNull$$$0(5);
        }
        this.putUserData(DEBUG_FLAG_KEY, this.isDebugServerProcess());
        this.putUserData(DEBUG_ALL_KEY, this.isDebugAllEnabled);
        return super.getState(executor, env);
    }

    @ApiStatus.Internal
    @NotNull
    public LocatableRunConfigurationOptions getOptions() {
        LocatableRunConfigurationOptions locatableRunConfigurationOptions = super.getOptions();
        if (locatableRunConfigurationOptions == null) {
            GradleRunConfiguration.$$$reportNull$$$0(6);
        }
        return locatableRunConfigurationOptions;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        Element debugAll;
        if (element == null) {
            GradleRunConfiguration.$$$reportNull$$$0(7);
        }
        super.readExternal(element);
        Element child = element.getChild(DEBUG_FLAG_NAME);
        if (child != null) {
            this.setDebugServerProcess(Boolean.parseBoolean(child.getText()));
        }
        if ((debugAll = element.getChild(DEBUG_ALL_NAME)) != null) {
            this.isDebugAllEnabled = Boolean.parseBoolean(debugAll.getText());
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            GradleRunConfiguration.$$$reportNull$$$0(8);
        }
        super.writeExternal(element);
        Element debugAll = new Element(DEBUG_ALL_NAME);
        debugAll.setText(String.valueOf(this.isDebugAllEnabled));
        element.addContent(debugAll);
    }

    @NotNull
    public SettingsEditor<ExternalSystemRunConfiguration> getConfigurationEditor() {
        if (Registry.is((String)"ide.new.run.config", (boolean)true)) {
            SettingsEditor settingsEditor = super.getConfigurationEditor();
            if (settingsEditor == null) {
                GradleRunConfiguration.$$$reportNull$$$0(9);
            }
            return settingsEditor;
        }
        SettingsEditor editor = super.getConfigurationEditor();
        if (editor instanceof SettingsEditorGroup) {
            SettingsEditorGroup group = (SettingsEditorGroup)editor;
            group.addEditor(GradleBundle.message("gradle.settings.title.debug", new Object[0]), (SettingsEditor)new GradleDebugSettingsEditor());
        }
        SettingsEditor settingsEditor = editor;
        if (settingsEditor == null) {
            GradleRunConfiguration.$$$reportNull$$$0(10);
        }
        return settingsEditor;
    }

    @NotNull
    public SMTRunnerConsoleProperties createTestConsoleProperties(@NotNull Executor executor) {
        if (executor == null) {
            GradleRunConfiguration.$$$reportNull$$$0(11);
        }
        SMTRunnerConsoleProperties sMTRunnerConsoleProperties = GradleIdeManager.getInstance().createTestConsoleProperties(this.getProject(), executor, (RunConfiguration)this);
        if (sMTRunnerConsoleProperties == null) {
            GradleRunConfiguration.$$$reportNull$$$0(12);
        }
        return sMTRunnerConsoleProperties;
    }

    public boolean isDebugAllEnabled() {
        return this.isDebugAllEnabled;
    }

    public void setDebugAllEnabled(boolean debugAllEnabled) {
        this.isDebugAllEnabled = debugAllEnabled;
    }

    public boolean canRunOn(@NotNull TargetEnvironmentConfiguration target) {
        if (target == null) {
            GradleRunConfiguration.$$$reportNull$$$0(13);
        }
        return true;
    }

    @Nullable
    public LanguageRuntimeType<?> getDefaultLanguageRuntimeType() {
        return (LanguageRuntimeType)LanguageRuntimeType.EXTENSION_NAME.findExtension(GradleRuntimeType.class);
    }

    @Nullable
    public String getDefaultTargetName() {
        return this.getOptions().getRemoteTarget();
    }

    public void setDefaultTargetName(@Nullable String targetName) {
        this.getOptions().setRemoteTarget(targetName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 13: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/execution/GradleRunConfiguration";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawCommandLine";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/execution/GradleRunConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLine";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestConsoleProperties";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setRawCommandLine";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setCommandLine";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createTestConsoleProperties";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "canRunOn";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 13: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

