/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.util.graph.manager.DependencyManagerUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.model.MavenArtifactState;
import org.jetbrains.idea.maven.model.MavenBuild;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenParent;
import org.jetbrains.idea.maven.server.MavenModelConverter;

public final class Maven3AetherModelConverter
extends MavenModelConverter {
    @NotNull
    public static MavenModel convertModelWithAetherDependencyTree(Model model, List<String> sources, List<String> testSources, Collection<? extends org.apache.maven.artifact.Artifact> dependencies, Collection<? extends DependencyNode> dependencyTree, Collection<? extends org.apache.maven.artifact.Artifact> extensions, File localRepository) throws RemoteException {
        MavenModel result = new MavenModel();
        result.setMavenId(new MavenId(model.getGroupId(), model.getArtifactId(), model.getVersion()));
        Parent parent = model.getParent();
        if (parent != null) {
            result.setParent(new MavenParent(new MavenId(parent.getGroupId(), parent.getArtifactId(), parent.getVersion()), parent.getRelativePath()));
        }
        result.setPackaging(model.getPackaging());
        result.setName(model.getName());
        result.setProperties(model.getProperties() == null ? new Properties() : model.getProperties());
        result.setPlugins(Maven3AetherModelConverter.convertPlugins((Model)model));
        HashMap<org.apache.maven.artifact.Artifact, MavenArtifact> convertedArtifacts = new HashMap<org.apache.maven.artifact.Artifact, MavenArtifact>();
        result.setExtensions(Maven3AetherModelConverter.convertArtifacts(extensions, convertedArtifacts, (File)localRepository));
        result.setDependencyTree(Maven3AetherModelConverter.convertAetherDependencyNodes(null, dependencyTree, convertedArtifacts, localRepository));
        result.setDependencies(Maven3AetherModelConverter.convertArtifacts(dependencies, convertedArtifacts, (File)localRepository));
        result.setRemoteRepositories(Maven3AetherModelConverter.convertRepositories((List)model.getRepositories()));
        result.setProfiles(Maven3AetherModelConverter.convertProfiles((Collection)model.getProfiles()));
        result.setModules(model.getModules());
        Maven3AetherModelConverter.convertBuild((MavenBuild)result.getBuild(), (Build)model.getBuild(), sources, testSources);
        MavenModel mavenModel = result;
        if (mavenModel == null) {
            Maven3AetherModelConverter.$$$reportNull$$$0(0);
        }
        return mavenModel;
    }

    public static List<MavenArtifactNode> convertAetherDependencyNodes(MavenArtifactNode parent, Collection<? extends DependencyNode> nodes, Map<org.apache.maven.artifact.Artifact, MavenArtifact> nativeToConvertedMap, File localRepository) {
        ArrayList<MavenArtifactNode> result = new ArrayList<MavenArtifactNode>(nodes.size());
        for (DependencyNode dependencyNode : nodes) {
            org.apache.maven.artifact.Artifact a = Maven3AetherModelConverter.toArtifact(dependencyNode.getDependency());
            MavenArtifact ma = Maven3AetherModelConverter.convertArtifact((org.apache.maven.artifact.Artifact)a, nativeToConvertedMap, (File)localRepository);
            Map data = dependencyNode.getData();
            String premanagedVersion = DependencyManagerUtils.getPremanagedVersion((DependencyNode)dependencyNode);
            String premanagedScope = DependencyManagerUtils.getPremanagedScope((DependencyNode)dependencyNode);
            MavenArtifactState state = MavenArtifactState.ADDED;
            MavenArtifact relatedArtifact = null;
            String scope = dependencyNode.getDependency().getScope();
            Object winner = data.get("conflict.winner");
            if (winner instanceof DependencyNode) {
                DependencyNode winnerNode = (DependencyNode)winner;
                scope = winnerNode.getDependency().getScope();
                org.apache.maven.artifact.Artifact winnerArtifact = Maven3AetherModelConverter.toArtifact(winnerNode.getDependency());
                relatedArtifact = Maven3AetherModelConverter.convertArtifact((org.apache.maven.artifact.Artifact)winnerArtifact, nativeToConvertedMap, (File)localRepository);
                nativeToConvertedMap.put(winnerArtifact, relatedArtifact);
                state = !Objects.equals(dependencyNode.getVersion().toString(), winnerNode.getVersion().toString()) ? MavenArtifactState.CONFLICT : MavenArtifactState.DUPLICATE;
            }
            ma.setScope(scope);
            MavenArtifactNode newNode = new MavenArtifactNode(parent, ma, state, relatedArtifact, dependencyNode.getDependency().getScope(), premanagedVersion, premanagedScope);
            newNode.setDependencies(Maven3AetherModelConverter.convertAetherDependencyNodes(newNode, dependencyNode.getChildren(), nativeToConvertedMap, localRepository));
            result.add(newNode);
        }
        return result;
    }

    @Nullable
    public static org.apache.maven.artifact.Artifact toArtifact(@Nullable Dependency dependency) {
        if (dependency == null) {
            return null;
        }
        org.apache.maven.artifact.Artifact result = RepositoryUtils.toArtifact((Artifact)dependency.getArtifact());
        if (result == null) {
            return null;
        }
        result.setScope(dependency.getScope());
        result.setOptional(dependency.isOptional());
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/Maven3AetherModelConverter", "convertModelWithAetherDependencyTree"));
    }
}

