/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkout;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.CheckoutProviderEx;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.ui.VcsCloneComponent;
import com.intellij.openapi.vcs.ui.cloneDialog.VcsCloneDialogComponentStateListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.cloneableProjects.CloneableProjectsService;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.checkout.GitCloneDialog;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitStandardProgressAnalyzer;
import git4idea.ui.GitCloneDialogComponent;
import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitCheckoutProvider
extends CheckoutProviderEx {
    private static final Logger LOG = Logger.getInstance(GitCheckoutProvider.class);
    private static final List<@NonNls String> NON_ERROR_LINE_PREFIXES = Arrays.asList("Cloning into", "remote:", "submodule");

    public String getVcsName() {
        return "_Git";
    }

    public void doCheckout(@NotNull Project project, @Nullable CheckoutProvider.Listener listener, @Nullable String predefinedRepositoryUrl) {
        if (project == null) {
            GitCheckoutProvider.$$$reportNull$$$0(0);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        GitCloneDialog dialog2 = new GitCloneDialog(project, predefinedRepositoryUrl);
        if (!dialog2.showAndGet()) {
            return;
        }
        dialog2.rememberSettings();
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        File parent = new File(dialog2.getParentDirectory());
        VirtualFile destinationParent = lfs.findFileByIoFile(parent);
        if (destinationParent == null) {
            destinationParent = lfs.refreshAndFindFileByIoFile(parent);
        }
        if (destinationParent == null) {
            return;
        }
        String sourceRepositoryURL = dialog2.getSourceRepositoryURL();
        String directoryName = dialog2.getDirectoryName();
        String parentDirectory = dialog2.getParentDirectory();
        GitCheckoutProvider.clone(project, Git.getInstance(), listener, destinationParent, sourceRepositoryURL, directoryName, parentDirectory);
    }

    public static void clone(final @NotNull Project project, final @NotNull Git git, final CheckoutProvider.Listener listener, final VirtualFile destinationParent, final String sourceRepositoryURL, final String directoryName, final String parentDirectory) {
        if (project == null) {
            GitCheckoutProvider.$$$reportNull$$$0(1);
        }
        if (git == null) {
            GitCheckoutProvider.$$$reportNull$$$0(2);
        }
        String projectAbsolutePath = Paths.get(parentDirectory, directoryName).toAbsolutePath().toString();
        String projectPath = FileUtilRt.toSystemIndependentName((String)projectAbsolutePath);
        CloneableProjectsService.CloneTask cloneTask = new CloneableProjectsService.CloneTask(){

            @NotNull
            public CloneableProjectsService.CloneTaskInfo taskInfo() {
                return new CloneableProjectsService.CloneTaskInfo(DvcsBundle.message((String)"cloning.repository", (Object[])new Object[]{sourceRepositoryURL}), DvcsBundle.message((String)"cloning.repository.cancel", (Object[])new Object[]{sourceRepositoryURL}), DvcsBundle.message((String)"clone.repository", (Object[])new Object[0]), DvcsBundle.message((String)"clone.repository.tooltip", (Object[])new Object[0]), DvcsBundle.message((String)"clone.repository.failed", (Object[])new Object[0]), DvcsBundle.message((String)"clone.repository.canceled", (Object[])new Object[0]), DvcsBundle.message((String)"clone.stop.message.title", (Object[])new Object[0]), DvcsBundle.message((String)"clone.stop.message.description", (Object[])new Object[]{sourceRepositoryURL}));
            }

            @NotNull
            public CloneableProjectsService.CloneStatus run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(false);
                GitLineHandlerListener progressListener = GitStandardProgressAnalyzer.createListener(indicator);
                GitCommandResult result2 = git.clone(project, new File(parentDirectory), sourceRepositoryURL, directoryName, progressListener);
                if (result2.success()) {
                    File directory = new File(parentDirectory, directoryName);
                    LOG.debug(String.format("Cloned into %s with success=%s", directory, result2));
                    ApplicationManager.getApplication().invokeLater(() -> DvcsUtil.addMappingIfSubRoot((Project)project, (String)directory.getPath(), (String)"Git"));
                    destinationParent.refresh(true, true);
                    listener.directoryCheckedOut(directory, GitVcs.getKey());
                    listener.checkoutCompleted();
                    CloneableProjectsService.CloneStatus cloneStatus = CloneableProjectsService.CloneStatus.SUCCESS;
                    if (cloneStatus == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return cloneStatus;
                }
                GitCheckoutProvider.notifyError(project, result2, sourceRepositoryURL);
                CloneableProjectsService.CloneStatus cloneStatus = CloneableProjectsService.CloneStatus.FAILURE;
                if (cloneStatus == null) {
                    1.$$$reportNull$$$0(2);
                }
                return cloneStatus;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "git4idea/checkout/GitCheckoutProvider$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "git4idea/checkout/GitCheckoutProvider$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "run";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "run";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        CloneableProjectsService.getInstance().runCloneTask(projectPath, cloneTask);
    }

    public static boolean doClone(@NotNull Project project, @NotNull Git git, @NotNull String directoryName, @NotNull String parentDirectory, @NotNull String sourceRepositoryURL) {
        if (project == null) {
            GitCheckoutProvider.$$$reportNull$$$0(3);
        }
        if (git == null) {
            GitCheckoutProvider.$$$reportNull$$$0(4);
        }
        if (directoryName == null) {
            GitCheckoutProvider.$$$reportNull$$$0(5);
        }
        if (parentDirectory == null) {
            GitCheckoutProvider.$$$reportNull$$$0(6);
        }
        if (sourceRepositoryURL == null) {
            GitCheckoutProvider.$$$reportNull$$$0(7);
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        indicator.setIndeterminate(false);
        GitLineHandlerListener progressListener = GitStandardProgressAnalyzer.createListener(indicator);
        GitCommandResult result2 = git.clone(project, new File(parentDirectory), sourceRepositoryURL, directoryName, progressListener);
        if (result2.success()) {
            return true;
        }
        GitCheckoutProvider.notifyError(project, result2, sourceRepositoryURL);
        return false;
    }

    private static void notifyError(@NotNull Project project, @NotNull GitCommandResult commandResult, @NotNull String sourceRepositoryURL) {
        String description2;
        List errorLines;
        if (project == null) {
            GitCheckoutProvider.$$$reportNull$$$0(8);
        }
        if (commandResult == null) {
            GitCheckoutProvider.$$$reportNull$$$0(9);
        }
        if (sourceRepositoryURL == null) {
            GitCheckoutProvider.$$$reportNull$$$0(10);
        }
        if ((errorLines = ContainerUtil.filter(commandResult.getErrorOutput(), line -> !ContainerUtil.exists(NON_ERROR_LINE_PREFIXES, prefix -> StringUtil.startsWithIgnoreCase((String)line, (String)prefix)))).isEmpty()) {
            description2 = DvcsBundle.message((String)"error.description.cloning.repository.failed", (Object[])new Object[]{sourceRepositoryURL});
        } else {
            List displayErrorLines = ContainerUtil.map((Collection)errorLines, msg -> HtmlChunk.text((String)GitUtil.cleanupErrorPrefixes(msg)));
            description2 = new HtmlBuilder().appendWithSeparators((HtmlChunk)HtmlChunk.br(), (Iterable)displayErrorLines).toString();
        }
        VcsNotifier.getInstance((Project)project).notifyError("git.clone.failed", DvcsBundle.message((String)"error.title.cloning.repository.failed", (Object[])new Object[0]), description2, true);
    }

    @NotNull
    public String getVcsId() {
        return "git";
    }

    public void doCheckout(@NotNull Project project, @Nullable CheckoutProvider.Listener listener) {
        if (project == null) {
            GitCheckoutProvider.$$$reportNull$$$0(11);
        }
        this.doCheckout(project, listener, null);
    }

    @NotNull
    public VcsCloneComponent buildVcsCloneComponent(@NotNull Project project, @NotNull ModalityState modalityState, @NotNull VcsCloneDialogComponentStateListener dialogStateListener) {
        if (project == null) {
            GitCheckoutProvider.$$$reportNull$$$0(12);
        }
        if (modalityState == null) {
            GitCheckoutProvider.$$$reportNull$$$0(13);
        }
        if (dialogStateListener == null) {
            GitCheckoutProvider.$$$reportNull$$$0(14);
        }
        return new GitCloneDialogComponent(project, modalityState, dialogStateListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDirectory";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRepositoryURL";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandResult";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialogStateListener";
                break;
            }
        }
        objectArray2[1] = "git4idea/checkout/GitCheckoutProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doCheckout";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "clone";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "doClone";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyError";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVcsCloneComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

