/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.execution;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;

public final class ParametersListUtil {
    public static final Function<String, List<String>> DEFAULT_LINE_PARSER = text -> ParametersListUtil.parse(text, true);
    public static final Function<List<String>, String> DEFAULT_LINE_JOINER = strings2 -> StringUtil.join(strings2, " ");
    public static final Function<String, List<String>> COLON_LINE_PARSER = text -> {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer((String)text, ";", false);
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    };
    public static final Function<List<String>, String> COLON_LINE_JOINER = strings2 -> StringUtil.join(strings2, ";");

    @NotNull
    public static String join(@NotNull List<? extends CharSequence> parameters) {
        if (parameters == null) {
            ParametersListUtil.$$$reportNull$$$0(0);
        }
        return ParametersListUtil.join(parameters, ParametersListUtil::escape);
    }

    @NotNull
    public static <T extends CharSequence> String join(@NotNull List<? extends T> parameters, @NotNull Function<? super T, ? extends CharSequence> escapeFunction) {
        if (parameters == null) {
            ParametersListUtil.$$$reportNull$$$0(1);
        }
        if (escapeFunction == null) {
            ParametersListUtil.$$$reportNull$$$0(2);
        }
        String string2 = StringUtil.join(parameters, escapeFunction, " ");
        if (string2 == null) {
            ParametersListUtil.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @NotNull
    public static String join(String ... parameters) {
        return ParametersListUtil.join(Arrays.asList(parameters));
    }

    public static String @NotNull [] parseToArray(@NotNull String string2) {
        if (string2 == null) {
            ParametersListUtil.$$$reportNull$$$0(4);
        }
        List<String> params = ParametersListUtil.parse(string2);
        String[] stringArray = ArrayUtilRt.toStringArray(params);
        if (stringArray == null) {
            ParametersListUtil.$$$reportNull$$$0(5);
        }
        return stringArray;
    }

    @NotNull
    public static List<String> parse(@NotNull String parameterString) {
        if (parameterString == null) {
            ParametersListUtil.$$$reportNull$$$0(6);
        }
        return ParametersListUtil.parse(parameterString, false);
    }

    @NotNull
    public static List<String> parse(@NotNull String parameterString, boolean keepQuotes) {
        if (parameterString == null) {
            ParametersListUtil.$$$reportNull$$$0(7);
        }
        return ParametersListUtil.parse(parameterString, keepQuotes, false);
    }

    @NotNull
    public static List<String> parse(@NotNull String parameterString, boolean keepQuotes, boolean supportSingleQuotes) {
        if (parameterString == null) {
            ParametersListUtil.$$$reportNull$$$0(8);
        }
        return ParametersListUtil.parse(parameterString, keepQuotes, supportSingleQuotes, false);
    }

    @NotNull
    public static List<String> parse(@NotNull String parameterString, boolean keepQuotes, boolean supportSingleQuotes, boolean keepEmptyParameters) {
        if (parameterString == null) {
            ParametersListUtil.$$$reportNull$$$0(9);
        }
        if (!keepEmptyParameters) {
            parameterString = parameterString.trim();
        }
        ArrayList<String> params = new ArrayList<String>();
        if (parameterString.isEmpty()) {
            ArrayList<String> arrayList = params;
            if (arrayList == null) {
                ParametersListUtil.$$$reportNull$$$0(10);
            }
            return arrayList;
        }
        StringBuilder token = new StringBuilder(128);
        boolean inQuotes = false;
        boolean escapedQuote = false;
        IntOpenHashSet possibleQuoteChars = new IntOpenHashSet();
        possibleQuoteChars.add(34);
        if (supportSingleQuotes) {
            possibleQuoteChars.add(39);
        }
        char currentQuote = '\u0000';
        boolean nonEmpty = false;
        for (int i = 0; i < parameterString.length(); ++i) {
            char ch = parameterString.charAt(i);
            if (inQuotes ? currentQuote == ch : possibleQuoteChars.contains((int)ch)) {
                if (!escapedQuote) {
                    inQuotes = !inQuotes;
                    currentQuote = ch;
                    nonEmpty = true;
                    if (!keepQuotes) continue;
                }
                escapedQuote = false;
            } else if (Character.isWhitespace(ch)) {
                if (!inQuotes) {
                    if (!keepEmptyParameters && token.length() <= 0 && !nonEmpty) continue;
                    params.add(token.toString());
                    token.setLength(0);
                    nonEmpty = false;
                    continue;
                }
            } else if (ch == '\\' && i < parameterString.length() - 1) {
                char nextchar = parameterString.charAt(i + 1);
                if (inQuotes ? currentQuote == nextchar : possibleQuoteChars.contains((int)nextchar)) {
                    escapedQuote = true;
                    if (!keepQuotes) continue;
                }
            }
            token.append(ch);
        }
        if (keepEmptyParameters || token.length() > 0 || nonEmpty) {
            params.add(token.toString());
        }
        ArrayList<String> arrayList = params;
        if (arrayList == null) {
            ParametersListUtil.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    public static String escape(@NotNull CharSequence argument) {
        if (argument == null) {
            ParametersListUtil.$$$reportNull$$$0(12);
        }
        StringBuilder builder = new StringBuilder(argument);
        StringUtil.escapeQuotes(builder);
        if (builder.length() == 0 || StringUtil.containsWhitespaces(builder) || StringUtil.indexOf((CharSequence)builder, '|') >= 0) {
            int numTrailingBackslashes = builder.length() - StringUtil.trimTrailing(builder, '\\').length();
            StringUtil.quote(builder);
            StringUtil.repeatSymbol(builder, '\\', numTrailingBackslashes);
        }
        String string2 = builder.toString();
        if (string2 == null) {
            ParametersListUtil.$$$reportNull$$$0(13);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 13: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escapeFunction";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/execution/ParametersListUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterString";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/execution/ParametersListUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseToArray";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "escape";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseToArray";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "escape";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

