/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.io.FilePageCache;
import com.intellij.util.io.stats.FilePageCacheStatistics;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class StorageLockContext {
    private static final FilePageCache ourDefaultCache = new FilePageCache();
    @NotNull
    private final ReentrantReadWriteLock myLock;
    @NotNull
    private final FilePageCache myFilePageCache;
    private final boolean myUseReadWriteLock;
    private final boolean myCacheChannels;

    private StorageLockContext(@NotNull FilePageCache filePageCache, boolean useReadWriteLock, boolean cacheChannels) {
        if (filePageCache == null) {
            StorageLockContext.$$$reportNull$$$0(0);
        }
        this.myLock = new ReentrantReadWriteLock();
        this.myFilePageCache = filePageCache;
        this.myUseReadWriteLock = useReadWriteLock;
        this.myCacheChannels = cacheChannels;
    }

    public StorageLockContext(boolean useReadWriteLock, boolean cacheChannels) {
        this(ourDefaultCache, useReadWriteLock, cacheChannels);
    }

    public StorageLockContext(boolean useReadWriteLock) {
        this(ourDefaultCache, useReadWriteLock, false);
    }

    public StorageLockContext() {
        this(ourDefaultCache, false, false);
    }

    boolean useChannelCache() {
        return this.myCacheChannels;
    }

    public Lock readLock() {
        return this.myUseReadWriteLock ? this.myLock.readLock() : this.myLock.writeLock();
    }

    public Lock writeLock() {
        return this.myLock.writeLock();
    }

    public void lockRead() {
        if (this.myUseReadWriteLock) {
            this.myLock.readLock().lock();
        } else {
            this.myLock.writeLock().lock();
        }
    }

    public void unlockRead() {
        if (this.myUseReadWriteLock) {
            this.myLock.readLock().unlock();
        } else {
            this.myLock.writeLock().unlock();
        }
    }

    public void lockWrite() {
        this.myLock.writeLock().lock();
    }

    public void unlockWrite() {
        this.myLock.writeLock().unlock();
    }

    @ApiStatus.Internal
    @NotNull
    FilePageCache getBufferCache() {
        FilePageCache filePageCache = this.myFilePageCache;
        if (filePageCache == null) {
            StorageLockContext.$$$reportNull$$$0(1);
        }
        return filePageCache;
    }

    @ApiStatus.Internal
    public void checkWriteAccess() {
        if (IndexDebugProperties.DEBUG) {
            if (this.myLock.writeLock().isHeldByCurrentThread()) {
                return;
            }
            throw new IllegalStateException("Must hold StorageLock write lock to access PagedFileStorage");
        }
    }

    @ApiStatus.Internal
    public void checkReadAccess() {
        if (IndexDebugProperties.DEBUG) {
            if (this.myLock.getReadHoldCount() > 0 || this.myLock.writeLock().isHeldByCurrentThread()) {
                return;
            }
            throw new IllegalStateException("Must hold StorageLock read lock to access PagedFileStorage");
        }
    }

    void assertUnderSegmentAllocationLock() {
        if (IndexDebugProperties.DEBUG) {
            this.myFilePageCache.assertUnderSegmentAllocationLock();
        }
    }

    @ApiStatus.Internal
    public static void forceDirectMemoryCache() {
        ourDefaultCache.flushBuffers();
    }

    @ApiStatus.Internal
    @NotNull
    public static FilePageCacheStatistics getStatistics() {
        FilePageCacheStatistics filePageCacheStatistics = ourDefaultCache.getStatistics();
        if (filePageCacheStatistics == null) {
            StorageLockContext.$$$reportNull$$$0(2);
        }
        return filePageCacheStatistics;
    }

    @ApiStatus.Internal
    public static void assertNoBuffersLocked() {
        ourDefaultCache.assertNoBuffersLocked();
    }

    @ApiStatus.Internal
    public static long getCacheMaxSize() {
        return ourDefaultCache.getMaxSize();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePageCache";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/StorageLockContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/StorageLockContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatistics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

