/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.core.CoreBundle;
import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginLoadingError;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PlatformUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class PluginLoadingResult {
    private final Map<PluginId, Set<String>> brokenPluginVersions;
    @NotNull
    final Supplier<BuildNumber> productBuildNumber;
    final Map<PluginId, IdeaPluginDescriptorImpl> incompletePlugins;
    private final Map<PluginId, IdeaPluginDescriptorImpl> plugins;
    final Map<PluginId, IdeaPluginDescriptorImpl> idMap;
    private final Map<PluginId, PluginLoadingError> pluginErrors;
    private final List<Supplier<String>> globalErrors;
    private final Set<PluginId> shadowedBundledIds;
    private final boolean checkModuleDependencies;

    PluginLoadingResult(@NotNull Map<PluginId, Set<String>> brokenPluginVersions, @NotNull Supplier<BuildNumber> productBuildNumber) {
        if (brokenPluginVersions == null) {
            PluginLoadingResult.$$$reportNull$$$0(1);
        }
        if (productBuildNumber == null) {
            PluginLoadingResult.$$$reportNull$$$0(2);
        }
        this(brokenPluginVersions, productBuildNumber, !PlatformUtils.isIntelliJ());
    }

    PluginLoadingResult(@NotNull Map<PluginId, Set<String>> brokenPluginVersions, @NotNull Supplier<BuildNumber> productBuildNumber, boolean checkModuleDependencies) {
        if (brokenPluginVersions == null) {
            PluginLoadingResult.$$$reportNull$$$0(3);
        }
        if (productBuildNumber == null) {
            PluginLoadingResult.$$$reportNull$$$0(4);
        }
        this.incompletePlugins = new ConcurrentHashMap<PluginId, IdeaPluginDescriptorImpl>();
        this.plugins = new HashMap<PluginId, IdeaPluginDescriptorImpl>();
        this.idMap = new ConcurrentHashMap<PluginId, IdeaPluginDescriptorImpl>();
        this.pluginErrors = new ConcurrentHashMap<PluginId, PluginLoadingError>();
        this.globalErrors = Collections.synchronizedList(new ArrayList());
        this.shadowedBundledIds = new HashSet<PluginId>();
        this.brokenPluginVersions = brokenPluginVersions;
        this.productBuildNumber = productBuildNumber;
        this.checkModuleDependencies = checkModuleDependencies;
    }

    boolean isBroken(@NotNull PluginId id) {
        Set<String> set;
        if (id == null) {
            PluginLoadingResult.$$$reportNull$$$0(5);
        }
        if ((set = this.brokenPluginVersions.get(id)) == null) {
            return false;
        }
        IdeaPluginDescriptorImpl descriptor2 = this.idMap.get(id);
        return descriptor2 != null && set.contains(descriptor2.getVersion());
    }

    void addIncompletePlugin(@NotNull IdeaPluginDescriptorImpl plugin, @Nullable PluginLoadingError error) {
        if (plugin == null) {
            PluginLoadingResult.$$$reportNull$$$0(7);
        }
        if (!this.idMap.containsKey(plugin.getPluginId())) {
            this.incompletePlugins.put(plugin.getPluginId(), plugin);
        }
        if (error != null) {
            this.pluginErrors.put(plugin.getPluginId(), error);
        }
    }

    void reportIncompatiblePlugin(@NotNull IdeaPluginDescriptorImpl plugin, @NotNull PluginLoadingError error) {
        if (plugin == null) {
            PluginLoadingResult.$$$reportNull$$$0(8);
        }
        if (error == null) {
            PluginLoadingResult.$$$reportNull$$$0(9);
        }
        if (this.idMap.containsKey(plugin.getPluginId())) {
            return;
        }
        error.register(this.pluginErrors);
    }

    void reportCannotLoad(@NotNull Path file2, Exception e) {
        if (file2 == null) {
            PluginLoadingResult.$$$reportNull$$$0(10);
        }
        DescriptorListLoadingContext.LOG.warn("Cannot load " + file2, e);
        this.globalErrors.add(CoreBundle.messagePointer("plugin.loading.error.text.file.contains.invalid.plugin.descriptor", FileUtil.getLocationRelativeToUserHome(file2.toString(), false)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginLoadingResult";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "brokenPluginVersions";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "productBuildNumber";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledPlugins";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginLoadingResult";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginErrors";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isBroken";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addIncompletePlugin";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "reportIncompatiblePlugin";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reportCannotLoad";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkAndAdd";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

