/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.codegen.BooleanValue;
import org.jetbrains.kotlin.backend.jvm.codegen.MaterialValue;
import org.jetbrains.kotlin.codegen.BranchedValue;
import org.jetbrains.kotlin.codegen.NumberCompare;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/NonIEEE754FloatComparison;", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BooleanValue;", "op", "Lcom/intellij/psi/tree/IElementType;", "a", "Lorg/jetbrains/kotlin/backend/jvm/codegen/MaterialValue;", "b", "(Lcom/intellij/psi/tree/IElementType;Lorg/jetbrains/kotlin/backend/jvm/codegen/MaterialValue;Lorg/jetbrains/kotlin/backend/jvm/codegen/MaterialValue;)V", "getA", "()Lorg/jetbrains/kotlin/backend/jvm/codegen/MaterialValue;", "getB", "numberCompareOpcode", "", "getOp", "()Lcom/intellij/psi/tree/IElementType;", "discard", "", "invokeStaticComparison", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "jumpIfFalse", "target", "Lorg/jetbrains/org/objectweb/asm/Label;", "jumpIfTrue", "backend.jvm.codegen"})
public final class NonIEEE754FloatComparison
extends BooleanValue {
    @NotNull
    private final IElementType op;
    @NotNull
    private final MaterialValue a;
    @NotNull
    private final MaterialValue b;
    private final int numberCompareOpcode;

    public NonIEEE754FloatComparison(@NotNull IElementType op, @NotNull MaterialValue a, @NotNull MaterialValue b) {
        Intrinsics.checkNotNullParameter(op, "op");
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        super(a.getCodegen());
        this.op = op;
        this.a = a;
        this.b = b;
        this.numberCompareOpcode = NumberCompare.Companion.getNumberCompareOpcode(this.op);
    }

    @NotNull
    public final IElementType getOp() {
        return this.op;
    }

    @NotNull
    public final MaterialValue getA() {
        return this.a;
    }

    @NotNull
    public final MaterialValue getB() {
        return this.b;
    }

    private final void invokeStaticComparison(Type type2) {
        Type type3 = type2;
        if (Intrinsics.areEqual(type3, Type.FLOAT_TYPE)) {
            this.getMv().invokestatic("java/lang/Float", "compare", "(FF)I", false);
        } else if (Intrinsics.areEqual(type3, Type.DOUBLE_TYPE)) {
            this.getMv().invokestatic("java/lang/Double", "compare", "(DD)I", false);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void jumpIfFalse(@NotNull Label target) {
        Intrinsics.checkNotNullParameter(target, "target");
        this.invokeStaticComparison(this.a.getType());
        this.getMv().visitJumpInsn(this.numberCompareOpcode, target);
    }

    @Override
    public void jumpIfTrue(@NotNull Label target) {
        Intrinsics.checkNotNullParameter(target, "target");
        this.invokeStaticComparison(this.a.getType());
        InstructionAdapter instructionAdapter = this.getMv();
        Integer n = BranchedValue.Companion.getNegatedOperations().get(this.numberCompareOpcode);
        Intrinsics.checkNotNull(n);
        instructionAdapter.visitJumpInsn(((Number)n).intValue(), target);
    }

    @Override
    public void discard() {
        this.b.discard();
        this.a.discard();
    }
}

