/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.configurationStore.ExportSettingsActionKt;
import com.intellij.configurationStore.LocalExportableItem;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StateStorageManagerImplKt;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.util.SmartList;
import com.intellij.util.io.PathKt;
import com.intellij.util.lang.CompoundRuntimeException;
import java.io.Closeable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsManager;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u001a,\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000eR\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"copyLocalConfig", "", "storageManager", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "normalizeFileSpec", "", "absolutePath", "saveDirectory", "parent", "Ljava/nio/file/Path;", "parentFileSpec", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "streamProvider", "Lorg/jetbrains/settingsRepository/IcsManager$IcsStreamProvider;", "Lorg/jetbrains/settingsRepository/IcsManager;", "intellij.settingsRepository"})
public final class CopyAppSettingsToRepositoryKt {
    public static final void copyLocalConfig(@NotNull StateStorageManagerImpl storageManager) {
        Iterator iterator;
        Object element$iv2;
        block10: {
            Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
            Iterable $this$first$iv = (Iterable)storageManager.getCompoundStreamProvider().getProviders();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                StreamProvider it = (StreamProvider)element$iv2;
                boolean bl = false;
                if (!(it instanceof IcsManager.IcsStreamProvider)) continue;
                break block10;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object t = element$iv2;
        if (t == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.settingsRepository.IcsManager.IcsStreamProvider");
        }
        IcsManager.IcsStreamProvider streamProvider = (IcsManager.IcsStreamProvider)t;
        Map fileToItems = ExportSettingsActionKt.getExportableItemsFromLocalStorage((Map)ExportSettingsActionKt.getExportableComponentsMap$default((boolean)false, null, (boolean)false, (int)6, null), (StateStorageManager)((StateStorageManager)storageManager));
        Collection $this$forEachGuaranteed$iv = fileToItems.keySet();
        boolean $i$f$forEachGuaranteed = false;
        Iterator $this$forEachGuaranteed$iv$iv = $this$forEachGuaranteed$iv.iterator();
        boolean $i$f$forEachGuaranteed2 = false;
        List errors$iv$iv = null;
        Iterator iterator2 = iterator = $this$forEachGuaranteed$iv$iv;
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            try {
                List roamingType;
                List list;
                String fileSpec;
                Path file;
                block11: {
                    file = (Path)element$iv$iv;
                    boolean bl = false;
                    fileSpec = null;
                    try {
                        Path path = file.toAbsolutePath();
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file.toAbsolutePath()");
                        String absolutePath = PathKt.getSystemIndependentPath((Path)path);
                        fileSpec = CopyAppSettingsToRepositoryKt.normalizeFileSpec(storageManager, absolutePath);
                        if (!Intrinsics.areEqual((Object)fileSpec, (Object)absolutePath)) break block11;
                        Path path2 = file.toRealPath(new LinkOption[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"file.toRealPath()");
                        String canonicalPath = PathKt.getSystemIndependentPath((Path)path2);
                        if (!(Intrinsics.areEqual((Object)canonicalPath, (Object)absolutePath) ^ true)) break block11;
                        fileSpec = CopyAppSettingsToRepositoryKt.normalizeFileSpec(storageManager, absolutePath);
                    }
                    catch (NoSuchFileException e) {
                        continue;
                    }
                }
                if ((list = (List)fileToItems.get(file)) == null || (list = (LocalExportableItem)CollectionsKt.firstOrNull((List)list)) == null || (list = list.getRoamingType()) == null) {
                    list = roamingType = RoamingType.DEFAULT;
                }
                if (PathKt.isFile((Path)file)) {
                    byte[] fileBytes = PathKt.readBytes((Path)file);
                    streamProvider.doSave(fileSpec, fileBytes, fileBytes.length, (RoamingType)roamingType);
                    continue;
                }
                CopyAppSettingsToRepositoryKt.saveDirectory(file, fileSpec, (RoamingType)roamingType, streamProvider);
            }
            catch (Throwable e$iv$iv) {
                if (errors$iv$iv == null) {
                    errors$iv$iv = (List)new SmartList();
                }
                errors$iv$iv.add(e$iv$iv);
            }
        }
        CompoundRuntimeException.throwIfNotEmpty((List)errors$iv$iv);
    }

    public static /* synthetic */ void copyLocalConfig$default(StateStorageManagerImpl stateStorageManagerImpl, int n, Object object) {
        if ((n & 1) != 0) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNull((Object)application);
            StateStorageManager stateStorageManager = ServiceKt.getStateStore((ComponentManager)((ComponentManager)application)).getStorageManager();
            if (stateStorageManager == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.configurationStore.StateStorageManagerImpl");
            }
            stateStorageManagerImpl = (StateStorageManagerImpl)stateStorageManager;
        }
        CopyAppSettingsToRepositoryKt.copyLocalConfig(stateStorageManagerImpl);
    }

    private static final String normalizeFileSpec(StateStorageManagerImpl storageManager, String absolutePath) {
        return StateStorageManagerImplKt.removeMacroIfStartsWith((String)StateStorageManagerImplKt.removeMacroIfStartsWith((String)storageManager.collapseMacro(absolutePath), (String)"$ROOT_CONFIG$"), (String)"$APP_CONFIG$");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void saveDirectory(Path parent, String parentFileSpec, RoamingType roamingType, IcsManager.IcsStreamProvider streamProvider) {
        Path $this$directoryStreamIfExists$iv = parent;
        boolean $i$f$directoryStreamIfExists = false;
        try {
            Closeable closeable = Files.newDirectoryStream($this$directoryStreamIfExists$iv);
            Throwable throwable = null;
            try {
                DirectoryStream it = (DirectoryStream)closeable;
                boolean bl = false;
                Iterator iterator = it.iterator();
                while (iterator.hasNext()) {
                    Path file;
                    Path path = file = (Path)iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file");
                    String childFileSpec = parentFileSpec + "/" + path.getFileName();
                    if (PathKt.isFile((Path)file)) {
                        byte[] fileBytes = Files.readAllBytes(file);
                        Intrinsics.checkNotNullExpressionValue((Object)fileBytes, (String)"fileBytes");
                        streamProvider.doSave(childFileSpec, fileBytes, fileBytes.length, roamingType);
                        continue;
                    }
                    CopyAppSettingsToRepositoryKt.saveDirectory(file, childFileSpec, roamingType, streamProvider);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
        }
    }
}

