/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.associations.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.IconUtil;
import org.intellij.lang.xpath.xslt.associations.FileAssociationsManager;
import org.intellij.lang.xpath.xslt.associations.impl.AnyXMLDescriptor;
import org.intellij.lang.xpath.xslt.associations.impl.AssociationsGroup;
import org.intellij.plugins.xpathView.XPathBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AddAssociationAction
extends AnAction {
    private final FileAssociationsManager myManager;

    AddAssociationAction(FileAssociationsManager manager) {
        super(XPathBundle.message("action.add.association.text", new Object[0]), XPathBundle.message("action.add.file.association.description", new Object[0]), IconUtil.getAddIcon());
        this.myManager = manager;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AddAssociationAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiFile psiFile;
        if (e == null) {
            AddAssociationAction.$$$reportNull$$$0(1);
        }
        if ((psiFile = AssociationsGroup.getPsiFile(e)) == null) {
            return;
        }
        this.addAssociation(psiFile);
        DaemonCodeAnalyzer.getInstance((Project)psiFile.getProject()).restart(psiFile);
    }

    protected void addAssociation(PsiFile psiFile) {
        final VirtualFile virtualFile = psiFile.getVirtualFile();
        assert (virtualFile != null);
        AnyXMLDescriptor descriptor = new AnyXMLDescriptor(true){

            public boolean isFileSelectable(@Nullable VirtualFile file) {
                return super.isFileSelectable(file) && !file.equals(virtualFile);
            }
        };
        VirtualFile[] virtualFiles = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)psiFile.getProject(), (VirtualFile)psiFile.getVirtualFile());
        if (virtualFiles.length == 0) {
            return;
        }
        for (VirtualFile file : virtualFiles) {
            assert (!virtualFile.equals(file));
            this.myManager.addAssociation(psiFile, file);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/associations/impl/AddAssociationAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/associations/impl/AddAssociationAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

