/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.rt.engine.local.saxon9;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.TraceExpression;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.FloatValue;
import org.intellij.plugins.xsltDebugger.rt.engine.Debugger;
import org.intellij.plugins.xsltDebugger.rt.engine.Value;
import org.intellij.plugins.xsltDebugger.rt.engine.local.VariableComparator;
import org.intellij.plugins.xsltDebugger.rt.engine.local.VariableImpl;
import org.intellij.plugins.xsltDebugger.rt.engine.local.saxon9.AbstractSaxon9Frame;
import org.intellij.plugins.xsltDebugger.rt.engine.local.saxon9.Saxon9TraceListener;

class Saxon9StyleFrame
extends AbstractSaxon9Frame<Debugger.StyleFrame, TraceExpression>
implements Debugger.StyleFrame {
    private final XPathContext myXPathContext;

    protected Saxon9StyleFrame(Debugger.StyleFrame prev, TraceExpression element, XPathContext xPathContext) {
        super(prev, element);
        this.myXPathContext = xPathContext;
    }

    public String getInstruction() {
        return ((TraceExpression)this.myElement).getExpressionName();
    }

    public Value eval(String expr) throws Debugger.EvaluationException {
        assert (this.isValid());
        Saxon9TraceListener.MUTED = true;
        try {
            Value value = this.createValue(new ExpressionFacade((Expression)this.myElement));
            return value;
        }
        catch (AssertionError | Exception e) {
            Saxon9StyleFrame.debug((Throwable)e);
            throw new Debugger.EvaluationException(((Throwable)e).getMessage() != null ? ((Throwable)e).getMessage() : ((Throwable)e).toString());
        }
        finally {
            Saxon9TraceListener.MUTED = false;
        }
    }

    private Value createValue(ValueFacade expression) throws XPathException {
        TypeHierarchy typeHierarchy = this.myXPathContext.getConfiguration().getTypeHierarchy();
        ItemType itemType = expression.getItemType(typeHierarchy);
        SequenceIterator it = expression.iterate(this.myXPathContext);
        GroundedValue value = null;
        if (it.next() != null) {
            value = it.materialize();
        }
        if (it.next() == null) {
            return new SingleValue(value, itemType);
        }
        return new SequenceValue(value, it, itemType);
    }

    public List<Debugger.Variable> getVariables() {
        ArrayList<Debugger.Variable> variables;
        assert (this.isValid());
        Saxon9TraceListener.MUTED = true;
        try {
            variables = this.collectVariables();
        }
        finally {
            Saxon9TraceListener.MUTED = false;
        }
        variables.sort(VariableComparator.INSTANCE);
        return variables;
    }

    private ArrayList<Debugger.Variable> collectVariables() {
        ArrayList<Debugger.Variable> variables = new ArrayList<Debugger.Variable>();
        Iterable packages = this.myXPathContext.getController().getExecutable().getPackages();
        for (PackageData data : packages) {
            List globalVariables = data.getGlobalVariableList();
            for (GlobalVariable globalVariable : globalVariables) {
                Value value = this.createVariableValue(new GlobalVariableFacade(globalVariable));
                int lineNumber = globalVariable.getLineNumber();
                String systemId = globalVariable.getSystemId();
                variables.add(new VariableImpl(globalVariable.getVariableQName().getDisplayName(), value, true, Debugger.Variable.Kind.VARIABLE, systemId, lineNumber));
            }
        }
        for (XPathContext context = this.myXPathContext; context != null; context = context.getCaller()) {
            StackFrame frame = context.getStackFrame();
            SlotManager map = frame.getStackFrameMap();
            Sequence[] values = frame.getStackFrameValues();
            int valuesLength = values.length;
            block5: for (int i = 0; i < valuesLength; ++i) {
                GroundedValue groundedValue;
                Sequence value = values[i];
                if (value == null) continue;
                String name = ((StructuredQName)map.getVariableMap().get(i)).getDisplayName();
                for (Debugger.Variable variable : variables) {
                    if (!name.equals(variable.getName())) continue;
                    continue block5;
                }
                try {
                    groundedValue = value.materialize();
                }
                catch (XPathException e) {
                    continue;
                }
                Value localValue = this.createVariableValue(new LocalVariableFacade(groundedValue));
                variables.add(new VariableImpl(name, localValue, false, Debugger.Variable.Kind.VARIABLE, "", -1));
            }
        }
        return variables;
    }

    private Value createVariableValue(ValueFacade facade) {
        try {
            return this.createValue(facade);
        }
        catch (XPathException e) {
            return new ErrorValue(e.getMessage(), facade);
        }
    }

    private class ErrorValue
    implements Value {
        private final String myError;
        private final ValueFacade myFacade;

        ErrorValue(String error, ValueFacade facade) {
            this.myError = error;
            this.myFacade = facade;
        }

        public Object getValue() {
            return " - error: " + this.myError + " - ";
        }

        public Value.Type getType() {
            return new Value.ObjectType(this.myFacade.getItemType(Saxon9StyleFrame.this.myXPathContext.getConfiguration().getTypeHierarchy()).toString());
        }
    }

    private static class LocalVariableFacade
    implements ValueFacade {
        private final GroundedValue myValue;

        LocalVariableFacade(GroundedValue value) {
            this.myValue = value;
        }

        @Override
        public ItemType getItemType(TypeHierarchy hierarchy) {
            if (this.myValue instanceof FloatValue) {
                return ((FloatValue)this.myValue).getItemType();
            }
            if (this.myValue instanceof Item) {
                return Type.getItemType((Item)((Item)this.myValue), (TypeHierarchy)hierarchy);
            }
            return AnyItemType.getInstance();
        }

        @Override
        public SequenceIterator iterate(XPathContext context) {
            return this.myValue.iterate();
        }
    }

    private static class GlobalVariableFacade
    implements ValueFacade {
        private final GlobalVariable myVariable;

        GlobalVariableFacade(GlobalVariable variable) {
            this.myVariable = variable;
        }

        @Override
        public ItemType getItemType(TypeHierarchy hierarchy) {
            return this.myVariable.getRequiredType().getPrimaryType();
        }

        @Override
        public SequenceIterator iterate(XPathContext context) throws XPathException {
            List bindings = context.getCurrentComponent().getComponentBindings();
            if (bindings.size() <= this.myVariable.getBinderySlotNumber()) {
                return EmptyIterator.emptyIterator();
            }
            GroundedValue groundedValue = this.myVariable.evaluateVariable(context);
            return groundedValue.iterate();
        }
    }

    private static class ExpressionFacade
    implements ValueFacade {
        private final Expression myExpression;

        ExpressionFacade(Expression expression) {
            this.myExpression = expression;
        }

        @Override
        public ItemType getItemType(TypeHierarchy hierarchy) {
            return this.myExpression.getItemType();
        }

        @Override
        public SequenceIterator iterate(XPathContext context) throws XPathException {
            return this.myExpression.iterate(context);
        }
    }

    private static interface ValueFacade {
        public ItemType getItemType(TypeHierarchy var1);

        public SequenceIterator iterate(XPathContext var1) throws XPathException;
    }

    private static class SequenceValue
    implements Value {
        private final String myValue;
        private final ItemType myItemType;

        SequenceValue(GroundedValue value, SequenceIterator it, ItemType type) throws XPathException {
            String s = "(" + value.getStringValue() + ", " + it.materialize().getStringValue();
            while (it.next() != null) {
                s = s + ", " + it.materialize().getStringValue();
            }
            this.myValue = s = s + ")";
            this.myItemType = type;
        }

        public Object getValue() {
            return this.myValue;
        }

        public Value.Type getType() {
            return new Value.ObjectType(this.myItemType.toString() + "+");
        }
    }

    private static class SingleValue
    implements Value {
        private final GroundedValue myValue;
        private final ItemType myItemType;

        SingleValue(GroundedValue value, ItemType itemType) {
            this.myValue = value;
            this.myItemType = itemType;
        }

        public Object getValue() {
            try {
                return this.myValue != null ? this.myValue.getStringValue() : null;
            }
            catch (XPathException e) {
                return null;
            }
        }

        public Value.Type getType() {
            return new Value.ObjectType(this.myItemType.toString());
        }
    }
}

