/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.checker;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eJ\u001c\u0010\u000f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H&J\f\u0010\u0012\u001a\u00020\u0003*\u00020\u0013H\u0004J\f\u0010\u0014\u001a\u00020\u0003*\u00020\u0013H\u0002J\n\u0010\u0015\u001a\u00020\u0003*\u00020\u0013J\f\u0010\u0016\u001a\u00020\u0003*\u00020\u0013H\u0002J\u0014\u0010\u0017\u001a\u00020\u0003*\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0004R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bj\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001c\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "", "mustCheckBody", "", "(Ljava/lang/String;IZ)V", "compileTimeTypeAliases", "", "", "getCompileTimeTypeAliases", "()Ljava/util/Set;", "getMustCheckBody", "()Z", "canEvaluateBody", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "canEvaluateFunction", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "isCompileTimeTypeAlias", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "isContract", "isMarkedAsCompileTime", "isMarkedAsEvaluateIntrinsic", "isMarkedWith", "annotation", "Lorg/jetbrains/kotlin/name/FqName;", "FULL", "WITH_ANNOTATIONS", "ONLY_BUILTINS", "ir.interpreter"})
public abstract class EvaluationMode
extends Enum<EvaluationMode> {
    private final boolean mustCheckBody;
    @NotNull
    private final Set<String> compileTimeTypeAliases;
    public static final /* enum */ EvaluationMode FULL = new FULL("FULL", 0);
    public static final /* enum */ EvaluationMode WITH_ANNOTATIONS = new WITH_ANNOTATIONS("WITH_ANNOTATIONS", 1);
    public static final /* enum */ EvaluationMode ONLY_BUILTINS = new ONLY_BUILTINS("ONLY_BUILTINS", 2);
    private static final /* synthetic */ EvaluationMode[] $VALUES;

    private EvaluationMode(boolean mustCheckBody) {
        this.mustCheckBody = mustCheckBody;
        Object[] objectArray = new String[]{"java.lang.StringBuilder", "java.lang.IllegalArgumentException", "java.util.NoSuchElementException"};
        this.compileTimeTypeAliases = SetsKt.setOf((Object[])objectArray);
    }

    protected final boolean getMustCheckBody() {
        return this.mustCheckBody;
    }

    public abstract boolean canEvaluateFunction(@NotNull IrFunction var1, @Nullable IrCall var2);

    public static /* synthetic */ boolean canEvaluateFunction$default(EvaluationMode evaluationMode, IrFunction irFunction, IrCall irCall, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: canEvaluateFunction");
        }
        if ((n & 2) != 0) {
            irCall = null;
        }
        return evaluationMode.canEvaluateFunction(irFunction, irCall);
    }

    public final boolean canEvaluateBody(@NotNull IrFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (function instanceof IrSimpleFunction && ((IrSimpleFunction)function).getCorrespondingPropertySymbol() != null) {
            return true;
        }
        return (this.mustCheckBody || AdditionalIrUtilsKt.isLocal(function)) && !this.isContract(function) && !this.isMarkedAsEvaluateIntrinsic(function);
    }

    @NotNull
    protected final Set<String> getCompileTimeTypeAliases() {
        return this.compileTimeTypeAliases;
    }

    public final boolean isMarkedAsCompileTime(@NotNull IrDeclaration $this$isMarkedAsCompileTime) {
        Intrinsics.checkNotNullParameter((Object)$this$isMarkedAsCompileTime, (String)"<this>");
        return this.isMarkedWith($this$isMarkedAsCompileTime, UtilsKt.getCompileTimeAnnotation());
    }

    private final boolean isContract(IrDeclaration $this$isContract) {
        return this.isMarkedWith($this$isContract, UtilsKt.getContractsDslAnnotation());
    }

    private final boolean isMarkedAsEvaluateIntrinsic(IrDeclaration $this$isMarkedAsEvaluateIntrinsic) {
        return this.isMarkedWith($this$isMarkedAsEvaluateIntrinsic, UtilsKt.getEvaluateIntrinsicAnnotation());
    }

    protected final boolean isCompileTimeTypeAlias(@NotNull IrDeclaration $this$isCompileTimeTypeAlias) {
        Intrinsics.checkNotNullParameter((Object)$this$isCompileTimeTypeAlias, (String)"<this>");
        IrClass irClass = IrUtilsKt.getParentClassOrNull($this$isCompileTimeTypeAlias);
        return CollectionsKt.contains((Iterable)this.compileTimeTypeAliases, (Object)(irClass != null ? UtilsKt.getFqName(irClass) : null));
    }

    protected final boolean isMarkedWith(@NotNull IrDeclaration $this$isMarkedWith, @NotNull FqName annotation) {
        Intrinsics.checkNotNullParameter((Object)$this$isMarkedWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        if ($this$isMarkedWith instanceof IrClass && ((IrClass)$this$isMarkedWith).isCompanion()) {
            return false;
        }
        if (UtilsKt.hasAnnotation($this$isMarkedWith, annotation)) {
            return true;
        }
        IrDeclarationParent irDeclarationParent = $this$isMarkedWith.getParent();
        IrClass irClass = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
        return irClass != null ? this.isMarkedWith(irClass, annotation) : false;
    }

    public static EvaluationMode[] values() {
        return (EvaluationMode[])$VALUES.clone();
    }

    public static EvaluationMode valueOf(String value) {
        return Enum.valueOf(EvaluationMode.class, value);
    }

    public /* synthetic */ EvaluationMode(String $enum$name, int $enum$ordinal, boolean mustCheckBody, DefaultConstructorMarker $constructor_marker) {
        this(mustCheckBody);
    }

    static {
        $VALUES = evaluationModeArray = new EvaluationMode[]{EvaluationMode.FULL, EvaluationMode.WITH_ANNOTATIONS, EvaluationMode.ONLY_BUILTINS};
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode$FULL;", "Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "canEvaluateFunction", "", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "ir.interpreter"})
    static final class FULL
    extends EvaluationMode {
        /*
         * WARNING - void declaration
         */
        FULL() {
            void var1_1;
        }

        @Override
        public boolean canEvaluateFunction(@NotNull IrFunction function, @Nullable IrCall expression) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            return true;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u000e\u0010\b\u001a\u00020\u0003*\u0004\u0018\u00010\tH\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode$WITH_ANNOTATIONS;", "Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "canEvaluateFunction", "", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "isCompileTimeProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "ir.interpreter"})
    static final class WITH_ANNOTATIONS
    extends EvaluationMode {
        /*
         * WARNING - void declaration
         */
        WITH_ANNOTATIONS() {
            void var1_1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean canEvaluateFunction(@NotNull IrFunction function, @Nullable IrCall expression) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            if (this.isCompileTimeProperty(function)) {
                return true;
            }
            if (this.isMarkedAsCompileTime(function)) return true;
            if (Intrinsics.areEqual((Object)function.getOrigin(), (Object)IrBuiltIns.Companion.getBUILTIN_OPERATOR())) return true;
            if (function instanceof IrSimpleFunction && ((IrSimpleFunction)function).isOperator()) {
                if (Intrinsics.areEqual((Object)function.getName().asString(), (Object)"invoke")) return true;
            }
            if (function instanceof IrSimpleFunction && ((IrSimpleFunction)function).isFakeOverride()) {
                boolean bl;
                Iterable $this$any$iv = ((IrSimpleFunction)function).getOverriddenSymbols();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
                        boolean bl2 = false;
                        if (!EvaluationMode.canEvaluateFunction$default(this, it.getOwner(), null, 2, null)) continue;
                        return true;
                    }
                    bl = false;
                }
                if (bl) return true;
            }
            if (!this.isCompileTimeTypeAlias(function)) return false;
            return true;
        }

        private final boolean isCompileTimeProperty(IrDeclaration $this$isCompileTimeProperty) {
            IrGetValue backingFieldExpression;
            Object object = $this$isCompileTimeProperty instanceof IrSimpleFunction ? (IrSimpleFunction)$this$isCompileTimeProperty : null;
            if (object == null || (object = ((IrSimpleFunction)object).getCorrespondingPropertySymbol()) == null || (object = (IrProperty)object.getOwner()) == null) {
                return false;
            }
            Object property = object;
            if (((IrProperty)property).isConst()) {
                return true;
            }
            if (this.isMarkedAsCompileTime((IrDeclaration)property) || this.isCompileTimeTypeAlias((IrDeclaration)property)) {
                return true;
            }
            IrField backingField2 = ((IrProperty)property).getBackingField();
            IrElementBase irElementBase = backingField2;
            IrExpression irExpression = irElementBase != null && (irElementBase = ((IrField)irElementBase).getInitializer()) != null ? ((IrExpressionBody)irElementBase).getExpression() : null;
            IrGetValue irGetValue = backingFieldExpression = irExpression instanceof IrGetValue ? (IrGetValue)irExpression : null;
            return Intrinsics.areEqual((Object)(irGetValue != null ? irGetValue.getOrigin() : null), (Object)IrStatementOrigin.INITIALIZE_PROPERTY_FROM_PARAMETER.INSTANCE);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode$ONLY_BUILTINS;", "Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "allowedExtensionFunctions", "", "", "forbiddenMethodsOnPrimitives", "forbiddenMethodsOnStrings", "canEvaluateFunction", "", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "ir.interpreter"})
    static final class ONLY_BUILTINS
    extends EvaluationMode {
        @NotNull
        private final Set<String> forbiddenMethodsOnPrimitives;
        @NotNull
        private final Set<String> forbiddenMethodsOnStrings;
        @NotNull
        private final Set<String> allowedExtensionFunctions;

        /*
         * WARNING - void declaration
         */
        ONLY_BUILTINS() {
            void var1_1;
            Object[] objectArray = new String[]{"inc", "dec", "rangeTo", "hashCode"};
            this.forbiddenMethodsOnPrimitives = SetsKt.setOf((Object[])objectArray);
            objectArray = new String[]{"subSequence", "hashCode", "<init>"};
            this.forbiddenMethodsOnStrings = SetsKt.setOf((Object[])objectArray);
            objectArray = new String[]{"kotlin.floorDiv", "kotlin.mod", "kotlin.NumbersKt.floorDiv", "kotlin.NumbersKt.mod"};
            this.allowedExtensionFunctions = SetsKt.setOf((Object[])objectArray);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean canEvaluateFunction(@NotNull IrFunction function, @Nullable IrCall expression) {
            boolean bl;
            IrClass parent;
            boolean bl2;
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            Object object = function instanceof IrSimpleFunction ? (IrSimpleFunction)function : null;
            if (object != null && (object = ((IrSimpleFunction)object).getCorrespondingPropertySymbol()) != null && (object = (IrProperty)object.getOwner()) != null) {
                if (((IrProperty)object).isConst()) {
                    return true;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) {
                return true;
            }
            FqName fqName = IrUtilsKt.getFqNameWhenAvailable(function);
            String fqName2 = fqName != null ? fqName.asString() : null;
            IrClass irClass = parent = IrUtilsKt.getParentClassOrNull(function);
            IrSimpleType parentType = irClass != null ? IrUtilsKt.getDefaultType(irClass) : null;
            if (parentType == null) {
                bl = CollectionsKt.contains((Iterable)this.allowedExtensionFunctions, (Object)fqName2);
                return bl;
            } else {
                if (IrTypePredicatesKt.isPrimitiveType$default(parentType, false, 1, null)) {
                    if (this.forbiddenMethodsOnPrimitives.contains(function.getName().asString())) return false;
                    return true;
                }
                if (IrTypePredicatesKt.isString(parentType)) {
                    if (this.forbiddenMethodsOnStrings.contains(function.getName().asString())) return false;
                    return true;
                }
                if (IrTypePredicatesKt.isAny(parentType)) {
                    if (!Intrinsics.areEqual((Object)function.getName().asString(), (Object)"toString")) return false;
                    IrCall irCall = expression;
                    if ((irCall != null ? irCall.getDispatchReceiver() : null) instanceof IrGetObjectValue) return false;
                    return true;
                }
                if (IrUtilsKt.isObject(parent)) {
                    IrClass irClass2 = IrUtilsKt.getParentClassOrNull(parent);
                    IrAnnotationContainer irAnnotationContainer = irClass2;
                    if (irClass2 == null) return false;
                    IrSimpleType irSimpleType = IrUtilsKt.getDefaultType(irAnnotationContainer);
                    irAnnotationContainer = irSimpleType;
                    if (irSimpleType == null) return false;
                    IrAnnotationContainer irAnnotationContainer2 = irAnnotationContainer;
                    boolean bl3 = false;
                    if (IrTypePredicatesKt.isPrimitiveType$default((IrType)irAnnotationContainer2, false, 1, null)) return true;
                    if (!UtilsKt.isUnsigned((IrType)irAnnotationContainer2)) return false;
                    return true;
                }
                if (IrTypePredicatesKt.isUnsignedType$default(parentType, false, 1, null) && function instanceof IrConstructor) {
                    return true;
                }
                bl = CollectionsKt.contains((Iterable)this.allowedExtensionFunctions, (Object)fqName2);
            }
            return bl;
        }
    }
}

