/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ift;

import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.dvcs.repo.VcsRepositoryMappingListener;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import git4idea.actions.GitInit;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.ift.GitProjectUtil;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import training.project.FileUtils;
import training.project.ProjectUtils;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J \u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rH\u0002J\u0016\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\u0016\u001a\u00020\rH\u0002J\b\u0010\u0017\u001a\u00020\nH\u0002J\u0016\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lgit4idea/ift/GitProjectUtil;", "", "()V", "remoteProjectName", "", "addVcsMappingSynchronously", "", "project", "Lcom/intellij/openapi/project/Project;", "gitRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "checkout", "root", "Ljava/io/File;", "branch", "configureRemote", "remoteName", "remoteProjectRoot", "copyGitProject", "", "destination", "createRemoteProject", "reCreateRemoteProjectDir", "refreshAndGetProjectRoot", "restoreGitLessonsFiles", "intellij.vcs.git.featuresTrainer"})
public final class GitProjectUtil {
    private static final String remoteProjectName = "RemoteLearningProject";
    @NotNull
    public static final GitProjectUtil INSTANCE;

    public final void restoreGitLessonsFiles(@NotNull Project project, @NotNull String branch) {
        File root;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        VirtualFile learningProjectRoot = this.refreshAndGetProjectRoot();
        Object object = ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<VirtualFile>(project, learningProjectRoot){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $learningProjectRoot;

            @NotNull
            public final VirtualFile invoke() {
                boolean $i$f$runWriteAction = false;
                return (VirtualFile)ApplicationManager.getApplication().runWriteAction(new Computable(this){
                    final /* synthetic */ restoreGitLessonsFiles.gitProjectRoot.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final T compute() {
                        VirtualFile virtualFile;
                        block5: {
                            block4: {
                                VirtualFile virtualFile2;
                                boolean bl = false;
                                ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)this.this$0.$project);
                                Intrinsics.checkNotNullExpressionValue((Object)projectLevelVcsManager, (String)"ProjectLevelVcsManager.getInstance(project)");
                                projectLevelVcsManager.setDirectoryMappings((List)new ArrayList<E>());
                                virtualFile = this.this$0.$learningProjectRoot.findChild("git");
                                if (virtualFile == null) break block4;
                                VirtualFile $this$apply = virtualFile2 = virtualFile;
                                boolean bl2 = false;
                                VirtualFile virtualFile3 = $this$apply.findChild(".git");
                                if (virtualFile3 != null) {
                                    virtualFile3.delete((Object)$this$apply);
                                }
                                if ((virtualFile = virtualFile2) != null) break block5;
                            }
                            virtualFile = this.this$0.$learningProjectRoot.createChildDirectory((Object)GitProjectUtil.INSTANCE, "git");
                        }
                        return (T)virtualFile;
                    }
                });
            }
            {
                this.$project = project;
                this.$learningProjectRoot = virtualFile;
                super(0);
            }
        }), (int)1, null);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invokeAndWaitIfNeeded {\n\u2026his, \"git\")\n      }\n    }");
        VirtualFile gitProjectRoot2 = (VirtualFile)object;
        File file = root = gitProjectRoot2.toNioPath().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"root");
        if (!this.copyGitProject(file)) {
            String string = "Failed to copy git project";
            throw new IllegalStateException(string.toString());
        }
        this.checkout(root, branch);
        this.addVcsMappingSynchronously(project, gitProjectRoot2);
    }

    private final void checkout(File root, String branch) {
        GitLineHandler handler = new GitLineHandler(null, root, GitCommand.CHECKOUT);
        handler.addParameters(new String[]{branch});
        handler.endOptions();
        Git.getInstance().runCommand(handler).throwOnError(new int[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addVcsMappingSynchronously(Project project, VirtualFile gitRoot) {
        CompletableFuture updateFinishedFuture = new CompletableFuture();
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect()");
        MessageBusConnection connection = messageBusConnection;
        Topic topic = VcsRepositoryManager.VCS_REPOSITORY_MAPPING_UPDATED;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VcsRepositoryManager.VCS\u2026EPOSITORY_MAPPING_UPDATED");
        connection.subscribe(topic, (Object)new VcsRepositoryMappingListener(updateFinishedFuture){
            final /* synthetic */ CompletableFuture $updateFinishedFuture;

            public final void mappingChanged() {
                this.$updateFinishedFuture.complete(true);
            }
            {
                this.$updateFinishedFuture = completableFuture;
            }
        });
        GitInit.refreshAndConfigureVcsMappings((Project)project, (VirtualFile)gitRoot, (String)gitRoot.getPath());
        try {
            updateFinishedFuture.get(3L, TimeUnit.SECONDS);
        }
        catch (TimeoutException ex) {
            GitProjectUtil $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(GitProjectUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.warn("Repository mappings update didn't happened", (Throwable)ex);
        }
        finally {
            connection.disconnect();
        }
    }

    @NotNull
    public final File createRemoteProject(@NotNull String remoteName, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)remoteName, (String)"remoteName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        File root = this.reCreateRemoteProjectDir();
        if (this.copyGitProject(root)) {
            this.configureRemote(remoteName, root, project);
            return root;
        }
        String string = "Failed to create remote project at path: " + root.getPath();
        throw new IllegalStateException(string.toString());
    }

    private final File reCreateRemoteProjectDir() {
        Object object;
        block9: {
            File projectsRoot;
            block8: {
                File[] fileArray;
                File file;
                File[] fileArray2;
                block7: {
                    projectsRoot = ProjectUtils.INSTANCE.getLearningProjectsPath().toFile();
                    File[] fileArray3 = projectsRoot.listFiles();
                    if (fileArray3 != null) {
                        File[] fileArray4 = fileArray2 = fileArray3;
                        int n = fileArray4.length;
                        for (int i = 0; i < n; ++i) {
                            File file2;
                            File it = file2 = fileArray4[i];
                            boolean bl = false;
                            File file3 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"it");
                            if (!Intrinsics.areEqual((Object)file3.getName(), (Object)remoteProjectName)) continue;
                            file = file2;
                            break block7;
                        }
                        file = null;
                    } else {
                        file = null;
                    }
                }
                File[] it = fileArray2 = file;
                boolean bl = false;
                object = it;
                if (it == null) break block8;
                File[] $this$apply = fileArray = object;
                boolean bl2 = false;
                FilesKt.deleteRecursively((File)$this$apply);
                object = fileArray;
                if (fileArray != null) break block9;
            }
            File file = projectsRoot;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"projectsRoot");
            object = new File(file.getAbsolutePath() + File.separator + remoteProjectName);
        }
        Object remoteProjectRoot = object;
        ((File)remoteProjectRoot).mkdir();
        return remoteProjectRoot;
    }

    private final boolean copyGitProject(File destination) {
        URL uRL = this.getClass().getClassLoader().getResource("learnProjects/GitProject");
        if (uRL == null) {
            String string = "GitProject not found";
            throw new IllegalStateException(string.toString());
        }
        URL gitProjectURL = uRL;
        return FileUtils.copyResourcesRecursively$default((FileUtils)FileUtils.INSTANCE, (URL)gitProjectURL, (File)destination, null, (int)4, null);
    }

    private final void configureRemote(String remoteName, File remoteProjectRoot, Project project) {
        Git git = Git.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)git, (String)"Git.getInstance()");
        Git git2 = git;
        GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)gitRepositoryManager, (String)"GitRepositoryManager.getInstance(project)");
        List list = gitRepositoryManager.getRepositories();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"GitRepositoryManager.get\u2026nce(project).repositories");
        GitRepository repository = (GitRepository)CollectionsKt.first((List)list);
        String remoteUrl = "file://" + FileUtilKt.getSystemIndependentPath((File)remoteProjectRoot);
        GitProjectUtil $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(GitProjectUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        logger.info("Add remote repository with URL: " + remoteUrl);
        git2.addRemote(repository, remoteName, remoteUrl).throwOnError(new int[0]);
        repository.update();
        GitRepository gitRepository = repository;
        Intrinsics.checkNotNullExpressionValue((Object)gitRepository, (String)"repository");
        Collection collection = gitRepository.getRemotes();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"repository.remotes");
        git2.fetch(repository, (GitRemote)CollectionsKt.first((Iterable)collection), CollectionsKt.emptyList(), new String[0]).throwOnError(new int[0]);
        git2.setUpstream(repository, remoteName + "/main", "main").throwOnError(new int[0]);
        repository.update();
    }

    private final VirtualFile refreshAndGetProjectRoot() {
        Path path = ProjectUtils.INSTANCE.getCurrentLearningProjectRoot().toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"ProjectUtils.getCurrentL\u2026ProjectRoot().toNioPath()");
        Path learningProjectPath = path;
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(learningProjectPath);
        if (virtualFile == null) {
            String string = "Learning project not found";
            throw new IllegalStateException(string.toString());
        }
        return virtualFile;
    }

    private GitProjectUtil() {
    }

    static {
        GitProjectUtil gitProjectUtil;
        INSTANCE = gitProjectUtil = new GitProjectUtil();
    }
}

