/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui;

import jadx.api.JadxArgs;
import jadx.api.JavaClass;
import jadx.api.JavaNode;
import jadx.api.ResourceFile;
import jadx.gui.JadxWrapper;
import jadx.gui.jobs.BackgroundWorker;
import jadx.gui.jobs.DecompileJob;
import jadx.gui.jobs.IndexJob;
import jadx.gui.settings.JadxProject;
import jadx.gui.settings.JadxSettings;
import jadx.gui.settings.JadxSettingsWindow;
import jadx.gui.treemodel.ApkSignature;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JLoadableNode;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JPackage;
import jadx.gui.treemodel.JResource;
import jadx.gui.treemodel.JRoot;
import jadx.gui.ui.AboutDialog;
import jadx.gui.ui.ContentPanel;
import jadx.gui.ui.HeapUsageBar;
import jadx.gui.ui.LogViewer;
import jadx.gui.ui.MainDropTarget;
import jadx.gui.ui.ProgressPanel;
import jadx.gui.ui.SearchDialog;
import jadx.gui.ui.TabbedPane;
import jadx.gui.update.JadxUpdate;
import jadx.gui.update.data.Release;
import jadx.gui.utils.CacheObject;
import jadx.gui.utils.FontUtils;
import jadx.gui.utils.JumpPosition;
import jadx.gui.utils.Link;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainWindow
extends JFrame {
    private static final Logger LOG = LoggerFactory.getLogger(MainWindow.class);
    private static final String DEFAULT_TITLE = "jadx-gui";
    private static final double BORDER_RATIO = 0.15;
    private static final double WINDOW_RATIO = 0.7;
    private static final double SPLIT_PANE_RESIZE_WEIGHT = 0.15;
    private static final ImageIcon ICON_OPEN = UiUtils.openIcon("folder");
    private static final ImageIcon ICON_SAVE_ALL = UiUtils.openIcon("disk_multiple");
    private static final ImageIcon ICON_EXPORT = UiUtils.openIcon("database_save");
    private static final ImageIcon ICON_CLOSE = UiUtils.openIcon("cross");
    private static final ImageIcon ICON_SYNC = UiUtils.openIcon("sync");
    private static final ImageIcon ICON_FLAT_PKG = UiUtils.openIcon("empty_logical_package_obj");
    private static final ImageIcon ICON_SEARCH = UiUtils.openIcon("wand");
    private static final ImageIcon ICON_FIND = UiUtils.openIcon("magnifier");
    private static final ImageIcon ICON_BACK = UiUtils.openIcon("icon_back");
    private static final ImageIcon ICON_FORWARD = UiUtils.openIcon("icon_forward");
    private static final ImageIcon ICON_PREF = UiUtils.openIcon("wrench");
    private static final ImageIcon ICON_DEOBF = UiUtils.openIcon("lock_edit");
    private static final ImageIcon ICON_LOG = UiUtils.openIcon("report");
    private static final ImageIcon ICON_JADX = UiUtils.openIcon("jadx-logo");
    private final transient JadxWrapper wrapper;
    private final transient JadxSettings settings;
    private final transient CacheObject cacheObject;
    private transient JadxProject project;
    private transient Action newProjectAction;
    private transient Action saveProjectAction;
    private JPanel mainPanel;
    private JSplitPane splitPane;
    private JTree tree;
    private DefaultTreeModel treeModel;
    private JRoot treeRoot;
    private TabbedPane tabbedPane;
    private HeapUsageBar heapUsageBar;
    private transient boolean treeReloading;
    private boolean isFlattenPackage;
    private JToggleButton flatPkgButton;
    private JCheckBoxMenuItem flatPkgMenuItem;
    private JToggleButton deobfToggleBtn;
    private JCheckBoxMenuItem deobfMenuItem;
    private transient Link updateLink;
    private transient ProgressPanel progressPane;
    private transient BackgroundWorker backgroundWorker;
    private transient Theme editorTheme;

    public MainWindow(JadxSettings settings) {
        this.wrapper = new JadxWrapper(settings);
        this.settings = settings;
        this.cacheObject = new CacheObject();
        this.resetCache();
        FontUtils.registerBundledFonts();
        this.initUI();
        this.initMenuAndToolbar();
        UiUtils.setWindowIcons(this);
        this.loadSettings();
        this.checkForUpdate();
        this.newProject();
    }

    public void init() {
        this.pack();
        this.setLocationAndPosition();
        this.splitPane.setDividerLocation(this.settings.getTreeWidth());
        this.heapUsageBar.setVisible(this.settings.isShowHeapUsageBar());
        this.setVisible(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainWindow.this.closeWindow();
            }
        });
        this.processCommandLineArgs();
    }

    private void processCommandLineArgs() {
        if (this.settings.getFiles().isEmpty()) {
            this.openFileOrProject();
        } else {
            this.open(Paths.get(this.settings.getFiles().get(0), new String[0]));
            if (this.settings.getCmdSelectClass() != null) {
                JavaClass javaNode = this.wrapper.searchJavaClassByClassName(this.settings.getCmdSelectClass());
                if (javaNode == null) {
                    JOptionPane.showMessageDialog(this, NLS.str("msg.cmd_select_class_error", this.settings.getCmdSelectClass()), NLS.str("error_dialog.title", new Object[0]), 0);
                } else {
                    JNode node = this.cacheObject.getNodeCache().makeFrom((JavaNode)javaNode);
                    this.tabbedPane.codeJump(new JumpPosition(node.getRootClass(), node.getLine()));
                }
            }
        }
    }

    private void checkForUpdate() {
        if (!this.settings.isCheckForUpdates()) {
            return;
        }
        JadxUpdate.check(new JadxUpdate.IUpdateCallback(){

            @Override
            public void onUpdate(Release r) {
                SwingUtilities.invokeLater(() -> {
                    MainWindow.this.updateLink.setText(NLS.str("menu.update_label", r.getName()));
                    MainWindow.this.updateLink.setVisible(true);
                });
            }
        });
    }

    public void openFileOrProject() {
        int ret;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(true);
        Object[] exts = new String[]{"jadx", "apk", "dex", "jar", "class", "smali", "zip", "aar", "arsc"};
        String description = "supported files: " + Arrays.toString(exts).replace('[', '(').replace(']', ')');
        fileChooser.setFileFilter(new FileNameExtensionFilter(description, (String[])exts));
        fileChooser.setToolTipText(NLS.str("file.open_action", new Object[0]));
        Path currentDirectory = this.settings.getLastOpenFilePath();
        if (currentDirectory != null) {
            fileChooser.setCurrentDirectory(currentDirectory.toFile());
        }
        if ((ret = fileChooser.showDialog(this.mainPanel, NLS.str("file.open_title", new Object[0]))) == 0) {
            this.settings.setLastOpenFilePath(fileChooser.getCurrentDirectory().toPath());
            this.open(fileChooser.getSelectedFile().toPath());
        }
    }

    private void newProject() {
        if (!this.ensureProjectIsSaved()) {
            return;
        }
        this.project = new JadxProject(this.settings);
        this.update();
        this.clearTree();
    }

    private void clearTree() {
        this.tabbedPane.closeAllTabs();
        this.resetCache();
        this.treeRoot = null;
        this.treeModel.setRoot(this.treeRoot);
        this.treeModel.reload();
    }

    private void saveProject() {
        if (this.project.getProjectPath() == null) {
            this.saveProjectAs();
        } else {
            this.project.save();
            this.update();
        }
    }

    private void saveProjectAs() {
        int ret;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(true);
        Object[] exts = new String[]{"jadx"};
        String description = "supported files: " + Arrays.toString(exts).replace('[', '(').replace(']', ')');
        fileChooser.setFileFilter(new FileNameExtensionFilter(description, (String[])exts));
        fileChooser.setToolTipText(NLS.str("file.save_project", new Object[0]));
        Path currentDirectory = this.settings.getLastSaveProjectPath();
        if (currentDirectory != null) {
            fileChooser.setCurrentDirectory(currentDirectory.toFile());
        }
        if ((ret = fileChooser.showSaveDialog(this.mainPanel)) == 0) {
            int res;
            this.settings.setLastSaveProjectPath(fileChooser.getCurrentDirectory().toPath());
            Path path = fileChooser.getSelectedFile().toPath();
            if (!path.getFileName().toString().toLowerCase(Locale.ROOT).endsWith("jadx")) {
                path = path.resolveSibling(path.getFileName() + "." + "jadx");
            }
            if (Files.exists(path, new LinkOption[0]) && (res = JOptionPane.showConfirmDialog(this, NLS.str("confirm.save_as_message", path.getFileName()), NLS.str("confirm.save_as_title", new Object[0]), 0)) == 1) {
                return;
            }
            this.project.saveAs(path);
            this.update();
        }
    }

    void open(Path path) {
        if (path.getFileName().toString().toLowerCase(Locale.ROOT).endsWith("jadx")) {
            this.openProject(path);
        } else {
            this.project.setFilePath(path);
            this.tabbedPane.closeAllTabs();
            this.resetCache();
            this.wrapper.openFile(path.toFile());
            this.deobfToggleBtn.setSelected(this.settings.isDeobfuscationOn());
            this.initTree();
            this.update();
            this.runBackgroundJobs();
        }
    }

    private boolean ensureProjectIsSaved() {
        if (this.project != null && !this.project.isSaved() && !this.project.isInitial()) {
            int res = JOptionPane.showConfirmDialog(this, NLS.str("confirm.not_saved_message", new Object[0]), NLS.str("confirm.not_saved_title", new Object[0]), 1);
            if (res == 2) {
                return false;
            }
            if (res == 0) {
                this.project.save();
            }
        }
        return true;
    }

    private void openProject(Path path) {
        if (!this.ensureProjectIsSaved()) {
            return;
        }
        this.project = JadxProject.from(path, this.settings);
        if (this.project == null) {
            JOptionPane.showMessageDialog(this, NLS.str("msg.project_error", new Object[0]), NLS.str("msg.project_error_title", new Object[0]), 1);
            return;
        }
        this.update();
        this.settings.addRecentProject(path);
        Path filePath = this.project.getFilePath();
        if (filePath == null) {
            this.clearTree();
        } else {
            this.open(filePath);
        }
    }

    private void update() {
        this.newProjectAction.setEnabled(!this.project.isInitial());
        this.saveProjectAction.setEnabled(!this.project.isSaved());
        Path projectPath = this.project.getProjectPath();
        String pathString = projectPath == null ? "" : " [" + projectPath.getParent().toAbsolutePath() + ']';
        this.setTitle((this.project.isSaved() ? "" : Character.valueOf('*')) + this.project.getName() + pathString + " - " + DEFAULT_TITLE);
    }

    protected void resetCache() {
        this.cacheObject.reset();
        int threadsCount = this.settings.getThreadsCount();
        this.cacheObject.setDecompileJob(new DecompileJob(this.wrapper, threadsCount));
        this.cacheObject.setIndexJob(new IndexJob(this.wrapper, this.cacheObject, threadsCount));
    }

    private synchronized void runBackgroundJobs() {
        this.cancelBackgroundJobs();
        this.backgroundWorker = new BackgroundWorker(this.cacheObject, this.progressPane);
        if (this.settings.isAutoStartJobs()) {
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    MainWindow.this.backgroundWorker.exec();
                }
            }, 1000L);
        }
    }

    public synchronized void cancelBackgroundJobs() {
        if (this.backgroundWorker != null) {
            this.backgroundWorker.stop();
            this.backgroundWorker = new BackgroundWorker(this.cacheObject, this.progressPane);
            this.resetCache();
        }
    }

    public void reOpenFile() {
        File openedFile = this.wrapper.getOpenFile();
        if (openedFile != null) {
            this.open(openedFile.toPath());
        }
    }

    private void saveAll(boolean export) {
        int ret;
        JadxArgs decompilerArgs = this.wrapper.getArgs();
        if (!decompilerArgs.isFsCaseSensitive() && !decompilerArgs.isRenameCaseSensitive() || !decompilerArgs.isRenameValid() || !decompilerArgs.isRenamePrintable()) {
            JOptionPane.showMessageDialog(this, NLS.str("msg.rename_disabled", this.settings.getLangLocale()), NLS.str("msg.rename_disabled_title", this.settings.getLangLocale()), 1);
        }
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        fileChooser.setToolTipText(NLS.str("file.save_all_msg", new Object[0]));
        Path currentDirectory = this.settings.getLastSaveFilePath();
        if (currentDirectory != null) {
            fileChooser.setCurrentDirectory(currentDirectory.toFile());
        }
        if ((ret = fileChooser.showSaveDialog(this.mainPanel)) == 0) {
            decompilerArgs.setExportAsGradleProject(export);
            if (export) {
                decompilerArgs.setSkipSources(false);
                decompilerArgs.setSkipResources(false);
            } else {
                decompilerArgs.setSkipSources(this.settings.isSkipSources());
                decompilerArgs.setSkipResources(this.settings.isSkipResources());
            }
            this.settings.setLastSaveFilePath(fileChooser.getCurrentDirectory().toPath());
            ProgressMonitor progressMonitor = new ProgressMonitor(this.mainPanel, NLS.str("msg.saving_sources", new Object[0]), "", 0, 100);
            progressMonitor.setMillisToPopup(0);
            this.wrapper.saveAll(fileChooser.getSelectedFile(), progressMonitor);
        }
    }

    private void initTree() {
        this.treeRoot = new JRoot(this.wrapper);
        this.treeRoot.setFlatPackages(this.isFlattenPackage);
        this.treeModel.setRoot(this.treeRoot);
        this.reloadTree();
    }

    private void reloadTree() {
        this.treeReloading = true;
        this.treeModel.reload();
        List<String[]> treeExpansions = this.project.getTreeExpansions();
        if (!treeExpansions.isEmpty()) {
            this.expand(this.treeRoot, treeExpansions);
        } else {
            this.tree.expandRow(1);
        }
        this.treeReloading = false;
    }

    private void expand(TreeNode node, List<String[]> treeExpansions) {
        Object[] pathNodes = this.treeModel.getPathToRoot(node);
        if (pathNodes == null) {
            return;
        }
        TreePath path = new TreePath(pathNodes);
        for (Object[] objectArray : treeExpansions) {
            if (!Arrays.equals(objectArray, MainWindow.getPathExpansion(path))) continue;
            this.tree.expandPath(path);
            break;
        }
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            this.expand(node.getChildAt(i), treeExpansions);
        }
    }

    private void toggleFlattenPackage() {
        this.setFlattenPackage(!this.isFlattenPackage);
    }

    private void setFlattenPackage(boolean value) {
        this.isFlattenPackage = value;
        this.settings.setFlattenPackage(this.isFlattenPackage);
        this.flatPkgButton.setSelected(this.isFlattenPackage);
        this.flatPkgMenuItem.setState(this.isFlattenPackage);
        Object root = this.treeModel.getRoot();
        if (root instanceof JRoot) {
            JRoot treeRoot = (JRoot)root;
            treeRoot.setFlatPackages(this.isFlattenPackage);
            this.reloadTree();
        }
    }

    private void toggleDeobfuscation() {
        boolean deobfOn = !this.settings.isDeobfuscationOn();
        this.settings.setDeobfuscationOn(deobfOn);
        this.settings.sync();
        this.deobfToggleBtn.setSelected(deobfOn);
        this.deobfMenuItem.setState(deobfOn);
        this.reOpenFile();
    }

    private void nodeClickAction(@Nullable Object obj) {
        try {
            JNode node;
            JClass cls;
            if (obj == null) {
                return;
            }
            if (obj instanceof JResource) {
                JResource res = (JResource)obj;
                ResourceFile resFile = res.getResFile();
                if (resFile != null && JResource.isSupportedForView(resFile.getType())) {
                    this.tabbedPane.showResource(res);
                }
            } else if (obj instanceof ApkSignature) {
                this.tabbedPane.showSimpleNode((JNode)obj);
            } else if (obj instanceof JNode && (cls = (node = (JNode)obj).getRootClass()) != null) {
                this.tabbedPane.codeJump(new JumpPosition(cls, node.getLine()));
            }
        }
        catch (Exception e) {
            LOG.error("Content loading error", (Throwable)e);
        }
    }

    private void treeRightClickAction(MouseEvent e) {
        JNode obj = this.getJNodeUnderMouse(e);
        if (obj instanceof JPackage) {
            JPackagePopUp menu = new JPackagePopUp((JPackage)obj);
            menu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Nullable
    private JNode getJNodeUnderMouse(MouseEvent mouseEvent) {
        Object obj;
        TreePath path = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (path != null && (obj = path.getLastPathComponent()) instanceof JNode) {
            return (JNode)obj;
        }
        return null;
    }

    private void syncWithEditor() {
        ContentPanel selectedContentPanel = this.tabbedPane.getSelectedCodePanel();
        if (selectedContentPanel == null) {
            return;
        }
        JNode node = selectedContentPanel.getNode();
        if (node.getParent() == null && this.treeRoot != null && (node = this.treeRoot.searchClassInTree(node)) == null) {
            LOG.error("Class not found in tree");
            return;
        }
        Object[] pathNodes = this.treeModel.getPathToRoot(node);
        if (pathNodes == null) {
            return;
        }
        TreePath path = new TreePath(pathNodes);
        this.tree.setSelectionPath(path);
        this.tree.makeVisible(path);
        this.tree.scrollPathToVisible(path);
        this.tree.requestFocus();
    }

    private void initMenuAndToolbar() {
        AbstractAction openAction = new AbstractAction(NLS.str("file.open_action", new Object[0]), ICON_OPEN){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.openFileOrProject();
            }
        };
        openAction.putValue("ShortDescription", NLS.str("file.open_action", new Object[0]));
        openAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, UiUtils.ctrlButton()));
        this.newProjectAction = new AbstractAction(NLS.str("file.new_project", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.newProject();
            }
        };
        this.newProjectAction.putValue("ShortDescription", NLS.str("file.new_project", new Object[0]));
        this.saveProjectAction = new AbstractAction(NLS.str("file.save_project", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.saveProject();
            }
        };
        this.saveProjectAction.putValue("ShortDescription", NLS.str("file.save_project", new Object[0]));
        AbstractAction saveProjectAsAction = new AbstractAction(NLS.str("file.save_project_as", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.saveProjectAs();
            }
        };
        saveProjectAsAction.putValue("ShortDescription", NLS.str("file.save_project_as", new Object[0]));
        AbstractAction saveAllAction = new AbstractAction(NLS.str("file.save_all", new Object[0]), ICON_SAVE_ALL){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.saveAll(false);
            }
        };
        saveAllAction.putValue("ShortDescription", NLS.str("file.save_all", new Object[0]));
        saveAllAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, UiUtils.ctrlButton()));
        AbstractAction exportAction = new AbstractAction(NLS.str("file.export_gradle", new Object[0]), ICON_EXPORT){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.saveAll(true);
            }
        };
        exportAction.putValue("ShortDescription", NLS.str("file.export_gradle", new Object[0]));
        exportAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, UiUtils.ctrlButton()));
        JMenu recentProjects = new JMenu(NLS.str("menu.recent_projects", new Object[0]));
        recentProjects.addMenuListener(new RecentProjectsMenuListener(recentProjects));
        AbstractAction prefsAction = new AbstractAction(NLS.str("menu.preferences", new Object[0]), ICON_PREF){

            @Override
            public void actionPerformed(ActionEvent e) {
                new JadxSettingsWindow(MainWindow.this, MainWindow.this.settings).setVisible(true);
            }
        };
        prefsAction.putValue("ShortDescription", NLS.str("menu.preferences", new Object[0]));
        prefsAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, UiUtils.ctrlButton() | 0x40));
        AbstractAction exitAction = new AbstractAction(NLS.str("file.exit", new Object[0]), ICON_CLOSE){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.dispose();
            }
        };
        this.isFlattenPackage = this.settings.isFlattenPackage();
        this.flatPkgMenuItem = new JCheckBoxMenuItem(NLS.str("menu.flatten", new Object[0]), ICON_FLAT_PKG);
        this.flatPkgMenuItem.setState(this.isFlattenPackage);
        JCheckBoxMenuItem heapUsageBarMenuItem = new JCheckBoxMenuItem(NLS.str("menu.heapUsageBar", new Object[0]));
        heapUsageBarMenuItem.setState(this.settings.isShowHeapUsageBar());
        heapUsageBarMenuItem.addActionListener(event -> {
            this.settings.setShowHeapUsageBar(!this.settings.isShowHeapUsageBar());
            this.heapUsageBar.setVisible(this.settings.isShowHeapUsageBar());
        });
        AbstractAction syncAction = new AbstractAction(NLS.str("menu.sync", new Object[0]), ICON_SYNC){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.syncWithEditor();
            }
        };
        syncAction.putValue("ShortDescription", NLS.str("menu.sync", new Object[0]));
        syncAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, UiUtils.ctrlButton()));
        AbstractAction textSearchAction = new AbstractAction(NLS.str("menu.text_search", new Object[0]), ICON_SEARCH){

            @Override
            public void actionPerformed(ActionEvent e) {
                new SearchDialog(MainWindow.this, true).setVisible(true);
            }
        };
        textSearchAction.putValue("ShortDescription", NLS.str("menu.text_search", new Object[0]));
        textSearchAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, UiUtils.ctrlButton() | 0x40));
        AbstractAction clsSearchAction = new AbstractAction(NLS.str("menu.class_search", new Object[0]), ICON_FIND){

            @Override
            public void actionPerformed(ActionEvent e) {
                new SearchDialog(MainWindow.this, false).setVisible(true);
            }
        };
        clsSearchAction.putValue("ShortDescription", NLS.str("menu.class_search", new Object[0]));
        clsSearchAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, UiUtils.ctrlButton()));
        AbstractAction deobfAction = new AbstractAction(NLS.str("menu.deobfuscation", new Object[0]), ICON_DEOBF){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.toggleDeobfuscation();
            }
        };
        deobfAction.putValue("ShortDescription", NLS.str("preferences.deobfuscation", new Object[0]));
        deobfAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(68, UiUtils.ctrlButton() | 0x200));
        this.deobfToggleBtn = new JToggleButton(deobfAction);
        this.deobfToggleBtn.setSelected(this.settings.isDeobfuscationOn());
        this.deobfToggleBtn.setText("");
        this.deobfMenuItem = new JCheckBoxMenuItem(deobfAction);
        this.deobfMenuItem.setState(this.settings.isDeobfuscationOn());
        AbstractAction logAction = new AbstractAction(NLS.str("menu.log", new Object[0]), ICON_LOG){

            @Override
            public void actionPerformed(ActionEvent e) {
                new LogViewer(MainWindow.this).setVisible(true);
            }
        };
        logAction.putValue("ShortDescription", NLS.str("menu.log", new Object[0]));
        logAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(76, UiUtils.ctrlButton() | 0x40));
        AbstractAction aboutAction = new AbstractAction(NLS.str("menu.about", new Object[0]), ICON_JADX){

            @Override
            public void actionPerformed(ActionEvent e) {
                new AboutDialog().setVisible(true);
            }
        };
        AbstractAction backAction = new AbstractAction(NLS.str("nav.back", new Object[0]), ICON_BACK){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.tabbedPane.navBack();
            }
        };
        backAction.putValue("ShortDescription", NLS.str("nav.back", new Object[0]));
        backAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(37, UiUtils.ctrlButton() | 0x200));
        AbstractAction forwardAction = new AbstractAction(NLS.str("nav.forward", new Object[0]), ICON_FORWARD){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.tabbedPane.navForward();
            }
        };
        forwardAction.putValue("ShortDescription", NLS.str("nav.forward", new Object[0]));
        forwardAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(39, UiUtils.ctrlButton() | 0x200));
        JMenu file = new JMenu(NLS.str("menu.file", new Object[0]));
        file.setMnemonic(70);
        file.add(openAction);
        file.addSeparator();
        file.add(this.newProjectAction);
        file.add(this.saveProjectAction);
        file.add(saveProjectAsAction);
        file.addSeparator();
        file.add(saveAllAction);
        file.add(exportAction);
        file.addSeparator();
        file.add(recentProjects);
        file.addSeparator();
        file.add(prefsAction);
        file.addSeparator();
        file.add(exitAction);
        JMenu view = new JMenu(NLS.str("menu.view", new Object[0]));
        view.setMnemonic(86);
        view.add(this.flatPkgMenuItem);
        view.add(syncAction);
        view.add(heapUsageBarMenuItem);
        JMenu nav = new JMenu(NLS.str("menu.navigation", new Object[0]));
        nav.setMnemonic(78);
        nav.add(textSearchAction);
        nav.add(clsSearchAction);
        nav.addSeparator();
        nav.add(backAction);
        nav.add(forwardAction);
        JMenu tools = new JMenu(NLS.str("menu.tools", new Object[0]));
        tools.setMnemonic(84);
        tools.add(this.deobfMenuItem);
        tools.add(logAction);
        JMenu help = new JMenu(NLS.str("menu.help", new Object[0]));
        help.setMnemonic(72);
        help.add(aboutAction);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(file);
        menuBar.add(view);
        menuBar.add(nav);
        menuBar.add(tools);
        menuBar.add(help);
        this.setJMenuBar(menuBar);
        this.flatPkgButton = new JToggleButton(ICON_FLAT_PKG);
        this.flatPkgButton.setSelected(this.isFlattenPackage);
        ActionListener flatPkgAction = e -> this.toggleFlattenPackage();
        this.flatPkgMenuItem.addActionListener(flatPkgAction);
        this.flatPkgButton.addActionListener(flatPkgAction);
        this.flatPkgButton.setToolTipText(NLS.str("menu.flatten", new Object[0]));
        this.updateLink = new Link("", "https://github.com/skylot/jadx/releases");
        this.updateLink.setVisible(false);
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add(openAction);
        toolbar.add(saveAllAction);
        toolbar.add(exportAction);
        toolbar.addSeparator();
        toolbar.add(syncAction);
        toolbar.add(this.flatPkgButton);
        toolbar.addSeparator();
        toolbar.add(textSearchAction);
        toolbar.add(clsSearchAction);
        toolbar.addSeparator();
        toolbar.add(backAction);
        toolbar.add(forwardAction);
        toolbar.addSeparator();
        toolbar.add(this.deobfToggleBtn);
        toolbar.addSeparator();
        toolbar.add(logAction);
        toolbar.addSeparator();
        toolbar.add(prefsAction);
        toolbar.addSeparator();
        toolbar.add(Box.createHorizontalGlue());
        toolbar.add(this.updateLink);
        this.mainPanel.add((Component)toolbar, "North");
    }

    private void initUI() {
        this.setMinimumSize(new Dimension(200, 150));
        this.mainPanel = new JPanel(new BorderLayout());
        this.splitPane = new JSplitPane();
        this.splitPane.setResizeWeight(0.15);
        this.mainPanel.add(this.splitPane);
        DefaultMutableTreeNode treeRootNode = new DefaultMutableTreeNode(NLS.str("msg.open_file", new Object[0]));
        this.treeModel = new DefaultTreeModel(treeRootNode);
        this.tree = new JTree(this.treeModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    MainWindow.this.nodeClickAction(MainWindow.this.getJNodeUnderMouse(e));
                } else if (SwingUtilities.isRightMouseButton(e)) {
                    MainWindow.this.treeRightClickAction(e);
                }
            }
        });
        this.tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    MainWindow.this.nodeClickAction(MainWindow.this.tree.getLastSelectedPathComponent());
                }
            }
        });
        this.tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean isLeaf, int row, boolean focused) {
                Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, isLeaf, row, focused);
                if (value instanceof JNode) {
                    this.setIcon(((JNode)value).getIcon());
                }
                if (value instanceof JPackage) {
                    this.setEnabled(((JPackage)value).isEnabled());
                }
                return c;
            }
        });
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                Object node = path.getLastPathComponent();
                if (node instanceof JLoadableNode) {
                    ((JLoadableNode)node).loadNode();
                }
                if (!MainWindow.this.treeReloading) {
                    MainWindow.this.project.addTreeExpansion(MainWindow.getPathExpansion(event.getPath()));
                    MainWindow.this.update();
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) {
                if (!MainWindow.this.treeReloading) {
                    MainWindow.this.project.removeTreeExpansion(MainWindow.getPathExpansion(event.getPath()));
                    MainWindow.this.update();
                }
            }
        });
        this.progressPane = new ProgressPanel(this, true);
        JPanel leftPane = new JPanel(new BorderLayout());
        JScrollPane treeScrollPane = new JScrollPane(this.tree);
        treeScrollPane.setMinimumSize(new Dimension(100, 150));
        leftPane.add((Component)treeScrollPane, "Center");
        leftPane.add((Component)this.progressPane, "Last");
        this.splitPane.setLeftComponent(leftPane);
        this.tabbedPane = new TabbedPane(this);
        this.tabbedPane.setMinimumSize(new Dimension(150, 150));
        this.splitPane.setRightComponent(this.tabbedPane);
        new DropTarget(this, 1, new MainDropTarget(this));
        this.heapUsageBar = new HeapUsageBar();
        this.mainPanel.add((Component)this.heapUsageBar, "South");
        this.setContentPane(this.mainPanel);
        this.setTitle(DEFAULT_TITLE);
    }

    private static String[] getPathExpansion(TreePath path) {
        ArrayList<String> pathList = new ArrayList<String>();
        while (path != null) {
            Object node = path.getLastPathComponent();
            String name = node instanceof JClass ? ((JClass)node).getCls().getClassNode().getClassInfo().getFullName() : node.toString();
            pathList.add(name);
            path = path.getParentPath();
        }
        return pathList.toArray(new String[pathList.size()]);
    }

    public static void getExpandedPaths(JTree tree, TreePath path, List<TreePath> list) {
        if (tree.isExpanded(path)) {
            list.add(path);
            TreeNode node = (TreeNode)path.getLastPathComponent();
            for (int i = node.getChildCount() - 1; i >= 0; --i) {
                TreeNode n = node.getChildAt(i);
                TreePath child = path.pathByAddingChild(n);
                MainWindow.getExpandedPaths(tree, child, list);
            }
        }
    }

    public void setLocationAndPosition() {
        if (this.settings.loadWindowPos(this)) {
            return;
        }
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        DisplayMode mode = gd.getDisplayMode();
        int w = mode.getWidth();
        int h = mode.getHeight();
        this.setBounds((int)((double)w * 0.15), (int)((double)h * 0.15), (int)((double)w * 0.7), (int)((double)h * 0.7));
        this.setLocationRelativeTo(null);
    }

    private void setEditorTheme(String editorThemePath) {
        try (InputStream is = this.getClass().getResourceAsStream(editorThemePath);){
            this.editorTheme = Theme.load((InputStream)is);
        }
        catch (Exception e) {
            LOG.error("Can't load editor theme from classpath: {}", (Object)editorThemePath);
            try (FileInputStream is2 = new FileInputStream(editorThemePath);){
                this.editorTheme = Theme.load((InputStream)is2);
            }
            catch (Exception ex) {
                LOG.error("Can't load editor theme from file: {}", (Object)editorThemePath);
            }
        }
    }

    public Theme getEditorTheme() {
        return this.editorTheme;
    }

    public void loadSettings() {
        Font font = this.settings.getFont();
        Font largerFont = font.deriveFont((float)font.getSize() + 2.0f);
        this.setFont(largerFont);
        this.setEditorTheme(this.settings.getEditorThemePath());
        this.tree.setFont(largerFont);
        this.tree.setRowHeight(-1);
        this.tabbedPane.loadSettings();
    }

    private void closeWindow() {
        if (!this.ensureProjectIsSaved()) {
            return;
        }
        this.settings.setTreeWidth(this.splitPane.getDividerLocation());
        this.settings.saveWindowPos(this);
        this.settings.setMainWindowExtendedState(this.getExtendedState());
        this.cancelBackgroundJobs();
        this.dispose();
        System.exit(0);
    }

    public JadxWrapper getWrapper() {
        return this.wrapper;
    }

    public TabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public JadxSettings getSettings() {
        return this.settings;
    }

    public CacheObject getCacheObject() {
        return this.cacheObject;
    }

    public BackgroundWorker getBackgroundWorker() {
        return this.backgroundWorker;
    }

    private class JPackagePopUp
    extends JPopupMenu {
        JMenuItem excludeItem = new JCheckBoxMenuItem(NLS.str("popup.exclude", new Object[0]));

        public JPackagePopUp(JPackage pkg) {
            this.excludeItem.setSelected(!pkg.isEnabled());
            this.add(this.excludeItem);
            this.excludeItem.addItemListener(e -> {
                String fullName = pkg.getFullName();
                if (this.excludeItem.isSelected()) {
                    MainWindow.this.wrapper.addExcludedPackage(fullName);
                } else {
                    MainWindow.this.wrapper.removeExcludedPackage(fullName);
                }
                MainWindow.this.reOpenFile();
            });
        }
    }

    private class RecentProjectsMenuListener
    implements MenuListener {
        private final JMenu recentProjects;

        public RecentProjectsMenuListener(JMenu recentProjects) {
            this.recentProjects = recentProjects;
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            this.recentProjects.removeAll();
            File openFile = MainWindow.this.wrapper.getOpenFile();
            Path currentPath = openFile == null ? null : openFile.toPath();
            for (Path path : MainWindow.this.settings.getRecentProjects()) {
                if (path.equals(currentPath)) continue;
                JMenuItem menuItem = new JMenuItem(path.toAbsolutePath().toString());
                this.recentProjects.add(menuItem);
                menuItem.addActionListener(e -> MainWindow.this.open(path));
            }
            if (this.recentProjects.getItemCount() == 0) {
                this.recentProjects.add(new JMenuItem(NLS.str("menu.no_recent_projects", new Object[0])));
            }
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }
    }
}

