/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.xmpp.muc;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.impl.protocol.xmpp.ChatRoom;
import org.jitsi.impl.protocol.xmpp.ChatRoomMember;
import org.jitsi.jicofo.xmpp.muc.ChatRoomListener;
import org.jitsi.jicofo.xmpp.muc.MemberRole;
import org.jitsi.jicofo.xmpp.muc.MemberRoleKt;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0004J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0017\u001a\u00020\u0014H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u0082\u0001\u0002\u0018\u0019\u00a8\u0006\u001a"}, d2={"Lorg/jitsi/jicofo/xmpp/muc/ChatRoomRoleManager;", "Lorg/jitsi/jicofo/xmpp/muc/ChatRoomListener;", "chatRoom", "Lorg/jitsi/impl/protocol/xmpp/ChatRoom;", "(Lorg/jitsi/impl/protocol/xmpp/ChatRoom;)V", "getChatRoom", "()Lorg/jitsi/impl/protocol/xmpp/ChatRoom;", "debugState", "Lorg/jitsi/utils/OrderedJsonObject;", "getDebugState", "()Lorg/jitsi/utils/OrderedJsonObject;", "logger", "Lorg/jitsi/utils/logging2/Logger;", "getLogger", "()Lorg/jitsi/utils/logging2/Logger;", "grantOwner", "", "member", "Lorg/jitsi/impl/protocol/xmpp/ChatRoomMember;", "memberKicked", "", "memberLeft", "memberLeftOrKicked", "stop", "Lorg/jitsi/jicofo/xmpp/muc/AutoOwnerRoleManager;", "Lorg/jitsi/jicofo/xmpp/muc/AuthenticationRoleManager;", "jicofo"})
public abstract class ChatRoomRoleManager
implements ChatRoomListener {
    @NotNull
    private final ChatRoom chatRoom;
    @NotNull
    private final Logger logger;
    @NotNull
    private final OrderedJsonObject debugState;

    private ChatRoomRoleManager(ChatRoom chatRoom) {
        this.chatRoom = chatRoom;
        this.logger = LoggerExtensionsKt.createLogger$default(this, null, null, 3, null);
        this.debugState = new OrderedJsonObject();
    }

    @NotNull
    protected final ChatRoom getChatRoom() {
        return this.chatRoom;
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    protected final boolean grantOwner(@NotNull ChatRoomMember member) {
        boolean bl;
        Intrinsics.checkNotNullParameter(member, "member");
        if (!MemberRoleKt.hasOwnerRights(this.chatRoom.getUserRole())) {
            this.logger.warn("Can not grant owner, lacking privileges.");
            return false;
        }
        try {
            this.chatRoom.grantOwnership(member);
            bl = true;
        }
        catch (RuntimeException e) {
            this.logger.error("Failed to grant owner status to " + member.getJid(), e);
            bl = false;
        }
        return bl;
    }

    @Override
    public void memberLeft(@NotNull ChatRoomMember member) {
        Intrinsics.checkNotNullParameter(member, "member");
        this.memberLeftOrKicked(member);
    }

    @Override
    public void memberKicked(@NotNull ChatRoomMember member) {
        Intrinsics.checkNotNullParameter(member, "member");
        this.memberLeftOrKicked(member);
    }

    protected void memberLeftOrKicked(@NotNull ChatRoomMember member) {
        Intrinsics.checkNotNullParameter(member, "member");
    }

    public void stop() {
    }

    @NotNull
    public OrderedJsonObject getDebugState() {
        return this.debugState;
    }

    @Override
    public void memberJoined(@NotNull ChatRoomMember member) {
        ChatRoomListener.DefaultImpls.memberJoined(this, member);
    }

    @Override
    public void memberPresenceChanged(@NotNull ChatRoomMember member) {
        ChatRoomListener.DefaultImpls.memberPresenceChanged(this, member);
    }

    @Override
    public void roomDestroyed(@Nullable String reason) {
        ChatRoomListener.DefaultImpls.roomDestroyed(this, reason);
    }

    @Override
    public void startMutedChanged(boolean startAudioMuted, boolean startVideoMuted) {
        ChatRoomListener.DefaultImpls.startMutedChanged(this, startAudioMuted, startVideoMuted);
    }

    @Override
    public void localRoleChanged(@NotNull MemberRole newRole, @Nullable MemberRole oldRole) {
        ChatRoomListener.DefaultImpls.localRoleChanged(this, newRole, oldRole);
    }

    @Override
    public void numAudioSendersChanged(int numAudioSenders) {
        ChatRoomListener.DefaultImpls.numAudioSendersChanged(this, numAudioSenders);
    }

    @Override
    public void numVideoSendersChanged(int numVideoSenders) {
        ChatRoomListener.DefaultImpls.numVideoSendersChanged(this, numVideoSenders);
    }

    public /* synthetic */ ChatRoomRoleManager(ChatRoom chatRoom, DefaultConstructorMarker $constructor_marker) {
        this(chatRoom);
    }
}

