"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var canvas_1 = require("../../../../renderers/canvas");
var commons_1 = require("../../../../utils/commons");
var color_library_wrappers_1 = require("../../../partition_chart/layout/utils/color_library_wrappers");
var spec_1 = require("../../state/utils/spec");
var axis_type_utils_1 = require("../../utils/axis_type_utils");
var line_1 = require("./primitives/line");
function renderGrids(ctx, props) {
    var axesGridLinesPositions = props.axesGridLinesPositions, axesSpecs = props.axesSpecs, chartDimensions = props.chartDimensions, sharedAxesStyle = props.sharedAxesStyle, axesStyles = props.axesStyles;
    canvas_1.withContext(ctx, function (ctx) {
        ctx.translate(chartDimensions.left, chartDimensions.top);
        axesGridLinesPositions.forEach(function (axisGridLinesPositions, axisId) {
            var _a;
            var axisSpec = spec_1.getSpecsById(axesSpecs, axisId);
            if (axisSpec && axisGridLinesPositions.length > 0) {
                var axisStyle = (_a = axesStyles.get(axisSpec.id), (_a !== null && _a !== void 0 ? _a : sharedAxesStyle));
                var themeConfig = axis_type_utils_1.isVerticalGrid(axisSpec.position)
                    ? axisStyle.gridLine.vertical
                    : axisStyle.gridLine.horizontal;
                var axisSpecConfig = axisSpec.gridLine;
                var gridLine = axisSpecConfig ? commons_1.mergePartial(themeConfig, axisSpecConfig) : themeConfig;
                if (!gridLine.stroke || !gridLine.strokeWidth || gridLine.strokeWidth < line_1.MIN_STROKE_WIDTH) {
                    return;
                }
                var strokeColor = color_library_wrappers_1.stringToRGB(gridLine.stroke);
                strokeColor.opacity =
                    gridLine.opacity !== undefined ? strokeColor.opacity * gridLine.opacity : strokeColor.opacity;
                var stroke = {
                    color: strokeColor,
                    width: gridLine.strokeWidth,
                    dash: gridLine.dash,
                };
                var lines = axisGridLinesPositions.map(function (_a) {
                    var _b = __read(_a, 4), x1 = _b[0], y1 = _b[1], x2 = _b[2], y2 = _b[3];
                    return ({ x1: x1, y1: y1, x2: x2, y2: y2 });
                });
                line_1.renderMultiLine(ctx, lines, stroke);
            }
        });
    });
}
exports.renderGrids = renderGrids;
//# sourceMappingURL=grids.js.map