/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;

public class VkSwapchainCreateInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int SURFACE;
    public static final int MINIMAGECOUNT;
    public static final int IMAGEFORMAT;
    public static final int IMAGECOLORSPACE;
    public static final int IMAGEEXTENT;
    public static final int IMAGEARRAYLAYERS;
    public static final int IMAGEUSAGE;
    public static final int IMAGESHARINGMODE;
    public static final int QUEUEFAMILYINDEXCOUNT;
    public static final int PQUEUEFAMILYINDICES;
    public static final int PRETRANSFORM;
    public static final int COMPOSITEALPHA;
    public static final int PRESENTMODE;
    public static final int CLIPPED;
    public static final int OLDSWAPCHAIN;

    public VkSwapchainCreateInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkSwapchainCreateInfoKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkSwapchainCreateInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkSwapchainCreateInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkSwapchainCreateFlagsKHR")
    public int flags() {
        return VkSwapchainCreateInfoKHR.nflags(this.address());
    }

    @NativeType(value="VkSurfaceKHR")
    public long surface() {
        return VkSwapchainCreateInfoKHR.nsurface(this.address());
    }

    @NativeType(value="uint32_t")
    public int minImageCount() {
        return VkSwapchainCreateInfoKHR.nminImageCount(this.address());
    }

    @NativeType(value="VkFormat")
    public int imageFormat() {
        return VkSwapchainCreateInfoKHR.nimageFormat(this.address());
    }

    @NativeType(value="VkColorSpaceKHR")
    public int imageColorSpace() {
        return VkSwapchainCreateInfoKHR.nimageColorSpace(this.address());
    }

    public VkExtent2D imageExtent() {
        return VkSwapchainCreateInfoKHR.nimageExtent(this.address());
    }

    @NativeType(value="uint32_t")
    public int imageArrayLayers() {
        return VkSwapchainCreateInfoKHR.nimageArrayLayers(this.address());
    }

    @NativeType(value="VkImageUsageFlags")
    public int imageUsage() {
        return VkSwapchainCreateInfoKHR.nimageUsage(this.address());
    }

    @NativeType(value="VkSharingMode")
    public int imageSharingMode() {
        return VkSwapchainCreateInfoKHR.nimageSharingMode(this.address());
    }

    @NativeType(value="uint32_t")
    public int queueFamilyIndexCount() {
        return VkSwapchainCreateInfoKHR.nqueueFamilyIndexCount(this.address());
    }

    @Nullable
    @NativeType(value="uint32_t const *")
    public IntBuffer pQueueFamilyIndices() {
        return VkSwapchainCreateInfoKHR.npQueueFamilyIndices(this.address());
    }

    @NativeType(value="VkSurfaceTransformFlagBitsKHR")
    public int preTransform() {
        return VkSwapchainCreateInfoKHR.npreTransform(this.address());
    }

    @NativeType(value="VkCompositeAlphaFlagBitsKHR")
    public int compositeAlpha() {
        return VkSwapchainCreateInfoKHR.ncompositeAlpha(this.address());
    }

    @NativeType(value="VkPresentModeKHR")
    public int presentMode() {
        return VkSwapchainCreateInfoKHR.npresentMode(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean clipped() {
        return VkSwapchainCreateInfoKHR.nclipped(this.address()) != 0;
    }

    @NativeType(value="VkSwapchainKHR")
    public long oldSwapchain() {
        return VkSwapchainCreateInfoKHR.noldSwapchain(this.address());
    }

    public VkSwapchainCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkSwapchainCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkSwapchainCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR flags(@NativeType(value="VkSwapchainCreateFlagsKHR") int value) {
        VkSwapchainCreateInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR surface(@NativeType(value="VkSurfaceKHR") long value) {
        VkSwapchainCreateInfoKHR.nsurface(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR minImageCount(@NativeType(value="uint32_t") int value) {
        VkSwapchainCreateInfoKHR.nminImageCount(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR imageFormat(@NativeType(value="VkFormat") int value) {
        VkSwapchainCreateInfoKHR.nimageFormat(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR imageColorSpace(@NativeType(value="VkColorSpaceKHR") int value) {
        VkSwapchainCreateInfoKHR.nimageColorSpace(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR imageExtent(VkExtent2D value) {
        VkSwapchainCreateInfoKHR.nimageExtent(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR imageExtent(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.imageExtent());
        return this;
    }

    public VkSwapchainCreateInfoKHR imageArrayLayers(@NativeType(value="uint32_t") int value) {
        VkSwapchainCreateInfoKHR.nimageArrayLayers(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR imageUsage(@NativeType(value="VkImageUsageFlags") int value) {
        VkSwapchainCreateInfoKHR.nimageUsage(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR imageSharingMode(@NativeType(value="VkSharingMode") int value) {
        VkSwapchainCreateInfoKHR.nimageSharingMode(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR pQueueFamilyIndices(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
        VkSwapchainCreateInfoKHR.npQueueFamilyIndices(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR preTransform(@NativeType(value="VkSurfaceTransformFlagBitsKHR") int value) {
        VkSwapchainCreateInfoKHR.npreTransform(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR compositeAlpha(@NativeType(value="VkCompositeAlphaFlagBitsKHR") int value) {
        VkSwapchainCreateInfoKHR.ncompositeAlpha(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR presentMode(@NativeType(value="VkPresentModeKHR") int value) {
        VkSwapchainCreateInfoKHR.npresentMode(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR clipped(@NativeType(value="VkBool32") boolean value) {
        VkSwapchainCreateInfoKHR.nclipped(this.address(), value ? 1 : 0);
        return this;
    }

    public VkSwapchainCreateInfoKHR oldSwapchain(@NativeType(value="VkSwapchainKHR") long value) {
        VkSwapchainCreateInfoKHR.noldSwapchain(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR set(int sType, long pNext, int flags, long surface, int minImageCount, int imageFormat, int imageColorSpace, VkExtent2D imageExtent, int imageArrayLayers, int imageUsage, int imageSharingMode, @Nullable IntBuffer pQueueFamilyIndices, int preTransform, int compositeAlpha, int presentMode, boolean clipped, long oldSwapchain) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.surface(surface);
        this.minImageCount(minImageCount);
        this.imageFormat(imageFormat);
        this.imageColorSpace(imageColorSpace);
        this.imageExtent(imageExtent);
        this.imageArrayLayers(imageArrayLayers);
        this.imageUsage(imageUsage);
        this.imageSharingMode(imageSharingMode);
        this.pQueueFamilyIndices(pQueueFamilyIndices);
        this.preTransform(preTransform);
        this.compositeAlpha(compositeAlpha);
        this.presentMode(presentMode);
        this.clipped(clipped);
        this.oldSwapchain(oldSwapchain);
        return this;
    }

    public VkSwapchainCreateInfoKHR set(VkSwapchainCreateInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkSwapchainCreateInfoKHR malloc() {
        return (VkSwapchainCreateInfoKHR)VkSwapchainCreateInfoKHR.wrap(VkSwapchainCreateInfoKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkSwapchainCreateInfoKHR calloc() {
        return (VkSwapchainCreateInfoKHR)VkSwapchainCreateInfoKHR.wrap(VkSwapchainCreateInfoKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkSwapchainCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkSwapchainCreateInfoKHR)VkSwapchainCreateInfoKHR.wrap(VkSwapchainCreateInfoKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkSwapchainCreateInfoKHR create(long address) {
        return (VkSwapchainCreateInfoKHR)VkSwapchainCreateInfoKHR.wrap(VkSwapchainCreateInfoKHR.class, (long)address);
    }

    @Nullable
    public static VkSwapchainCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : (VkSwapchainCreateInfoKHR)VkSwapchainCreateInfoKHR.wrap(VkSwapchainCreateInfoKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkSwapchainCreateInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkSwapchainCreateInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkSwapchainCreateInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSwapchainCreateInfoKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkSwapchainCreateInfoKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkSwapchainCreateInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkSwapchainCreateInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkSwapchainCreateInfoKHR mallocStack() {
        return VkSwapchainCreateInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkSwapchainCreateInfoKHR callocStack() {
        return VkSwapchainCreateInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkSwapchainCreateInfoKHR mallocStack(MemoryStack stack) {
        return (VkSwapchainCreateInfoKHR)VkSwapchainCreateInfoKHR.wrap(VkSwapchainCreateInfoKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSwapchainCreateInfoKHR callocStack(MemoryStack stack) {
        return (VkSwapchainCreateInfoKHR)VkSwapchainCreateInfoKHR.wrap(VkSwapchainCreateInfoKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSwapchainCreateInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSwapchainCreateInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSwapchainCreateInfoKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSwapchainCreateInfoKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static long nsurface(long struct) {
        return UNSAFE.getLong(null, struct + (long)SURFACE);
    }

    public static int nminImageCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)MINIMAGECOUNT);
    }

    public static int nimageFormat(long struct) {
        return UNSAFE.getInt(null, struct + (long)IMAGEFORMAT);
    }

    public static int nimageColorSpace(long struct) {
        return UNSAFE.getInt(null, struct + (long)IMAGECOLORSPACE);
    }

    public static VkExtent2D nimageExtent(long struct) {
        return VkExtent2D.create(struct + (long)IMAGEEXTENT);
    }

    public static int nimageArrayLayers(long struct) {
        return UNSAFE.getInt(null, struct + (long)IMAGEARRAYLAYERS);
    }

    public static int nimageUsage(long struct) {
        return UNSAFE.getInt(null, struct + (long)IMAGEUSAGE);
    }

    public static int nimageSharingMode(long struct) {
        return UNSAFE.getInt(null, struct + (long)IMAGESHARINGMODE);
    }

    public static int nqueueFamilyIndexCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)QUEUEFAMILYINDEXCOUNT);
    }

    @Nullable
    public static IntBuffer npQueueFamilyIndices(long struct) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PQUEUEFAMILYINDICES)), (int)VkSwapchainCreateInfoKHR.nqueueFamilyIndexCount(struct));
    }

    public static int npreTransform(long struct) {
        return UNSAFE.getInt(null, struct + (long)PRETRANSFORM);
    }

    public static int ncompositeAlpha(long struct) {
        return UNSAFE.getInt(null, struct + (long)COMPOSITEALPHA);
    }

    public static int npresentMode(long struct) {
        return UNSAFE.getInt(null, struct + (long)PRESENTMODE);
    }

    public static int nclipped(long struct) {
        return UNSAFE.getInt(null, struct + (long)CLIPPED);
    }

    public static long noldSwapchain(long struct) {
        return UNSAFE.getLong(null, struct + (long)OLDSWAPCHAIN);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nsurface(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SURFACE, value);
    }

    public static void nminImageCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MINIMAGECOUNT, value);
    }

    public static void nimageFormat(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)IMAGEFORMAT, value);
    }

    public static void nimageColorSpace(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)IMAGECOLORSPACE, value);
    }

    public static void nimageExtent(long struct, VkExtent2D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)IMAGEEXTENT), (long)VkExtent2D.SIZEOF);
    }

    public static void nimageArrayLayers(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)IMAGEARRAYLAYERS, value);
    }

    public static void nimageUsage(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)IMAGEUSAGE, value);
    }

    public static void nimageSharingMode(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)IMAGESHARINGMODE, value);
    }

    public static void nqueueFamilyIndexCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)QUEUEFAMILYINDEXCOUNT, value);
    }

    public static void npQueueFamilyIndices(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PQUEUEFAMILYINDICES), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
        VkSwapchainCreateInfoKHR.nqueueFamilyIndexCount(struct, value == null ? 0 : value.remaining());
    }

    public static void npreTransform(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PRETRANSFORM, value);
    }

    public static void ncompositeAlpha(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COMPOSITEALPHA, value);
    }

    public static void npresentMode(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PRESENTMODE, value);
    }

    public static void nclipped(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CLIPPED, value);
    }

    public static void noldSwapchain(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)OLDSWAPCHAIN, value);
    }

    public static void validate(long struct) {
        if (VkSwapchainCreateInfoKHR.nqueueFamilyIndexCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PQUEUEFAMILYINDICES)));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkSwapchainCreateInfoKHR.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VkSwapchainCreateInfoKHR.__struct((Struct.Member[])new Struct.Member[]{VkSwapchainCreateInfoKHR.__member((int)4), VkSwapchainCreateInfoKHR.__member((int)POINTER_SIZE), VkSwapchainCreateInfoKHR.__member((int)4), VkSwapchainCreateInfoKHR.__member((int)8), VkSwapchainCreateInfoKHR.__member((int)4), VkSwapchainCreateInfoKHR.__member((int)4), VkSwapchainCreateInfoKHR.__member((int)4), VkSwapchainCreateInfoKHR.__member((int)VkExtent2D.SIZEOF, (int)VkExtent2D.ALIGNOF), VkSwapchainCreateInfoKHR.__member((int)4), VkSwapchainCreateInfoKHR.__member((int)4), VkSwapchainCreateInfoKHR.__member((int)4), VkSwapchainCreateInfoKHR.__member((int)4), VkSwapchainCreateInfoKHR.__member((int)POINTER_SIZE), VkSwapchainCreateInfoKHR.__member((int)4), VkSwapchainCreateInfoKHR.__member((int)4), VkSwapchainCreateInfoKHR.__member((int)4), VkSwapchainCreateInfoKHR.__member((int)4), VkSwapchainCreateInfoKHR.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        SURFACE = layout.offsetof(3);
        MINIMAGECOUNT = layout.offsetof(4);
        IMAGEFORMAT = layout.offsetof(5);
        IMAGECOLORSPACE = layout.offsetof(6);
        IMAGEEXTENT = layout.offsetof(7);
        IMAGEARRAYLAYERS = layout.offsetof(8);
        IMAGEUSAGE = layout.offsetof(9);
        IMAGESHARINGMODE = layout.offsetof(10);
        QUEUEFAMILYINDEXCOUNT = layout.offsetof(11);
        PQUEUEFAMILYINDICES = layout.offsetof(12);
        PRETRANSFORM = layout.offsetof(13);
        COMPOSITEALPHA = layout.offsetof(14);
        PRESENTMODE = layout.offsetof(15);
        CLIPPED = layout.offsetof(16);
        OLDSWAPCHAIN = layout.offsetof(17);
    }

    public static class Buffer
    extends StructBuffer<VkSwapchainCreateInfoKHR, Buffer>
    implements NativeResource {
        private static final VkSwapchainCreateInfoKHR ELEMENT_FACTORY = VkSwapchainCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkSwapchainCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkSwapchainCreateInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkSwapchainCreateInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkSwapchainCreateFlagsKHR")
        public int flags() {
            return VkSwapchainCreateInfoKHR.nflags(this.address());
        }

        @NativeType(value="VkSurfaceKHR")
        public long surface() {
            return VkSwapchainCreateInfoKHR.nsurface(this.address());
        }

        @NativeType(value="uint32_t")
        public int minImageCount() {
            return VkSwapchainCreateInfoKHR.nminImageCount(this.address());
        }

        @NativeType(value="VkFormat")
        public int imageFormat() {
            return VkSwapchainCreateInfoKHR.nimageFormat(this.address());
        }

        @NativeType(value="VkColorSpaceKHR")
        public int imageColorSpace() {
            return VkSwapchainCreateInfoKHR.nimageColorSpace(this.address());
        }

        public VkExtent2D imageExtent() {
            return VkSwapchainCreateInfoKHR.nimageExtent(this.address());
        }

        @NativeType(value="uint32_t")
        public int imageArrayLayers() {
            return VkSwapchainCreateInfoKHR.nimageArrayLayers(this.address());
        }

        @NativeType(value="VkImageUsageFlags")
        public int imageUsage() {
            return VkSwapchainCreateInfoKHR.nimageUsage(this.address());
        }

        @NativeType(value="VkSharingMode")
        public int imageSharingMode() {
            return VkSwapchainCreateInfoKHR.nimageSharingMode(this.address());
        }

        @NativeType(value="uint32_t")
        public int queueFamilyIndexCount() {
            return VkSwapchainCreateInfoKHR.nqueueFamilyIndexCount(this.address());
        }

        @Nullable
        @NativeType(value="uint32_t const *")
        public IntBuffer pQueueFamilyIndices() {
            return VkSwapchainCreateInfoKHR.npQueueFamilyIndices(this.address());
        }

        @NativeType(value="VkSurfaceTransformFlagBitsKHR")
        public int preTransform() {
            return VkSwapchainCreateInfoKHR.npreTransform(this.address());
        }

        @NativeType(value="VkCompositeAlphaFlagBitsKHR")
        public int compositeAlpha() {
            return VkSwapchainCreateInfoKHR.ncompositeAlpha(this.address());
        }

        @NativeType(value="VkPresentModeKHR")
        public int presentMode() {
            return VkSwapchainCreateInfoKHR.npresentMode(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean clipped() {
            return VkSwapchainCreateInfoKHR.nclipped(this.address()) != 0;
        }

        @NativeType(value="VkSwapchainKHR")
        public long oldSwapchain() {
            return VkSwapchainCreateInfoKHR.noldSwapchain(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSwapchainCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkSwapchainCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkSwapchainCreateFlagsKHR") int value) {
            VkSwapchainCreateInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer surface(@NativeType(value="VkSurfaceKHR") long value) {
            VkSwapchainCreateInfoKHR.nsurface(this.address(), value);
            return this;
        }

        public Buffer minImageCount(@NativeType(value="uint32_t") int value) {
            VkSwapchainCreateInfoKHR.nminImageCount(this.address(), value);
            return this;
        }

        public Buffer imageFormat(@NativeType(value="VkFormat") int value) {
            VkSwapchainCreateInfoKHR.nimageFormat(this.address(), value);
            return this;
        }

        public Buffer imageColorSpace(@NativeType(value="VkColorSpaceKHR") int value) {
            VkSwapchainCreateInfoKHR.nimageColorSpace(this.address(), value);
            return this;
        }

        public Buffer imageExtent(VkExtent2D value) {
            VkSwapchainCreateInfoKHR.nimageExtent(this.address(), value);
            return this;
        }

        public Buffer imageExtent(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.imageExtent());
            return this;
        }

        public Buffer imageArrayLayers(@NativeType(value="uint32_t") int value) {
            VkSwapchainCreateInfoKHR.nimageArrayLayers(this.address(), value);
            return this;
        }

        public Buffer imageUsage(@NativeType(value="VkImageUsageFlags") int value) {
            VkSwapchainCreateInfoKHR.nimageUsage(this.address(), value);
            return this;
        }

        public Buffer imageSharingMode(@NativeType(value="VkSharingMode") int value) {
            VkSwapchainCreateInfoKHR.nimageSharingMode(this.address(), value);
            return this;
        }

        public Buffer pQueueFamilyIndices(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
            VkSwapchainCreateInfoKHR.npQueueFamilyIndices(this.address(), value);
            return this;
        }

        public Buffer preTransform(@NativeType(value="VkSurfaceTransformFlagBitsKHR") int value) {
            VkSwapchainCreateInfoKHR.npreTransform(this.address(), value);
            return this;
        }

        public Buffer compositeAlpha(@NativeType(value="VkCompositeAlphaFlagBitsKHR") int value) {
            VkSwapchainCreateInfoKHR.ncompositeAlpha(this.address(), value);
            return this;
        }

        public Buffer presentMode(@NativeType(value="VkPresentModeKHR") int value) {
            VkSwapchainCreateInfoKHR.npresentMode(this.address(), value);
            return this;
        }

        public Buffer clipped(@NativeType(value="VkBool32") boolean value) {
            VkSwapchainCreateInfoKHR.nclipped(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer oldSwapchain(@NativeType(value="VkSwapchainKHR") long value) {
            VkSwapchainCreateInfoKHR.noldSwapchain(this.address(), value);
            return this;
        }
    }
}

