/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.mpxj.mpp.FixDeferFix;
import net.sf.mpxj.mpp.MPPUtility;

final class ExtendedData {
    private FixDeferFix m_data;
    private HashMap<Integer, byte[]> m_map = new HashMap();

    ExtendedData(FixDeferFix fixDeferFix, int n) {
        this.m_data = fixDeferFix;
        byte[] byArray = fixDeferFix.getByteArray(n);
        if (byArray != null) {
            int n2;
            for (int i = 0; i < byArray.length; i += n2) {
                n2 = MPPUtility.getInt(byArray, i);
                int n3 = MPPUtility.getInt(byArray, i += 4);
                this.m_map.put(n3, MPPUtility.cloneSubArray(byArray, i += 4, n2));
            }
        }
    }

    public String getString(Integer n) {
        String string = null;
        byte[] byArray = this.m_map.get(n);
        if (byArray != null) {
            string = this.m_data.getString(this.getOffset(byArray));
        }
        return string;
    }

    public String getUnicodeString(Integer n) {
        String string = null;
        byte[] byArray = this.m_map.get(n);
        if (byArray != null) {
            string = this.m_data.getUnicodeString(this.getOffset(byArray));
        }
        return string;
    }

    public int getShort(Integer n) {
        int n2 = 0;
        byte[] byArray = this.m_map.get(n);
        if (byArray != null) {
            n2 = MPPUtility.getShort(byArray, 0);
        }
        return n2;
    }

    public int getInt(Integer n) {
        int n2 = 0;
        byte[] byArray = this.m_map.get(n);
        if (byArray != null) {
            n2 = MPPUtility.getInt(byArray, 0);
        }
        return n2;
    }

    public long getLong(Integer n) {
        long l = 0L;
        byte[] byArray = this.m_map.get(n);
        if (byArray != null) {
            l = MPPUtility.getLong6(byArray, 0);
        }
        return l;
    }

    public double getDouble(Integer n) {
        double d = 0.0;
        byte[] byArray = this.m_map.get(n);
        if (byArray != null) {
            d = MPPUtility.getDouble(byArray, 0);
        }
        return d;
    }

    public Date getTimestamp(Integer n) {
        Date date = null;
        byte[] byArray = this.m_map.get(n);
        if (byArray != null) {
            date = MPPUtility.getTimestamp(byArray, 0);
        }
        return date;
    }

    public byte[] getByteArray(Integer n) {
        return this.m_map.get(n);
    }

    private int getOffset(byte[] byArray) {
        return -1 - MPPUtility.getInt(byArray, 0);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("BEGIN ExtendedData");
        for (Map.Entry<Integer, byte[]> entry : this.m_map.entrySet()) {
            printWriter.println("Type: " + entry.getKey() + " Data:" + MPPUtility.hexdump(entry.getValue(), false));
        }
        printWriter.println("END ExtendedData");
        printWriter.println();
        printWriter.close();
        return stringWriter.toString();
    }
}

