/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.util.Pair;
import org.apache.solr.handler.sql.SolrAggregate;
import org.apache.solr.handler.sql.SolrTable;

interface SolrRel
extends RelNode {
    public static final Convention CONVENTION = new Convention.Impl("Solr", SolrRel.class);

    public void implement(Implementor var1);

    public static class Implementor {
        final Map<String, String> fieldMappings = new HashMap<String, String>();
        final Map<String, String> reverseAggMappings = new HashMap<String, String>();
        String query = null;
        String havingPredicate;
        boolean negativeQuery;
        String limitValue = null;
        String offsetValue = null;
        final List<Pair<String, String>> orders = new ArrayList<Pair<String, String>>();
        final List<String> buckets = new ArrayList<String>();
        final List<Pair<String, String>> metricPairs = new ArrayList<Pair<String, String>>();
        RelOptTable table;
        SolrTable solrTable;

        void addFieldMapping(String key, String val, boolean overwrite) {
            if (key != null && (overwrite || !this.fieldMappings.containsKey(key))) {
                this.fieldMappings.put(key, val);
            }
        }

        void addReverseAggMapping(String key, String val) {
            if (key != null && !this.reverseAggMappings.containsKey(key)) {
                this.reverseAggMappings.put(key, val);
            }
        }

        void addQuery(String query) {
            this.query = query;
        }

        void setNegativeQuery(boolean negativeQuery) {
            this.negativeQuery = negativeQuery;
        }

        void addOrder(String column, String direction) {
            column = this.fieldMappings.getOrDefault(column, column);
            this.orders.add((Pair<String, String>)new Pair((Object)column, (Object)direction));
        }

        void addBucket(String bucket) {
            bucket = this.fieldMappings.getOrDefault(bucket, bucket);
            this.buckets.add(bucket);
        }

        void addMetricPair(String outName, String metric, String column) {
            column = this.fieldMappings.getOrDefault(column, column);
            this.metricPairs.add((Pair<String, String>)new Pair((Object)metric, (Object)column));
            if (outName != null) {
                this.addFieldMapping(outName, SolrAggregate.solrAggMetricId(metric, column), true);
            }
        }

        void setHavingPredicate(String havingPredicate) {
            this.havingPredicate = havingPredicate;
        }

        void setLimit(String limit) {
            this.limitValue = limit;
        }

        void setOffset(String offset) {
            this.offsetValue = offset;
        }

        void visitChild(int ordinal, RelNode input) {
            assert (ordinal == 0);
            ((SolrRel)input).implement(this);
        }
    }
}

