/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record.layer;

import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.exceptions.ParserException;
import de.rub.nds.tlsattacker.core.exceptions.PreparationException;
import de.rub.nds.tlsattacker.core.protocol.parser.cert.CleanRecordByteSeperator;
import de.rub.nds.tlsattacker.core.record.AbstractRecord;
import de.rub.nds.tlsattacker.core.record.BlobRecord;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipher;
import de.rub.nds.tlsattacker.core.record.cipher.RecordNullCipher;
import de.rub.nds.tlsattacker.core.record.compressor.RecordCompressor;
import de.rub.nds.tlsattacker.core.record.compressor.RecordDecompressor;
import de.rub.nds.tlsattacker.core.record.crypto.Decryptor;
import de.rub.nds.tlsattacker.core.record.crypto.Encryptor;
import de.rub.nds.tlsattacker.core.record.crypto.RecordDecryptor;
import de.rub.nds.tlsattacker.core.record.crypto.RecordEncryptor;
import de.rub.nds.tlsattacker.core.record.layer.RecordLayer;
import de.rub.nds.tlsattacker.core.record.parser.BlobRecordParser;
import de.rub.nds.tlsattacker.core.record.parser.RecordParser;
import de.rub.nds.tlsattacker.core.record.preparator.AbstractRecordPreparator;
import de.rub.nds.tlsattacker.core.record.serializer.AbstractRecordSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TlsRecordLayer
extends RecordLayer {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final TlsContext tlsContext;
    private final Decryptor decryptor;
    private final Encryptor encryptor;
    private RecordCompressor compressor;
    private RecordDecompressor decompressor;
    private RecordCipher cipher;

    public TlsRecordLayer(TlsContext tlsContext) {
        this.tlsContext = tlsContext;
        this.cipher = new RecordNullCipher(tlsContext);
        this.encryptor = new RecordEncryptor(this.cipher, tlsContext);
        this.decryptor = new RecordDecryptor(this.cipher, tlsContext);
        this.compressor = new RecordCompressor(tlsContext);
        this.decompressor = new RecordDecompressor(tlsContext);
    }

    @Override
    public void updateCompressor() {
        this.compressor.setMethod(this.tlsContext.getChooser().getSelectedCompressionMethod());
    }

    @Override
    public void updateDecompressor() {
        this.decompressor.setMethod(this.tlsContext.getChooser().getSelectedCompressionMethod());
    }

    @Override
    public List<AbstractRecord> parseRecords(byte[] rawRecordData) {
        LinkedList<AbstractRecord> records = new LinkedList<AbstractRecord>();
        int dataPointer = 0;
        while (dataPointer != rawRecordData.length) {
            try {
                RecordParser parser = new RecordParser(dataPointer, rawRecordData, this.tlsContext.getChooser().getSelectedProtocolVersion());
                Record record = parser.parse();
                records.add(record);
                if (dataPointer == parser.getPointer()) {
                    throw new ParserException("Ran into infinite Loop while parsing HttpsHeader");
                }
                dataPointer = parser.getPointer();
            }
            catch (ParserException E) {
                throw new ParserException("Could not parse provided Data as Record", E);
            }
        }
        LOGGER.debug("The protocol message(s) were collected from {} record(s). ", (Object)records.size());
        return records;
    }

    @Override
    public List<AbstractRecord> parseRecordsSoftly(byte[] rawRecordData) {
        LinkedList<AbstractRecord> records = new LinkedList<AbstractRecord>();
        int dataPointer = 0;
        while (dataPointer != rawRecordData.length) {
            try {
                RecordParser parser = new RecordParser(dataPointer, rawRecordData, this.tlsContext.getChooser().getSelectedProtocolVersion());
                Record record = parser.parse();
                records.add(record);
                if (dataPointer == parser.getPointer()) {
                    throw new ParserException("Ran into infinite Loop while parsing Records");
                }
                dataPointer = parser.getPointer();
            }
            catch (ParserException E) {
                LOGGER.debug("Could not parse Record, parsing as Blob");
                LOGGER.trace((Object)E);
                BlobRecordParser blobParser = new BlobRecordParser(dataPointer, rawRecordData, this.tlsContext.getChooser().getSelectedProtocolVersion());
                BlobRecord record = blobParser.parse();
                records.add(record);
                if (dataPointer == blobParser.getPointer()) {
                    throw new ParserException("Ran into infinite Loop while parsing BlobRecords");
                }
                dataPointer = blobParser.getPointer();
            }
        }
        LOGGER.debug("The protocol message(s) were collected from {} record(s). ", (Object)records.size());
        return records;
    }

    @Override
    public byte[] prepareRecords(byte[] data, ProtocolMessageType contentType, List<AbstractRecord> records) {
        CleanRecordByteSeperator seperator = new CleanRecordByteSeperator((List<AbstractRecord>)records, this.tlsContext.getConfig().getDefaultMaxRecordData(), 0, data);
        records = seperator.parse();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        boolean useRecordType = false;
        if (contentType == null) {
            useRecordType = true;
        }
        Iterator iterator = records.iterator();
        while (iterator.hasNext()) {
            AbstractRecord record = (AbstractRecord)iterator.next();
            if (useRecordType) {
                contentType = record.getContentMessageType();
            }
            AbstractRecordPreparator preparator = record.getRecordPreparator(this.tlsContext.getChooser(), this.encryptor, this.compressor, contentType);
            preparator.prepare();
            AbstractRecordSerializer serializer = record.getRecordSerializer();
            try {
                byte[] recordBytes = serializer.serialize();
                record.setCompleteRecordBytes(recordBytes);
                stream.write((byte[])record.getCompleteRecordBytes().getValue());
            }
            catch (IOException ex) {
                throw new PreparationException("Could not write Record bytes to ByteArrayStream", ex);
            }
        }
        return stream.toByteArray();
    }

    @Override
    public void setRecordCipher(RecordCipher cipher) {
        this.cipher = cipher;
    }

    public RecordCipher getRecordCipher() {
        return this.cipher;
    }

    @Override
    public void updateEncryptionCipher() {
        this.encryptor.addNewRecordCipher(this.cipher);
    }

    @Override
    public void updateDecryptionCipher() {
        this.decryptor.addNewRecordCipher(this.cipher);
    }

    @Override
    public void decryptAndDecompressRecord(AbstractRecord record) {
        if (record instanceof Record) {
            if (!this.tlsContext.getChooser().getSelectedProtocolVersion().isTLS13() || this.tlsContext.getChooser().getSelectedProtocolVersion().isTLS13() && record.getContentMessageType() == ProtocolMessageType.APPLICATION_DATA) {
                this.decryptor.decrypt(record);
                this.decompressor.decompress(record);
            } else {
                record.prepareComputations();
                ((Record)record).setSequenceNumber(BigInteger.valueOf(this.tlsContext.getReadSequenceNumber()));
                byte[] protocolMessageBytes = (byte[])record.getProtocolMessageBytes().getValue();
                record.setCleanProtocolMessageBytes(protocolMessageBytes);
            }
        } else {
            LOGGER.warn("Decrypting received non Record:" + record.toString());
            this.decryptor.decrypt(record);
            this.decompressor.decompress(record);
        }
    }

    @Override
    public AbstractRecord getFreshRecord() {
        return new Record(this.tlsContext.getConfig());
    }

    @Override
    public RecordCipher getEncryptorCipher() {
        return this.encryptor.getRecordMostRecentCipher();
    }

    @Override
    public RecordCipher getDecryptorCipher() {
        return this.decryptor.getRecordMostRecentCipher();
    }
}

