/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.gax.rpc.ApiException;
import io.opencensus.contrib.grpc.util.StatusConverter;
import io.opencensus.trace.EndSpanOptions;
import io.opencensus.trace.Span;
import io.opencensus.trace.Status;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;

final class TraceUtil {
    private final Tracer tracer = Tracing.getTracer();
    private static final TraceUtil traceUtil = new TraceUtil();
    static final String SPAN_NAME_GETDOCUMENT = "CloudFirestoreOperation.GetDocument";
    static final String SPAN_NAME_CREATEDOCUMENT = "CloudFirestoreOperation.CreateDocument";
    static final String SPAN_NAME_UPDATEDOCUMENT = "CloudFirestoreOperation.UpdateDocument";
    static final String SPAN_NAME_DELETEDOCUMENT = "CloudFirestoreOperation.DeleteDocument";
    static final String SPAN_NAME_LISTCOLLECTIONIDS = "CloudFirestoreOperation.ListCollectionIds";
    static final String SPAN_NAME_LISTDOCUMENTS = "CloudFirestoreOperation.ListDocuments";
    static final String SPAN_NAME_BEGINTRANSACTION = "CloudFirestoreOperation.BeginTransaction";
    static final String SPAN_NAME_COMMIT = "CloudFirestoreOperation.Commit";
    static final String SPAN_NAME_ROLLBACK = "CloudFirestoreOperation.Rollback";
    static final String SPAN_NAME_RUNQUERY = "CloudFirestoreOperation.RunQuery";
    static final String SPAN_NAME_PARTITIONQUERY = "CloudFirestoreOperation.partitionQuery";
    static final String SPAN_NAME_LISTEN = "CloudFirestoreOperation.Listen";
    static final String SPAN_NAME_BATCHGETDOCUMENTS = "CloudFirestoreOperation.BatchGetDocuments";
    static final String SPAN_NAME_BATCHWRITE = "CloudFirestoreOperation.BatchWrite";
    static final String SPAN_NAME_WRITE = "CloudFirestoreOperation.Write";
    static final EndSpanOptions END_SPAN_OPTIONS = EndSpanOptions.builder().setSampleToLocalSpanStore(true).build();

    protected Span startSpan(String spanName) {
        return this.tracer.spanBuilder(spanName).startSpan();
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public static TraceUtil getInstance() {
        return traceUtil;
    }

    private TraceUtil() {
    }

    public static Status statusFromApiException(ApiException exception) {
        if (exception.getStatusCode().getTransportCode() instanceof io.grpc.Status) {
            io.grpc.Status grpcStatus = (io.grpc.Status)exception.getStatusCode().getTransportCode();
            return StatusConverter.fromGrpcStatus((io.grpc.Status)grpcStatus);
        }
        return Status.UNKNOWN.withDescription(exception.getMessage());
    }
}

