/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen.asm;

import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.classgen.asm.OptimizingStatementWriter;
import org.codehaus.groovy.classgen.asm.TypeChooser;

public class StatementMetaTypeChooser
implements TypeChooser {
    @Override
    public ClassNode resolveType(Expression exp, ClassNode current) {
        ClassNode type = null;
        if (exp instanceof ClassExpression) {
            type = exp.getType();
            ClassNode classType = ClassHelper.makeWithoutCaching("java.lang.Class");
            classType.setGenericsTypes(new GenericsType[]{new GenericsType(type)});
            classType.setRedirect(ClassHelper.CLASS_Type);
            return classType;
        }
        OptimizingStatementWriter.StatementMeta meta = (OptimizingStatementWriter.StatementMeta)exp.getNodeMetaData(OptimizingStatementWriter.StatementMeta.class);
        if (meta != null) {
            type = meta.type;
        }
        if (type != null) {
            return type;
        }
        if (exp instanceof VariableExpression) {
            VariableExpression ve = (VariableExpression)exp;
            if (ve.isClosureSharedVariable()) {
                return ve.getType();
            }
            if (ve.isSuperExpression()) {
                return current.getSuperClass();
            }
            type = ve.getOriginType();
        } else if (exp instanceof Variable) {
            Variable v = (Variable)((Object)exp);
            type = v.getOriginType();
        } else {
            type = exp.getType();
        }
        return type.redirect();
    }
}

