/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.helper;

import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.traccar.helper.DateBuilder;

public class Parser {
    private int position;
    private final Matcher matcher;

    public Parser(Pattern pattern, String input) {
        this.matcher = pattern.matcher(input);
    }

    public boolean matches() {
        this.position = 1;
        return this.matcher.matches();
    }

    public boolean find() {
        this.position = 1;
        return this.matcher.find();
    }

    public void skip(int number) {
        this.position += number;
    }

    public boolean hasNext() {
        return this.hasNext(1);
    }

    public boolean hasNext(int number) {
        for (int i = this.position; i < this.position + number; ++i) {
            String value = this.matcher.group(i);
            if (value == null || value.isEmpty()) continue;
            return true;
        }
        this.position += number;
        return false;
    }

    public String next() {
        return this.matcher.group(this.position++);
    }

    public Integer nextInt() {
        if (this.hasNext()) {
            return Integer.parseInt(this.next());
        }
        return null;
    }

    public int nextInt(int defaultValue) {
        if (this.hasNext()) {
            return Integer.parseInt(this.next());
        }
        return defaultValue;
    }

    public Integer nextHexInt() {
        if (this.hasNext()) {
            return Integer.parseInt(this.next(), 16);
        }
        return null;
    }

    public int nextHexInt(int defaultValue) {
        if (this.hasNext()) {
            return Integer.parseInt(this.next(), 16);
        }
        return defaultValue;
    }

    public Integer nextBinInt() {
        if (this.hasNext()) {
            return Integer.parseInt(this.next(), 2);
        }
        return null;
    }

    public int nextBinInt(int defaultValue) {
        if (this.hasNext()) {
            return Integer.parseInt(this.next(), 2);
        }
        return defaultValue;
    }

    public Long nextLong() {
        if (this.hasNext()) {
            return Long.parseLong(this.next());
        }
        return null;
    }

    public Long nextHexLong() {
        if (this.hasNext()) {
            return Long.parseLong(this.next(), 16);
        }
        return null;
    }

    public long nextLong(long defaultValue) {
        return this.nextLong(10, defaultValue);
    }

    public long nextLong(int radix, long defaultValue) {
        if (this.hasNext()) {
            return Long.parseLong(this.next(), radix);
        }
        return defaultValue;
    }

    public Double nextDouble() {
        if (this.hasNext()) {
            return Double.parseDouble(this.next());
        }
        return null;
    }

    public double nextDouble(double defaultValue) {
        if (this.hasNext()) {
            return Double.parseDouble(this.next());
        }
        return defaultValue;
    }

    public double nextCoordinate(CoordinateFormat format) {
        double coordinate;
        String hemisphere = null;
        switch (format) {
            case DEG_DEG: {
                coordinate = Double.parseDouble(this.next() + "." + this.next());
                break;
            }
            case DEG_DEG_HEM: {
                coordinate = Double.parseDouble(this.next() + "." + this.next());
                hemisphere = this.next();
                break;
            }
            case DEG_HEM: {
                coordinate = this.nextDouble(0.0);
                hemisphere = this.next();
                break;
            }
            case DEG_MIN_MIN: {
                coordinate = this.nextInt(0);
                coordinate += Double.parseDouble(this.next() + "." + this.next()) / 60.0;
                break;
            }
            case DEG_MIN_MIN_HEM: {
                coordinate = this.nextInt(0);
                coordinate += Double.parseDouble(this.next() + "." + this.next()) / 60.0;
                hemisphere = this.next();
                break;
            }
            case HEM_DEG: {
                hemisphere = this.next();
                coordinate = this.nextDouble(0.0);
                break;
            }
            case HEM_DEG_MIN: {
                hemisphere = this.next();
                coordinate = this.nextInt(0);
                coordinate += this.nextDouble(0.0) / 60.0;
                break;
            }
            case HEM_DEG_MIN_HEM: {
                hemisphere = this.next();
                coordinate = this.nextInt(0);
                coordinate += this.nextDouble(0.0) / 60.0;
                if (!this.hasNext()) break;
                hemisphere = this.next();
                break;
            }
            case HEM_DEG_MIN_MIN: {
                hemisphere = this.next();
                coordinate = this.nextInt(0);
                coordinate += Double.parseDouble(this.next() + "." + this.next()) / 60.0;
                break;
            }
            default: {
                coordinate = this.nextInt(0);
                coordinate += this.nextDouble(0.0) / 60.0;
                hemisphere = this.next();
            }
        }
        if (hemisphere != null && (hemisphere.equals("S") || hemisphere.equals("W") || hemisphere.equals("-"))) {
            coordinate = -Math.abs(coordinate);
        }
        return coordinate;
    }

    public double nextCoordinate() {
        return this.nextCoordinate(CoordinateFormat.DEG_MIN_HEM);
    }

    public Date nextDateTime(DateTimeFormat format, String timeZone) {
        DateBuilder dateBuilder;
        int second;
        int minute;
        int hour;
        int year = 0;
        int month = 0;
        int day = 0;
        int millisecond = 0;
        switch (format) {
            case HMS: {
                hour = this.nextInt(0);
                minute = this.nextInt(0);
                second = this.nextInt(0);
                break;
            }
            case SMH: {
                second = this.nextInt(0);
                minute = this.nextInt(0);
                hour = this.nextInt(0);
                break;
            }
            case HMS_YMD: {
                hour = this.nextInt(0);
                minute = this.nextInt(0);
                second = this.nextInt(0);
                year = this.nextInt(0);
                month = this.nextInt(0);
                day = this.nextInt(0);
                break;
            }
            case HMS_DMY: {
                hour = this.nextInt(0);
                minute = this.nextInt(0);
                second = this.nextInt(0);
                day = this.nextInt(0);
                month = this.nextInt(0);
                year = this.nextInt(0);
                break;
            }
            case SMH_YMD: {
                second = this.nextInt(0);
                minute = this.nextInt(0);
                hour = this.nextInt(0);
                year = this.nextInt(0);
                month = this.nextInt(0);
                day = this.nextInt(0);
                break;
            }
            case SMH_DMY: {
                second = this.nextInt(0);
                minute = this.nextInt(0);
                hour = this.nextInt(0);
                day = this.nextInt(0);
                month = this.nextInt(0);
                year = this.nextInt(0);
                break;
            }
            case DMY_HMS: 
            case DMY_HMSS: {
                day = this.nextInt(0);
                month = this.nextInt(0);
                year = this.nextInt(0);
                hour = this.nextInt(0);
                minute = this.nextInt(0);
                second = this.nextInt(0);
                break;
            }
            default: {
                year = this.nextInt(0);
                month = this.nextInt(0);
                day = this.nextInt(0);
                hour = this.nextInt(0);
                minute = this.nextInt(0);
                second = this.nextInt(0);
            }
        }
        if (format == DateTimeFormat.YMD_HMSS || format == DateTimeFormat.DMY_HMSS) {
            millisecond = this.nextInt(0);
        }
        if (year >= 0 && year < 100) {
            year += 2000;
        }
        if (format != DateTimeFormat.HMS && format != DateTimeFormat.SMH) {
            dateBuilder = timeZone != null ? new DateBuilder(TimeZone.getTimeZone(timeZone)) : new DateBuilder();
            dateBuilder.setDate(year, month, day);
        } else {
            dateBuilder = timeZone != null ? new DateBuilder(new Date(), TimeZone.getTimeZone(timeZone)) : new DateBuilder(new Date());
        }
        dateBuilder.setTime(hour, minute, second, millisecond);
        return dateBuilder.getDate();
    }

    public Date nextDateTime(DateTimeFormat format) {
        return this.nextDateTime(format, null);
    }

    public Date nextDateTime() {
        return this.nextDateTime(DateTimeFormat.YMD_HMS, null);
    }

    public static enum DateTimeFormat {
        HMS,
        SMH,
        HMS_YMD,
        HMS_DMY,
        SMH_YMD,
        SMH_DMY,
        DMY_HMS,
        DMY_HMSS,
        YMD_HMS,
        YMD_HMSS;

    }

    public static enum CoordinateFormat {
        DEG_DEG,
        DEG_DEG_HEM,
        DEG_HEM,
        DEG_MIN_MIN,
        DEG_MIN_HEM,
        DEG_MIN_MIN_HEM,
        HEM_DEG_MIN_MIN,
        HEM_DEG,
        HEM_DEG_MIN,
        HEM_DEG_MIN_HEM;

    }
}

