/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.traccar.model.BaseModel;

public class ExtendedModel
extends BaseModel {
    private Map<String, Object> attributes = new LinkedHashMap<String, Object>();

    public boolean hasAttribute(String key) {
        return this.attributes.containsKey(key);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public void set(String key, Boolean value) {
        if (value != null) {
            this.attributes.put(key, value);
        }
    }

    public void set(String key, Byte value) {
        if (value != null) {
            this.attributes.put(key, value.intValue());
        }
    }

    public void set(String key, Short value) {
        if (value != null) {
            this.attributes.put(key, value.intValue());
        }
    }

    public void set(String key, Integer value) {
        if (value != null) {
            this.attributes.put(key, value);
        }
    }

    public void set(String key, Long value) {
        if (value != null) {
            this.attributes.put(key, value);
        }
    }

    public void set(String key, Float value) {
        if (value != null) {
            this.attributes.put(key, value.doubleValue());
        }
    }

    public void set(String key, Double value) {
        if (value != null) {
            this.attributes.put(key, value);
        }
    }

    public void set(String key, String value) {
        if (value != null && !value.isEmpty()) {
            this.attributes.put(key, value);
        }
    }

    public void add(Map.Entry<String, Object> entry) {
        if (entry != null && entry.getValue() != null) {
            this.attributes.put(entry.getKey(), entry.getValue());
        }
    }

    public String getString(String key) {
        if (this.attributes.containsKey(key)) {
            return (String)this.attributes.get(key);
        }
        return null;
    }

    public double getDouble(String key) {
        if (this.attributes.containsKey(key)) {
            return ((Number)this.attributes.get(key)).doubleValue();
        }
        return 0.0;
    }

    public boolean getBoolean(String key) {
        if (this.attributes.containsKey(key)) {
            return (Boolean)this.attributes.get(key);
        }
        return false;
    }

    public int getInteger(String key) {
        if (this.attributes.containsKey(key)) {
            return ((Number)this.attributes.get(key)).intValue();
        }
        return 0;
    }

    public long getLong(String key) {
        if (this.attributes.containsKey(key)) {
            return ((Number)this.attributes.get(key)).longValue();
        }
        return 0L;
    }
}

