/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.notification;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.model.Device;
import org.traccar.model.Event;
import org.traccar.model.Geofence;
import org.traccar.model.Maintenance;
import org.traccar.model.Position;
import org.traccar.session.cache.CacheManager;

public class EventForwarder {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventForwarder.class);
    private final String url;
    private final String header;
    private final Client client;
    private final CacheManager cacheManager;
    private static final String KEY_POSITION = "position";
    private static final String KEY_EVENT = "event";
    private static final String KEY_GEOFENCE = "geofence";
    private static final String KEY_DEVICE = "device";
    private static final String KEY_MAINTENANCE = "maintenance";

    public EventForwarder(Config config, Client client, CacheManager cacheManager) {
        this.client = client;
        this.cacheManager = cacheManager;
        this.url = config.getString(Keys.EVENT_FORWARD_URL);
        this.header = config.getString(Keys.EVENT_FORWARD_HEADERS);
    }

    public final void forwardEvent(Event event, Position position) {
        Invocation.Builder requestBuilder = this.client.target(this.url).request();
        if (this.header != null && !this.header.isEmpty()) {
            for (String line : this.header.split("\\r?\\n")) {
                String[] values = line.split(":", 2);
                requestBuilder.header(values[0].trim(), (Object)values[1].trim());
            }
        }
        LOGGER.debug("Event forwarding initiated");
        requestBuilder.async().post(Entity.json(this.preparePayload(event, position)), (InvocationCallback)new InvocationCallback<Object>(){

            public void completed(Object o) {
                LOGGER.debug("Event forwarding succeeded");
            }

            public void failed(Throwable throwable) {
                LOGGER.warn("Event forwarding failed", throwable);
            }
        });
    }

    protected Map<String, Object> preparePayload(Event event, Position position) {
        Maintenance maintenance;
        Geofence geofence;
        Device device;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(KEY_EVENT, event);
        if (position != null) {
            data.put(KEY_POSITION, position);
        }
        if ((device = this.cacheManager.getObject(Device.class, event.getDeviceId())) != null) {
            data.put(KEY_DEVICE, device);
        }
        if (event.getGeofenceId() != 0L && (geofence = this.cacheManager.getObject(Geofence.class, event.getGeofenceId())) != null) {
            data.put(KEY_GEOFENCE, geofence);
        }
        if (event.getMaintenanceId() != 0L && (maintenance = this.cacheManager.getObject(Maintenance.class, event.getMaintenanceId())) != null) {
            data.put(KEY_MAINTENANCE, maintenance);
        }
        return data;
    }
}

