/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.config.Keys;
import org.traccar.helper.DataConverter;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class Xt2400ProtocolDecoder
extends BaseProtocolDecoder {
    private static final Map<Integer, Integer> TAG_LENGTH_MAP = new HashMap<Integer, Integer>();
    private final Map<Short, byte[]> formats = new HashMap<Short, byte[]>();

    public Xt2400ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected void init() {
        String config = this.getConfig().getString(Keys.PROTOCOL_CONFIG.withPrefix(this.getProtocolName()));
        if (config != null) {
            this.setConfig(config);
        }
    }

    private static int getTagLength(int tag) {
        Integer length = TAG_LENGTH_MAP.get(tag);
        if (length == null) {
            throw new IllegalArgumentException(String.format("Unknown tag: 0x%02X", tag));
        }
        return length;
    }

    public void setConfig(String configString) {
        Pattern pattern = Pattern.compile(":wycfg pcr\\[\\d+] ([0-9a-fA-F]{2})[0-9a-fA-F]{2}([0-9a-fA-F]+)");
        Matcher matcher = pattern.matcher(configString);
        while (matcher.find()) {
            this.formats.put(Short.parseShort(matcher.group(1), 16), DataConverter.parseHex(matcher.group(2)));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        byte[] format = null;
        if (this.formats.size() > 1) {
            format = this.formats.get(buf.getUnsignedByte(buf.readerIndex()));
        } else if (!this.formats.isEmpty()) {
            format = this.formats.values().iterator().next();
        }
        if (format == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        block21: for (byte b : format) {
            int tag = b & 0xFF;
            switch (tag) {
                case 3: {
                    DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, String.valueOf(buf.readUnsignedInt()));
                    if (deviceSession == null) {
                        return null;
                    }
                    position.setDeviceId(deviceSession.getDeviceId());
                    continue block21;
                }
                case 4: {
                    position.set("event", buf.readUnsignedByte());
                    continue block21;
                }
                case 5: {
                    position.set("index", buf.readUnsignedShort());
                    continue block21;
                }
                case 6: {
                    position.setTime(new Date(buf.readUnsignedInt() * 1000L));
                    continue block21;
                }
                case 7: {
                    position.setLatitude((double)buf.readInt() * 1.0E-6);
                    continue block21;
                }
                case 8: {
                    position.setLongitude((double)buf.readInt() * 1.0E-6);
                    continue block21;
                }
                case 9: {
                    position.setAltitude((double)buf.readShort() * 0.1);
                    continue block21;
                }
                case 10: {
                    position.setCourse((double)buf.readShort() * 0.1);
                    continue block21;
                }
                case 11: {
                    position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
                    continue block21;
                }
                case 16: {
                    position.set("tripOdometer", buf.readUnsignedInt());
                    continue block21;
                }
                case 18: {
                    position.set("hdop", (double)buf.readUnsignedByte() * 0.1);
                    continue block21;
                }
                case 19: {
                    position.set("sat", buf.readUnsignedByte());
                    continue block21;
                }
                case 20: {
                    position.set("rssi", buf.readShort());
                    continue block21;
                }
                case 22: {
                    position.set("battery", (double)buf.readUnsignedByte() * 0.1);
                    continue block21;
                }
                case 23: {
                    position.set("power", (double)buf.readUnsignedByte() * 0.1);
                    continue block21;
                }
                case 87: {
                    position.set("obdSpeed", UnitsConverter.knotsFromKph(buf.readUnsignedShort()));
                    continue block21;
                }
                case 101: {
                    position.set("vin", buf.readSlice(17).toString(StandardCharsets.US_ASCII));
                    continue block21;
                }
                case 108: {
                    buf.readUnsignedByte();
                    int ecuCount = buf.readUnsignedByte();
                    for (int i = 0; i < ecuCount; ++i) {
                        buf.readUnsignedByte();
                        buf.skipBytes(buf.readUnsignedByte() * 6);
                    }
                    continue block21;
                }
                case 115: {
                    position.set("versionFw", buf.readSlice(16).toString(StandardCharsets.US_ASCII).trim());
                    continue block21;
                }
                default: {
                    buf.skipBytes(Xt2400ProtocolDecoder.getTagLength(tag));
                }
            }
        }
        if (position.getLatitude() != 0.0 && position.getLongitude() != 0.0) {
            position.setValid(true);
        } else {
            this.getLastLocation(position, position.getDeviceTime());
        }
        return position;
    }

    static {
        int[] l1 = new int[]{1, 2, 4, 11, 12, 13, 18, 19, 22, 23, 28, 31, 35, 44, 45, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 64, 65, 83, 102, 105, 106, 147, 148, 150};
        int[] l2 = new int[]{5, 9, 10, 20, 21, 29, 30, 36, 38, 66, 67, 68, 69, 70, 71, 72, 73, 87, 88, 89, 90, 107, 111, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 200};
        int[] l4 = new int[]{3, 6, 7, 8, 14, 15, 16, 17, 24, 25, 26, 27, 32, 33, 34, 46, 47, 74, 75, 76, 77, 78, 79, 80, 81, 82, 84, 85, 86, 91, 92, 93, 94, 95, 96, 97, 98, 104, 110, 113, 114, 116, 117, 118, 119, 120, 121, 135, 136, 137, 138, 139, 140, 141};
        for (int i : l1) {
            TAG_LENGTH_MAP.put(i, 1);
        }
        for (int i : l2) {
            TAG_LENGTH_MAP.put(i, 2);
        }
        for (int i : l4) {
            TAG_LENGTH_MAP.put(i, 4);
        }
        TAG_LENGTH_MAP.put(149, 24);
        TAG_LENGTH_MAP.put(208, 21);
    }
}

