/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.BindableService;
import io.grpc.ExperimentalApi;
import io.grpc.xds.OrcaServiceImpl;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/9006")
public final class OrcaOobService {
    public static final long DEFAULT_MIN_REPORT_INTERVAL_NANOS = TimeUnit.SECONDS.toNanos(30L);
    private final OrcaServiceImpl orcaService;

    public OrcaOobService(long minInterval, TimeUnit timeUnit, ScheduledExecutorService timeService) {
        this.orcaService = new OrcaServiceImpl(minInterval > 0L ? timeUnit.toNanos(minInterval) : DEFAULT_MIN_REPORT_INTERVAL_NANOS, (ScheduledExecutorService)Preconditions.checkNotNull((Object)timeService));
    }

    public OrcaOobService(ScheduledExecutorService timeService) {
        this(DEFAULT_MIN_REPORT_INTERVAL_NANOS, TimeUnit.NANOSECONDS, timeService);
    }

    public BindableService getService() {
        return this.orcaService;
    }

    @VisibleForTesting
    int getClientsCount() {
        return this.orcaService.clientCount.get();
    }

    public void setUtilizationMetric(String key, double value) {
        this.orcaService.setUtilizationMetric(key, value);
    }

    public void setAllUtilizationMetrics(Map<String, Double> metrics) {
        this.orcaService.setAllUtilizationMetrics(metrics);
    }

    public void deleteUtilizationMetric(String key) {
        this.orcaService.deleteUtilizationMetric(key);
    }

    public void setCpuUtilizationMetric(double value) {
        this.orcaService.setCpuUtilizationMetric(value);
    }

    public void deleteCpuUtilizationMetric() {
        this.orcaService.deleteCpuUtilizationMetric();
    }

    public void setMemoryUtilizationMetric(double value) {
        this.orcaService.setMemoryUtilizationMetric(value);
    }

    public void deleteMemoryUtilizationMetric() {
        this.orcaService.deleteMemoryUtilizationMetric();
    }
}

