/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httpsessions;

import java.net.HttpCookie;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.zaproxy.zap.extension.httpsessions.HttpSessionTokensSet;

public class HttpSession {
    private String name;
    private boolean active;
    private Map<String, Cookie> tokenValues;
    private boolean valid;
    private int messagesMatched;
    private HttpSessionTokensSet tokenNames;

    public HttpSession(String name, HttpSessionTokensSet tokenNames) {
        this.name = name;
        this.active = false;
        this.valid = true;
        this.messagesMatched = 0;
        this.tokenValues = new HashMap<String, Cookie>(1);
        this.tokenNames = tokenNames;
    }

    public HttpSessionTokensSet getTokensNames() {
        return this.tokenNames;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setTokenValue(String tokenName, Cookie value) {
        if (value == null) {
            this.tokenValues.remove(tokenName);
        } else {
            this.tokenValues.put(tokenName, value);
        }
    }

    public String getTokenValue(String tokenName) {
        Cookie ck = this.tokenValues.get(tokenName);
        if (ck != null) {
            return ck.getValue();
        }
        return null;
    }

    public boolean matchesToken(String tokenName, HttpCookie cookie) {
        if (cookie == null) {
            return !this.tokenValues.containsKey(tokenName);
        }
        String tokenValue = this.getTokenValue(tokenName);
        return tokenValue != null && tokenValue.equals(cookie.getValue());
    }

    public void removeToken(String tokenName) {
        this.tokenValues.remove(tokenName);
    }

    public String toString() {
        return "HttpSession [name=" + this.name + ", active=" + this.active + ", tokenValues='" + this.getTokenValuesString() + "']";
    }

    public String getTokenValuesString() {
        if (this.tokenValues.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, Cookie> entry : this.tokenValues.entrySet()) {
            buf.append(entry.getKey()).append('=').append(entry.getValue().getValue()).append(';');
        }
        buf.deleteCharAt(buf.length() - 1);
        return buf.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HttpSession other = (HttpSession)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public boolean isValid() {
        return this.valid;
    }

    public void invalidate() {
        this.valid = false;
    }

    public int getTokenValuesCount() {
        return this.tokenValues.size();
    }

    public Map<String, Cookie> getTokenValuesUnmodifiableMap() {
        return Collections.unmodifiableMap(this.tokenValues);
    }

    public int getMessagesMatched() {
        return this.messagesMatched;
    }

    public void setMessagesMatched(int messagesMatched) {
        this.messagesMatched = messagesMatched;
    }
}

