/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.LocalRepositoryProvider;
import org.eclipse.aether.internal.impl.PrioritizedComponent;
import org.eclipse.aether.internal.impl.PrioritizedComponents;
import org.eclipse.aether.internal.impl.Utils;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class DefaultLocalRepositoryProvider
implements LocalRepositoryProvider,
Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLocalRepositoryProvider.class);
    private Collection<LocalRepositoryManagerFactory> managerFactories = new ArrayList<LocalRepositoryManagerFactory>();

    public DefaultLocalRepositoryProvider() {
    }

    @Inject
    DefaultLocalRepositoryProvider(Set<LocalRepositoryManagerFactory> factories) {
        this.setLocalRepositoryManagerFactories(factories);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setLocalRepositoryManagerFactories(locator.getServices(LocalRepositoryManagerFactory.class));
    }

    public DefaultLocalRepositoryProvider addLocalRepositoryManagerFactory(LocalRepositoryManagerFactory factory) {
        this.managerFactories.add(Objects.requireNonNull(factory, "local repository manager factory cannot be null"));
        return this;
    }

    public DefaultLocalRepositoryProvider setLocalRepositoryManagerFactories(Collection<LocalRepositoryManagerFactory> factories) {
        this.managerFactories = factories == null ? new ArrayList<LocalRepositoryManagerFactory>(2) : factories;
        return this;
    }

    @Override
    public LocalRepositoryManager newLocalRepositoryManager(RepositorySystemSession session2, LocalRepository repository) throws NoLocalRepositoryManagerException {
        Objects.requireNonNull(session2, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        PrioritizedComponents<LocalRepositoryManagerFactory> factories = new PrioritizedComponents<LocalRepositoryManagerFactory>(session2);
        for (LocalRepositoryManagerFactory localRepositoryManagerFactory : this.managerFactories) {
            factories.add(localRepositoryManagerFactory, localRepositoryManagerFactory.getPriority());
        }
        ArrayList<NoLocalRepositoryManagerException> errors2 = new ArrayList<NoLocalRepositoryManagerException>();
        for (PrioritizedComponent prioritizedComponent : factories.getEnabled()) {
            try {
                LocalRepositoryManager manager = ((LocalRepositoryManagerFactory)prioritizedComponent.getComponent()).newInstance(session2, repository);
                if (LOGGER.isDebugEnabled()) {
                    StringBuilder buffer2 = new StringBuilder(256);
                    buffer2.append("Using manager ").append(manager.getClass().getSimpleName());
                    Utils.appendClassLoader(buffer2, manager);
                    buffer2.append(" with priority ").append(prioritizedComponent.getPriority());
                    buffer2.append(" for ").append(repository.getBasedir());
                    LOGGER.debug(buffer2.toString());
                }
                return manager;
            }
            catch (NoLocalRepositoryManagerException e2) {
                errors2.add(e2);
            }
        }
        if (LOGGER.isDebugEnabled() && errors2.size() > 1) {
            for (Exception exception : errors2) {
                LOGGER.debug("Could not obtain local repository manager for {}", (Object)repository, (Object)exception);
            }
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        if (factories.isEmpty()) {
            stringBuilder.append("No local repository managers registered");
        } else {
            stringBuilder.append("Cannot access ").append(repository.getBasedir());
            stringBuilder.append(" with type ").append(repository.getContentType());
            stringBuilder.append(" using the available factories ");
            factories.list(stringBuilder);
        }
        throw new NoLocalRepositoryManagerException(repository, stringBuilder.toString(), errors2.size() == 1 ? (Throwable)errors2.get(0) : null);
    }
}

