/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.impliedmatches;

import ghidra.feature.vt.api.main.VTMatchInfo;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;

public class VTImpliedMatchInfo
extends VTMatchInfo {
    private Reference sourceReference;
    private Reference destinationReference;

    public VTImpliedMatchInfo(VTMatchSet matchSet, Reference sourceRef, Reference destinationRef) {
        super(matchSet);
        this.sourceReference = sourceRef;
        this.destinationReference = destinationRef;
    }

    public Reference getSourceReference() {
        return this.sourceReference;
    }

    public Reference getDestinationReference() {
        return this.destinationReference;
    }

    public Address getSourceReferenceAddress() {
        return this.sourceReference.getFromAddress();
    }

    public Address getDestinationReferenceAddress() {
        return this.destinationReference.getFromAddress();
    }

    public ProgramLocation getSourceReferenceLocation() {
        VTSession session = this.matchSet.getSession();
        Program program = session.getSourceProgram();
        return new OperandFieldLocation(program, this.sourceReference.getFromAddress(), null, this.sourceReference.getToAddress(), "", this.sourceReference.getOperandIndex(), 0);
    }

    public ProgramLocation getDestinationReferenceLocation() {
        VTSession session = this.matchSet.getSession();
        Program program = session.getDestinationProgram();
        return new OperandFieldLocation(program, this.destinationReference.getFromAddress(), null, this.destinationReference.getToAddress(), "", this.destinationReference.getOperandIndex(), 0);
    }
}

