/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.extend;

import ghidra.app.util.bin.format.MemoryLoadable;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfProgramHeader;
import ghidra.app.util.bin.format.elf.ElfSectionHeader;
import ghidra.app.util.bin.format.elf.extend.ElfExtension;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PIC30_ElfExtension
extends ElfExtension {
    public static final int EM_DSPIC30F = 118;
    public static final int SHF_PSV = 0x10000000;

    public boolean canHandle(ElfHeader elf) {
        return elf.e_machine() == 118;
    }

    public boolean canHandle(ElfLoadHelper elfLoadHelper) {
        return this.canHandle(elfLoadHelper.getElfHeader());
    }

    public String getDataTypeSuffix() {
        return "_PIC30";
    }

    public void processElf(ElfLoadHelper elfLoadHelper, TaskMonitor monitor) throws CancelledException {
    }

    public AddressSpace getPreferredSegmentAddressSpace(ElfLoadHelper elfLoadHelper, ElfProgramHeader elfProgramHeader) {
        Language language = elfLoadHelper.getProgram().getLanguage();
        if (this.isDataLoad(elfProgramHeader)) {
            return language.getDefaultDataSpace();
        }
        return language.getDefaultSpace();
    }

    public AddressSpace getPreferredSectionAddressSpace(ElfLoadHelper elfLoadHelper, ElfSectionHeader elfSectionHeader) {
        Language language = elfLoadHelper.getProgram().getLanguage();
        if (this.isDataLoad(elfSectionHeader)) {
            return language.getDefaultDataSpace();
        }
        return language.getDefaultSpace();
    }

    private long getAdjustedDataLoadSize(long dataLoadFileSize) {
        return dataLoadFileSize / 2L;
    }

    private boolean isDataLoad(ElfProgramHeader elfProgramHeader) {
        return !elfProgramHeader.isExecute();
    }

    private boolean isDataLoad(ElfSectionHeader section) {
        if (!section.isAlloc()) {
            return false;
        }
        return !section.isExecutable();
    }

    public long getAdjustedLoadSize(ElfProgramHeader elfProgramHeader) {
        long fileSize = elfProgramHeader.getFileSize();
        return this.isDataLoad(elfProgramHeader) ? this.getAdjustedDataLoadSize(fileSize) : fileSize;
    }

    public long getAdjustedMemorySize(ElfProgramHeader elfProgramHeader) {
        long rawSize = elfProgramHeader.getMemorySize();
        return this.isDataLoad(elfProgramHeader) ? this.getAdjustedDataLoadSize(rawSize) : rawSize;
    }

    public long getAdjustedSize(ElfSectionHeader section) {
        long rawSize = section.getSize();
        return this.isDataLoad(section) ? this.getAdjustedDataLoadSize(rawSize) : rawSize;
    }

    public InputStream getFilteredLoadInputStream(ElfLoadHelper elfLoadHelper, MemoryLoadable loadable, Address start, long dataLength, InputStream dataInput) {
        ElfSectionHeader section;
        Language language = elfLoadHelper.getProgram().getLanguage();
        if (!language.getDefaultDataSpace().equals(start.getAddressSpace().getPhysicalSpace())) {
            return dataInput;
        }
        if (loadable instanceof ElfSectionHeader && ((section = (ElfSectionHeader)loadable).getFlags() & 0x10000000L) != 0L) {
            return new PIC30FilteredPSVDataInputStream(dataInput);
        }
        return new PIC30FilteredDataInputStream(dataInput);
    }

    public boolean hasFilteredLoadInputStream(ElfLoadHelper elfLoadHelper, MemoryLoadable loadable, Address start) {
        Language language = elfLoadHelper.getProgram().getLanguage();
        return language.getDefaultDataSpace().equals(start.getAddressSpace().getPhysicalSpace());
    }

    private static class PIC30FilteredPSVDataInputStream
    extends PIC30FilteredDataInputStream {
        private boolean firstByteToggle = true;

        protected PIC30FilteredPSVDataInputStream(InputStream in) {
            super(in);
        }

        @Override
        protected int readNextByte() throws IOException {
            int r = this.in.read();
            ++this.pos;
            if (!this.firstByteToggle) {
                this.padByteToggle = !this.padByteToggle;
            }
            this.firstByteToggle = !this.firstByteToggle;
            return r;
        }
    }

    private static class PIC30FilteredDataInputStream
    extends FilterInputStream {
        protected boolean padByteToggle = false;
        protected long pos;

        protected PIC30FilteredDataInputStream(InputStream in) {
            super(in);
        }

        protected int readNextByte() throws IOException {
            int r = this.in.read();
            if (this.padByteToggle && r != 0) {
                throw new IOException("expected Data padding byte, pos=" + this.pos);
            }
            ++this.pos;
            this.padByteToggle = !this.padByteToggle;
            return r;
        }

        @Override
        public int read() throws IOException {
            while (this.padByteToggle) {
                int r = this.readNextByte();
                if (r >= 0) continue;
                return r;
            }
            return this.readNextByte();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int c;
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int numRead = -1;
            int i = 1;
            while (i <= len && (c = this.read()) != -1) {
                b[off++] = (byte)c;
                numRead = i++;
            }
            return numRead;
        }
    }
}

