/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.yaffs2;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.yaffs2.YAFFS2Utils;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class YAFFS2Header
implements StructConverter {
    private long objectType;
    private long parentObjectId;
    private short checksum;
    private String fileName;
    private long ystMode;
    private long ystUId;
    private long ystGId;
    private String ystATime;
    private String ystMTime;
    private String ystCTime;
    private long fileSizeLow;
    private long equivId;
    private String aliasFileName;
    private long ystRDev;
    private long winCTime;
    private long winATime;
    private long winMTime;
    private long inbandObjId;
    private long inbandIsShrink;
    private long fileSizeHigh;
    private long shadowsObject;
    private long isShrink;

    public YAFFS2Header(byte[] buffer) {
        this.objectType = YAFFS2Utils.parseInteger(buffer, 0, 4);
        this.parentObjectId = YAFFS2Utils.parseInteger(buffer, 4, 4);
        this.checksum = (short)YAFFS2Utils.parseInteger(buffer, 8, 2);
        this.fileName = YAFFS2Utils.parseName(buffer, 10, 256);
        this.ystMode = YAFFS2Utils.parseInteger(buffer, 268, 4);
        this.ystUId = YAFFS2Utils.parseInteger(buffer, 272, 4);
        this.ystGId = YAFFS2Utils.parseInteger(buffer, 276, 4);
        this.ystATime = YAFFS2Utils.parseDateTime(buffer, 280, 4);
        this.ystMTime = YAFFS2Utils.parseDateTime(buffer, 284, 4);
        this.ystCTime = YAFFS2Utils.parseDateTime(buffer, 288, 4);
        this.fileSizeLow = YAFFS2Utils.parseFileSize(buffer, 292, 4);
        this.equivId = YAFFS2Utils.parseInteger(buffer, 296, 4);
        this.aliasFileName = YAFFS2Utils.parseName(buffer, 300, 160);
        this.ystRDev = YAFFS2Utils.parseInteger(buffer, 460, 4);
        this.winCTime = buffer[464];
        this.winATime = buffer[472];
        this.winMTime = buffer[480];
        this.inbandObjId = YAFFS2Utils.parseInteger(buffer, 488, 4);
        this.inbandIsShrink = YAFFS2Utils.parseInteger(buffer, 492, 4);
        this.fileSizeHigh = YAFFS2Utils.parseInteger(buffer, 496, 4);
        this.shadowsObject = YAFFS2Utils.parseInteger(buffer, 504, 4);
        this.isShrink = YAFFS2Utils.parseInteger(buffer, 508, 4);
    }

    public YAFFS2Header() {
    }

    public long getObjectType() {
        return this.objectType;
    }

    public boolean isDirectory() {
        return this.objectType == 3L;
    }

    public short getChecksum() {
        return this.checksum;
    }

    public String getName() {
        return this.fileName;
    }

    public long getYstMode() {
        return this.ystMode;
    }

    public long getYstUId() {
        return this.ystUId;
    }

    public long getYstGId() {
        return this.ystGId;
    }

    public String getYstATime() {
        return this.ystATime;
    }

    public String getYstMTime() {
        return this.ystMTime;
    }

    public String getYstCTime() {
        return this.ystCTime;
    }

    public long getSize() {
        return this.fileSizeLow;
    }

    public long getEquivId() {
        return this.equivId;
    }

    public String getAliasFileName() {
        return this.aliasFileName;
    }

    public long getYstRDev() {
        return this.ystRDev;
    }

    public long getWinCTime() {
        return this.winCTime;
    }

    public long getWinATime() {
        return this.winATime;
    }

    public long getWinMTime() {
        return this.winMTime;
    }

    public long getInbandObjId() {
        return this.inbandObjId;
    }

    public long getInbandIsShrink() {
        return this.inbandIsShrink;
    }

    public long getFileSizeHigh() {
        return this.fileSizeHigh;
    }

    public long getShadowsObject() {
        return this.shadowsObject;
    }

    public long getIsShrink() {
        return this.isShrink;
    }

    public long getParentObjectId() {
        return this.parentObjectId;
    }

    public boolean isFile() {
        return this.objectType == 1L;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("yaffs2Hdr", 0);
        structure.add(DWORD, "objectType", null);
        structure.add(DWORD, "parentObjectId", null);
        structure.add(WORD, "checksum", null);
        structure.add(STRING, 256, "fileName", null);
        structure.add(WORD, "unknown1", null);
        structure.add(DWORD, "ystMode", null);
        structure.add(DWORD, "ystUId", null);
        structure.add(DWORD, "ystGId", null);
        structure.add(DWORD, "ystATime", null);
        structure.add(DWORD, "ystMTime", null);
        structure.add(DWORD, "ystCTime", null);
        structure.add(DWORD, "fileSizeLow", null);
        structure.add(DWORD, "equivId", null);
        structure.add(STRING, 160, "aliasFileName", null);
        structure.add(DWORD, "ystRDev", null);
        structure.add(QWORD, "winCTime", null);
        structure.add(QWORD, "winATime", null);
        structure.add(QWORD, "winMTime", null);
        structure.add(DWORD, "inbandObjId", null);
        structure.add(DWORD, "inbandIsShrink", null);
        structure.add(DWORD, "fileSizeHigh", null);
        structure.add(DWORD, "reserved", null);
        structure.add(DWORD, "shadowsObject", null);
        structure.add(DWORD, "isShrink", null);
        structure.add((DataType)new ArrayDataType(BYTE, 1536, BYTE.getLength()), "emptyData", null);
        return structure;
    }
}

