/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.label;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

public class RenameLabelCmd
implements Command {
    private Address addr;
    private String oldName;
    private String newName;
    private Namespace currentNamespace;
    private Namespace newNamespace;
    private SourceType source;
    private String errorMsg = "";

    public RenameLabelCmd(Address addr, String oldName, String newName, Namespace currentNamespace, SourceType source) {
        this.addr = addr;
        this.oldName = oldName;
        this.newName = newName;
        this.currentNamespace = currentNamespace;
        this.newNamespace = currentNamespace;
        this.source = source;
    }

    public RenameLabelCmd(Address addr, String oldName, String newName, Namespace currentNamespace, Namespace newNamespace, SourceType source) {
        this(addr, oldName, newName, currentNamespace, source);
        this.newNamespace = newNamespace;
    }

    public RenameLabelCmd(Address addr, String oldName, String newName, SourceType source) {
        this(addr, oldName, newName, null, source);
    }

    public boolean applyTo(DomainObject obj) {
        Program program = (Program)obj;
        if (this.currentNamespace == null) {
            this.currentNamespace = program.getGlobalNamespace();
        }
        if (this.newNamespace == null) {
            this.newNamespace = program.getGlobalNamespace();
        }
        SymbolTable st = ((Program)obj).getSymbolTable();
        Symbol s = null;
        s = this.oldName == null ? st.getPrimarySymbol(this.addr) : st.getSymbol(this.oldName, this.addr, this.currentNamespace);
        if (s == null) {
            this.errorMsg = "Symbol not found: " + this.oldName;
            return false;
        }
        try {
            if (!this.currentNamespace.equals(this.newNamespace)) {
                s.setNameAndNamespace(this.newName, this.newNamespace, this.source);
            } else {
                s.setName(this.newName, this.source);
                if (this.newName.length() != 0 && !this.newName.equals(s.getName()) || this.newName.length() == 0 && s.getSource() != SourceType.DEFAULT) {
                    this.errorMsg = "Rename failed - default names may not be used";
                    return false;
                }
            }
            return true;
        }
        catch (DuplicateNameException e) {
            this.errorMsg = "Symbol already exists: " + this.newName;
        }
        catch (InvalidInputException e) {
            this.errorMsg = "Invalid entry: " + e.getMessage();
        }
        catch (CircularDependencyException e) {
            this.errorMsg = e.getMessage();
        }
        return false;
    }

    public String getName() {
        return "Rename Label";
    }

    public String getStatusMsg() {
        return this.errorMsg;
    }
}

