/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.overview.entropy;

import ghidra.app.plugin.core.overview.entropy.KnotRecord;
import ghidra.app.plugin.core.overview.entropy.Palette;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import javax.swing.JPanel;

public class KnotLabelPanel
extends JPanel {
    private static final Font FONT = new Font("Times New Roman", 1, 16);
    private int topBottomMargin = 10;
    private Palette palette;

    public KnotLabelPanel(int topBottomMargin) {
        this.topBottomMargin = topBottomMargin;
    }

    public void setPalette(Palette palette) {
        this.palette = palette;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int height = this.getHeight() - 2 * this.topBottomMargin;
        int width = this.getWidth();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, width, height);
        int paletteSize = this.palette.getSize();
        g.setFont(FONT);
        FontMetrics fontMetrics = g.getFontMetrics();
        int ascent = fontMetrics.getAscent();
        int descent = fontMetrics.getDescent();
        int fontOffset = ascent / 3;
        ArrayList<KnotRecord> knots = this.palette.getKnots();
        g.setColor(Color.BLACK);
        g.drawLine(5, this.topBottomMargin - 6, 10, this.topBottomMargin - ascent + 2);
        g.drawString("min entropy (0.0)", 20, this.topBottomMargin - ascent - descent);
        g.drawLine(5, this.topBottomMargin + 2, 10, this.topBottomMargin + 2);
        g.drawString("uniform byte values", 20, this.topBottomMargin + ascent / 2);
        for (KnotRecord record : knots) {
            int start = record.start * height / paletteSize;
            int end = record.end * height / paletteSize;
            int y = this.topBottomMargin + (start + end) / 2;
            g.drawString(this.getLabel(record), 20, y + fontOffset);
            g.drawLine(5, y, 10, y);
        }
        g.setColor(Color.BLACK);
        g.drawLine(5, height + this.topBottomMargin + 4, 10, height + this.topBottomMargin + 8);
        g.drawString("max entropy (8.0)", 20, this.topBottomMargin + height + ascent + descent);
    }

    private String getLabel(KnotRecord record) {
        StringBuffer buf = new StringBuffer();
        buf.append(record.name);
        return buf.toString();
    }
}

